/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.beam;

import com.logicalclocks.hsfs.DataSource;
import com.logicalclocks.hsfs.Feature;
import com.logicalclocks.hsfs.FeatureGroupBase;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.HudiOperationType;
import com.logicalclocks.hsfs.JobConfiguration;
import com.logicalclocks.hsfs.OnlineConfig;
import com.logicalclocks.hsfs.StatisticsConfig;
import com.logicalclocks.hsfs.Storage;
import com.logicalclocks.hsfs.StorageConnector;
import com.logicalclocks.hsfs.TimeTravelFormat;
import com.logicalclocks.hsfs.beam.FeatureStore;
import com.logicalclocks.hsfs.beam.engine.BeamProducer;
import com.logicalclocks.hsfs.beam.engine.FeatureGroupEngine;
import com.logicalclocks.hsfs.constructor.QueryBase;
import com.logicalclocks.hsfs.metadata.Statistics;
import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.beam.sdk.values.PCollection;

public class StreamFeatureGroup
extends FeatureGroupBase<PCollection<Object>> {
    protected FeatureGroupEngine featureGroupEngine = new FeatureGroupEngine();

    public StreamFeatureGroup(FeatureStore featureStore, @NonNull String name, Integer version, String description, List<String> primaryKeys, List<String> partitionKeys, String hudiPrecombineKey, boolean onlineEnabled, TimeTravelFormat timeTravelFormat, List<Feature> features, StatisticsConfig statisticsConfig, String onlineTopicName, String eventTime, OnlineConfig onlineConfig, StorageConnector storageConnector, String path) {
        this();
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.featureStore = featureStore;
        this.name = name;
        this.version = version;
        this.description = description;
        this.primaryKeys = primaryKeys != null ? primaryKeys.stream().map(String::toLowerCase).collect(Collectors.toList()) : null;
        this.partitionKeys = partitionKeys != null ? partitionKeys.stream().map(String::toLowerCase).collect(Collectors.toList()) : null;
        this.hudiPrecombineKey = hudiPrecombineKey != null ? hudiPrecombineKey.toLowerCase() : null;
        this.onlineEnabled = onlineEnabled;
        this.timeTravelFormat = timeTravelFormat != null ? timeTravelFormat : TimeTravelFormat.HUDI;
        this.features = features;
        this.statisticsConfig = statisticsConfig != null ? statisticsConfig : new StatisticsConfig();
        this.onlineTopicName = onlineTopicName;
        this.eventTime = eventTime;
        this.onlineConfig = onlineConfig;
        this.storageConnector = storageConnector;
        this.dataSource.setPath(path);
    }

    public StreamFeatureGroup() {
        this.type = "streamFeatureGroupDTO";
        this.dataSource = new DataSource();
    }

    public StreamFeatureGroup(Integer id, String description, List<Feature> features) {
        this();
        this.id = id;
        this.description = description;
        this.features = features;
    }

    public StreamFeatureGroup(FeatureStore featureStore, int id) {
        this();
        this.featureStore = featureStore;
        this.id = id;
    }

    public PCollection<Object> read() throws FeatureStoreException, IOException {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public PCollection<Object> read(boolean online) throws FeatureStoreException, IOException {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public PCollection<Object> read(Map<String, String> readOptions) throws FeatureStoreException, IOException {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public PCollection<Object> read(boolean online, Map<String, String> readOptions) throws FeatureStoreException, IOException {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public PCollection<Object> read(String wallclockTime) throws FeatureStoreException, IOException, ParseException {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public PCollection<Object> read(String wallclockTime, Map<String, String> readOptions) throws FeatureStoreException, IOException, ParseException {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public QueryBase asOf(String wallclockTime) throws FeatureStoreException, ParseException {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public QueryBase asOf(String wallclockTime, String excludeUntil) throws FeatureStoreException, ParseException {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public void show(int numRows) throws FeatureStoreException, IOException {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public void show(int numRows, boolean online) throws FeatureStoreException, IOException {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public void insert(PCollection<Object> featureData) throws IOException, FeatureStoreException, ParseException {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public void insert(PCollection<Object> featureData, Map<String, String> writeOptions) throws FeatureStoreException, IOException, ParseException {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public void insert(PCollection<Object> featureData, Storage storage) throws IOException, FeatureStoreException, ParseException {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public void insert(PCollection<Object> featureData, boolean overwrite) throws IOException, FeatureStoreException, ParseException {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public void insert(PCollection<Object> featureData, Storage storage, boolean overwrite) throws IOException, FeatureStoreException, ParseException {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public void insert(PCollection<Object> featureData, boolean online, Map<String, String> writeOptions) throws FeatureStoreException, IOException, ParseException {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public void insert(PCollection<Object> featureData, HudiOperationType hudiOperationType) throws FeatureStoreException, IOException, ParseException {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public void insert(PCollection<Object> featureData, Storage storage, boolean online, HudiOperationType hudiOperationType, Map<String, String> writeOptions) throws FeatureStoreException, IOException, ParseException {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public void insert(PCollection<Object> featureData, JobConfiguration jobConfiguration) throws FeatureStoreException, IOException, ParseException {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public void insert(PCollection<Object> featureData, boolean online, Map<String, String> writeOptions, JobConfiguration jobConfiguration) throws FeatureStoreException, IOException, ParseException {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public void commitDeleteRecord(PCollection<Object> featureData) throws FeatureStoreException, IOException, ParseException {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public void commitDeleteRecord(PCollection<Object> featureData, Map<String, String> writeOptions) throws FeatureStoreException, IOException, ParseException {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public Map<Long, Map<String, String>> commitDetails() throws IOException, FeatureStoreException, ParseException {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public Map<Long, Map<String, String>> commitDetails(Integer integer) throws IOException, FeatureStoreException, ParseException {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public Map<Long, Map<String, String>> commitDetails(String limit) throws IOException, FeatureStoreException, ParseException {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public Map<Long, Map<String, String>> commitDetails(String wallclockTime, Integer limit) throws IOException, FeatureStoreException, ParseException {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public QueryBase selectFeatures(List<Feature> features) {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public QueryBase select(List<String> features) {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public QueryBase selectAll() {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public QueryBase selectExceptFeatures(List<Feature> features) {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public QueryBase selectExcept(List<String> features) {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public BeamProducer insertStream() throws Exception {
        return this.featureGroupEngine.insertStream(this, null);
    }

    public BeamProducer insertStream(Map<String, String> writeOptions) throws Exception {
        return this.featureGroupEngine.insertStream(this, writeOptions);
    }

    public Object insertStream(PCollection<Object> featureData) throws Exception {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public Object insertStream(PCollection<Object> featureData, String queryName) throws Exception {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public Object insertStream(PCollection<Object> featureData, Map<String, String> writeOptions) throws Exception {
        return null;
    }

    public Object insertStream(PCollection<Object> featureData, String queryName, Map<String, String> writeOptions) throws Exception {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public Object insertStream(PCollection<Object> featureData, String queryName, String outputMode) throws Exception {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public Object insertStream(PCollection<Object> featureData, String queryName, String outputMode, String checkpointLocation) throws Exception {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public Object insertStream(PCollection<Object> featureData, String queryName, String outputMode, boolean awaitTermination, Long timeout) throws Exception {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public Object insertStream(PCollection<Object> featureData, String queryName, String outputMode, boolean awaitTermination, Long timeout, String checkpointLocation) throws Exception {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public Object insertStream(PCollection<Object> featureData, String queryName, String outputMode, boolean awaitTermination, Long timeout, String checkpointLocation, Map<String, String> writeOptions) throws Exception {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public Object insertStream(PCollection<Object> featureData, String queryName, String outputMode, boolean awaitTermination, String checkpointLocation) throws Exception {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public Object insertStream(PCollection<Object> featureData, String queryName, String outputMode, boolean awaitTermination, Long timeout, String checkpointLocation, Map<String, String> writeOptions, JobConfiguration jobConfiguration) throws Exception {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public void updateFeatures(List<Feature> feature) throws FeatureStoreException, IOException, ParseException {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public void updateFeatures(Feature feature) throws FeatureStoreException, IOException, ParseException {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public void appendFeatures(List<Feature> feature) throws FeatureStoreException, IOException, ParseException {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public void appendFeatures(Feature feature) throws FeatureStoreException, IOException, ParseException {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public Statistics computeStatistics() throws FeatureStoreException, IOException, ParseException {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public Statistics computeStatistics(String wallclockTime) throws FeatureStoreException, IOException, ParseException {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public Statistics getStatistics() throws FeatureStoreException, IOException {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public static StreamFeatureGroupBuilder builder() {
        return new StreamFeatureGroupBuilder();
    }

    public static class StreamFeatureGroupBuilder {
        private FeatureStore featureStore;
        private String name;
        private Integer version;
        private String description;
        private List<String> primaryKeys;
        private List<String> partitionKeys;
        private String hudiPrecombineKey;
        private boolean onlineEnabled;
        private TimeTravelFormat timeTravelFormat;
        private List<Feature> features;
        private StatisticsConfig statisticsConfig;
        private String onlineTopicName;
        private String eventTime;
        private OnlineConfig onlineConfig;
        private StorageConnector storageConnector;
        private String path;

        StreamFeatureGroupBuilder() {
        }

        public StreamFeatureGroupBuilder featureStore(FeatureStore featureStore) {
            this.featureStore = featureStore;
            return this;
        }

        public StreamFeatureGroupBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public StreamFeatureGroupBuilder version(Integer version) {
            this.version = version;
            return this;
        }

        public StreamFeatureGroupBuilder description(String description) {
            this.description = description;
            return this;
        }

        public StreamFeatureGroupBuilder primaryKeys(List<String> primaryKeys) {
            this.primaryKeys = primaryKeys;
            return this;
        }

        public StreamFeatureGroupBuilder partitionKeys(List<String> partitionKeys) {
            this.partitionKeys = partitionKeys;
            return this;
        }

        public StreamFeatureGroupBuilder hudiPrecombineKey(String hudiPrecombineKey) {
            this.hudiPrecombineKey = hudiPrecombineKey;
            return this;
        }

        public StreamFeatureGroupBuilder onlineEnabled(boolean onlineEnabled) {
            this.onlineEnabled = onlineEnabled;
            return this;
        }

        public StreamFeatureGroupBuilder timeTravelFormat(TimeTravelFormat timeTravelFormat) {
            this.timeTravelFormat = timeTravelFormat;
            return this;
        }

        public StreamFeatureGroupBuilder features(List<Feature> features) {
            this.features = features;
            return this;
        }

        public StreamFeatureGroupBuilder statisticsConfig(StatisticsConfig statisticsConfig) {
            this.statisticsConfig = statisticsConfig;
            return this;
        }

        public StreamFeatureGroupBuilder onlineTopicName(String onlineTopicName) {
            this.onlineTopicName = onlineTopicName;
            return this;
        }

        public StreamFeatureGroupBuilder eventTime(String eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public StreamFeatureGroupBuilder onlineConfig(OnlineConfig onlineConfig) {
            this.onlineConfig = onlineConfig;
            return this;
        }

        public StreamFeatureGroupBuilder storageConnector(StorageConnector storageConnector) {
            this.storageConnector = storageConnector;
            return this;
        }

        public StreamFeatureGroupBuilder path(String path) {
            this.path = path;
            return this;
        }

        public StreamFeatureGroup build() {
            return new StreamFeatureGroup(this.featureStore, this.name, this.version, this.description, this.primaryKeys, this.partitionKeys, this.hudiPrecombineKey, this.onlineEnabled, this.timeTravelFormat, this.features, this.statisticsConfig, this.onlineTopicName, this.eventTime, this.onlineConfig, this.storageConnector, this.path);
        }

        public String toString() {
            return "StreamFeatureGroup.StreamFeatureGroupBuilder(featureStore=" + (Object)((Object)this.featureStore) + ", name=" + this.name + ", version=" + this.version + ", description=" + this.description + ", primaryKeys=" + this.primaryKeys + ", partitionKeys=" + this.partitionKeys + ", hudiPrecombineKey=" + this.hudiPrecombineKey + ", onlineEnabled=" + this.onlineEnabled + ", timeTravelFormat=" + this.timeTravelFormat + ", features=" + this.features + ", statisticsConfig=" + this.statisticsConfig + ", onlineTopicName=" + this.onlineTopicName + ", eventTime=" + this.eventTime + ", onlineConfig=" + this.onlineConfig + ", storageConnector=" + this.storageConnector + ", path=" + this.path + ")";
        }
    }
}

