/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.beam.engine;

import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.FeatureViewBase;
import com.logicalclocks.hsfs.beam.FeatureStore;
import com.logicalclocks.hsfs.beam.FeatureView;
import com.logicalclocks.hsfs.beam.StreamFeatureGroup;
import com.logicalclocks.hsfs.beam.constructor.Query;
import com.logicalclocks.hsfs.engine.FeatureViewEngineBase;
import java.io.IOException;
import java.util.List;
import org.apache.beam.sdk.values.PCollection;

public class FeatureViewEngine
extends FeatureViewEngineBase<Query, FeatureView, FeatureStore, StreamFeatureGroup, PCollection<Object>> {
    public FeatureView update(FeatureView featureView) throws FeatureStoreException, IOException {
        this.featureViewApi.update((FeatureViewBase)featureView, FeatureView.class);
        return featureView;
    }

    public FeatureView get(FeatureStore featureStore, String name, Integer version) throws FeatureStoreException, IOException {
        FeatureView featureView = (FeatureView)this.get(featureStore, name, version, FeatureView.class);
        featureView.setFeatureStore(featureStore);
        return featureView;
    }

    public FeatureView getOrCreateFeatureView(FeatureStore featureStore, String name, Integer version, Query query, String description, List<String> labels) throws FeatureStoreException, IOException {
        FeatureView featureView;
        try {
            featureView = (FeatureView)this.get(featureStore, name, version, FeatureView.class);
        }
        catch (FeatureStoreException | IOException e) {
            if (e.getMessage().contains("Error: 404") && e.getMessage().contains("\"errorCode\":270181")) {
                featureView = new FeatureView.FeatureViewBuilder(featureStore).name(name).version(version).query(query).description(description).labels(labels).build();
            }
            throw e;
        }
        return featureView;
    }
}

