/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.beam;

import com.logicalclocks.hsfs.DataSource;
import com.logicalclocks.hsfs.Feature;
import com.logicalclocks.hsfs.FeatureGroupBase;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.JobConfiguration;
import com.logicalclocks.hsfs.OnlineConfig;
import com.logicalclocks.hsfs.StatisticsConfig;
import com.logicalclocks.hsfs.StorageConnector;
import com.logicalclocks.hsfs.TimeTravelFormat;
import com.logicalclocks.hsfs.beam.FeatureStore;
import com.logicalclocks.hsfs.beam.constructor.Query;
import com.logicalclocks.hsfs.beam.engine.BeamProducer;
import com.logicalclocks.hsfs.beam.engine.FeatureGroupEngine;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.beam.sdk.values.PCollection;

public class StreamFeatureGroup
extends FeatureGroupBase<PCollection<Object>> {
    protected FeatureGroupEngine featureGroupEngine = new FeatureGroupEngine();

    public StreamFeatureGroup(FeatureStore featureStore, @NonNull String name, Integer version, String description, List<String> primaryKeys, List<String> partitionKeys, String hudiPrecombineKey, boolean onlineEnabled, TimeTravelFormat timeTravelFormat, List<Feature> features, StatisticsConfig statisticsConfig, String onlineTopicName, String eventTime, OnlineConfig onlineConfig, StorageConnector storageConnector, String path) {
        this();
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.featureStore = featureStore;
        this.name = name;
        this.version = version;
        this.description = description;
        this.primaryKeys = primaryKeys != null ? primaryKeys.stream().map(String::toLowerCase).collect(Collectors.toList()) : null;
        this.partitionKeys = partitionKeys != null ? partitionKeys.stream().map(String::toLowerCase).collect(Collectors.toList()) : null;
        this.hudiPrecombineKey = hudiPrecombineKey != null ? hudiPrecombineKey.toLowerCase() : null;
        this.onlineEnabled = onlineEnabled;
        this.timeTravelFormat = timeTravelFormat != null ? timeTravelFormat : TimeTravelFormat.HUDI;
        this.features = features;
        this.statisticsConfig = statisticsConfig != null ? statisticsConfig : new StatisticsConfig();
        this.onlineTopicName = onlineTopicName;
        this.eventTime = eventTime;
        this.onlineConfig = onlineConfig;
        this.storageConnector = storageConnector;
        this.dataSource.setPath(path);
    }

    public StreamFeatureGroup() {
        this.type = "streamFeatureGroupDTO";
        this.dataSource = new DataSource();
    }

    public StreamFeatureGroup(Integer id, String description, List<Feature> features) {
        this();
        this.id = id;
        this.description = description;
        this.features = features;
    }

    public StreamFeatureGroup(FeatureStore featureStore, int id) {
        this();
        this.featureStore = featureStore;
        this.id = id;
    }

    public void save() throws FeatureStoreException, IOException {
        this.save(null, null);
    }

    public void save(Map<String, String> writeOptions, JobConfiguration materializationJobConfiguration) throws FeatureStoreException, IOException {
        this.featureGroupEngine.save(this, this.partitionKeys, this.hudiPrecombineKey, writeOptions, materializationJobConfiguration);
    }

    public BeamProducer insertStream() throws Exception {
        return this.featureGroupEngine.insertStream(this, null);
    }

    public BeamProducer insertStream(Map<String, String> writeOptions) throws Exception {
        return this.featureGroupEngine.insertStream(this, writeOptions);
    }

    public Object insertStream(PCollection<Object> featureData) throws Exception {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public Object insertStream(PCollection<Object> featureData, Map<String, String> writeOptions) throws Exception {
        throw new UnsupportedOperationException("Not supported for Beam");
    }

    public Query selectFeatures(List<Feature> features) {
        return new Query(this, features);
    }

    public Query select(List<String> features) {
        List<Feature> featureObjList = features.stream().map(Feature::new).collect(Collectors.toList());
        return this.selectFeatures(featureObjList);
    }

    public Query selectAll() {
        return new Query(this, this.getFeatures());
    }

    public Query selectExceptFeatures(List<Feature> features) {
        List<String> exceptFeatures = features.stream().map(Feature::getName).collect(Collectors.toList());
        return this.selectExcept(exceptFeatures);
    }

    public Query selectExcept(List<String> features) {
        return new Query(this, this.getFeatures().stream().filter(f -> !features.contains(f.getName())).collect(Collectors.toList()));
    }

    @Generated
    public static StreamFeatureGroupBuilder builder() {
        return new StreamFeatureGroupBuilder();
    }

    @Generated
    public static class StreamFeatureGroupBuilder {
        @Generated
        private FeatureStore featureStore;
        @Generated
        private String name;
        @Generated
        private Integer version;
        @Generated
        private String description;
        @Generated
        private List<String> primaryKeys;
        @Generated
        private List<String> partitionKeys;
        @Generated
        private String hudiPrecombineKey;
        @Generated
        private boolean onlineEnabled;
        @Generated
        private TimeTravelFormat timeTravelFormat;
        @Generated
        private List<Feature> features;
        @Generated
        private StatisticsConfig statisticsConfig;
        @Generated
        private String onlineTopicName;
        @Generated
        private String eventTime;
        @Generated
        private OnlineConfig onlineConfig;
        @Generated
        private StorageConnector storageConnector;
        @Generated
        private String path;

        @Generated
        StreamFeatureGroupBuilder() {
        }

        @Generated
        public StreamFeatureGroupBuilder featureStore(FeatureStore featureStore) {
            this.featureStore = featureStore;
            return this;
        }

        @Generated
        public StreamFeatureGroupBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @Generated
        public StreamFeatureGroupBuilder version(Integer version) {
            this.version = version;
            return this;
        }

        @Generated
        public StreamFeatureGroupBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public StreamFeatureGroupBuilder primaryKeys(List<String> primaryKeys) {
            this.primaryKeys = primaryKeys;
            return this;
        }

        @Generated
        public StreamFeatureGroupBuilder partitionKeys(List<String> partitionKeys) {
            this.partitionKeys = partitionKeys;
            return this;
        }

        @Generated
        public StreamFeatureGroupBuilder hudiPrecombineKey(String hudiPrecombineKey) {
            this.hudiPrecombineKey = hudiPrecombineKey;
            return this;
        }

        @Generated
        public StreamFeatureGroupBuilder onlineEnabled(boolean onlineEnabled) {
            this.onlineEnabled = onlineEnabled;
            return this;
        }

        @Generated
        public StreamFeatureGroupBuilder timeTravelFormat(TimeTravelFormat timeTravelFormat) {
            this.timeTravelFormat = timeTravelFormat;
            return this;
        }

        @Generated
        public StreamFeatureGroupBuilder features(List<Feature> features) {
            this.features = features;
            return this;
        }

        @Generated
        public StreamFeatureGroupBuilder statisticsConfig(StatisticsConfig statisticsConfig) {
            this.statisticsConfig = statisticsConfig;
            return this;
        }

        @Generated
        public StreamFeatureGroupBuilder onlineTopicName(String onlineTopicName) {
            this.onlineTopicName = onlineTopicName;
            return this;
        }

        @Generated
        public StreamFeatureGroupBuilder eventTime(String eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        @Generated
        public StreamFeatureGroupBuilder onlineConfig(OnlineConfig onlineConfig) {
            this.onlineConfig = onlineConfig;
            return this;
        }

        @Generated
        public StreamFeatureGroupBuilder storageConnector(StorageConnector storageConnector) {
            this.storageConnector = storageConnector;
            return this;
        }

        @Generated
        public StreamFeatureGroupBuilder path(String path) {
            this.path = path;
            return this;
        }

        @Generated
        public StreamFeatureGroup build() {
            return new StreamFeatureGroup(this.featureStore, this.name, this.version, this.description, this.primaryKeys, this.partitionKeys, this.hudiPrecombineKey, this.onlineEnabled, this.timeTravelFormat, this.features, this.statisticsConfig, this.onlineTopicName, this.eventTime, this.onlineConfig, this.storageConnector, this.path);
        }

        @Generated
        public String toString() {
            return "StreamFeatureGroup.StreamFeatureGroupBuilder(featureStore=" + (Object)((Object)this.featureStore) + ", name=" + this.name + ", version=" + this.version + ", description=" + this.description + ", primaryKeys=" + this.primaryKeys + ", partitionKeys=" + this.partitionKeys + ", hudiPrecombineKey=" + this.hudiPrecombineKey + ", onlineEnabled=" + this.onlineEnabled + ", timeTravelFormat=" + this.timeTravelFormat + ", features=" + this.features + ", statisticsConfig=" + this.statisticsConfig + ", onlineTopicName=" + this.onlineTopicName + ", eventTime=" + this.eventTime + ", onlineConfig=" + this.onlineConfig + ", storageConnector=" + this.storageConnector + ", path=" + this.path + ")";
        }
    }
}

