/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.flink.engine;

import com.google.common.base.Strings;
import com.logicalclocks.hsfs.FeatureGroupBase;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.StorageConnector;
import com.logicalclocks.hsfs.engine.EngineBase;
import com.logicalclocks.hsfs.flink.StreamFeatureGroup;
import com.logicalclocks.hsfs.flink.engine.KafkaRecordSerializer;
import com.logicalclocks.hsfs.flink.engine.PojoToAvroRecord;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.connector.base.DeliveryGuarantee;
import org.apache.flink.connector.kafka.sink.KafkaRecordSerializationSchema;
import org.apache.flink.connector.kafka.sink.KafkaSink;
import org.apache.flink.core.fs.Path;
import org.apache.flink.formats.avro.typeutils.GenericRecordAvroTypeInfo;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.util.FileUtils;

public class FlinkEngine
extends EngineBase {
    private static FlinkEngine INSTANCE = null;
    private StreamExecutionEnvironment streamExecutionEnvironment = StreamExecutionEnvironment.getExecutionEnvironment();

    public static synchronized FlinkEngine getInstance() throws FeatureStoreException {
        if (INSTANCE == null) {
            INSTANCE = new FlinkEngine();
        }
        return INSTANCE;
    }

    private FlinkEngine() throws FeatureStoreException {
        this.streamExecutionEnvironment.getConfig().enableObjectReuse();
    }

    public DataStreamSink<?> writeDataStream(StreamFeatureGroup streamFeatureGroup, DataStream<?> dataStream, Map<String, String> writeOptions) throws FeatureStoreException, IOException {
        DataStream<?> genericDataStream = dataStream;
        Properties properties = new Properties();
        properties.putAll(this.getKafkaConfig(streamFeatureGroup, writeOptions));
        KafkaSink sink = KafkaSink.builder().setBootstrapServers(properties.getProperty("bootstrap.servers")).setKafkaProducerConfig(properties).setRecordSerializer((KafkaRecordSerializationSchema)new KafkaRecordSerializer(streamFeatureGroup)).setDeliverGuarantee(DeliveryGuarantee.AT_LEAST_ONCE).build();
        HashMap<String, String> complexFeatureSchemas = new HashMap<String, String>();
        for (String featureName : streamFeatureGroup.getComplexFeatures()) {
            complexFeatureSchemas.put(featureName, streamFeatureGroup.getFeatureAvroSchema(featureName));
        }
        SingleOutputStreamOperator avroRecordDataStream = genericDataStream.map(new PojoToAvroRecord(streamFeatureGroup.getDeserializedAvroSchema(), streamFeatureGroup.getDeserializedEncodedAvroSchema(), complexFeatureSchemas)).returns((TypeInformation)new GenericRecordAvroTypeInfo(streamFeatureGroup.getDeserializedEncodedAvroSchema()));
        return avroRecordDataStream.sinkTo((Sink)sink);
    }

    public String addFile(String filePath) throws IOException {
        if (Strings.isNullOrEmpty((String)filePath)) {
            return filePath;
        }
        if (!filePath.startsWith("file://")) {
            filePath = "hdfs://" + filePath;
        }
        String targetPath = FileUtils.getCurrentWorkingDirectory().toString() + filePath.substring(filePath.lastIndexOf("/"));
        FileUtils.copy((Path)new Path(filePath), (Path)new Path(targetPath), (boolean)false);
        return targetPath;
    }

    public Map<String, String> getKafkaConfig(FeatureGroupBase featureGroup, Map<String, String> writeOptions) throws FeatureStoreException, IOException {
        boolean external = !System.getProperties().containsKey("hopsworks.restendpoint") && (writeOptions == null || !Boolean.parseBoolean(writeOptions.getOrDefault("internal_kafka", "false")));
        StorageConnector.KafkaConnector storageConnector = this.storageConnectorApi.getKafkaStorageConnector(featureGroup.getFeatureStore(), external);
        storageConnector.setSslTruststoreLocation(this.addFile(storageConnector.getSslTruststoreLocation()));
        storageConnector.setSslKeystoreLocation(this.addFile(storageConnector.getSslKeystoreLocation()));
        Map config = storageConnector.kafkaOptions();
        if (writeOptions != null) {
            config.putAll(writeOptions);
        }
        config.put("enable.idempotence", "false");
        return config;
    }

    public StreamExecutionEnvironment getStreamExecutionEnvironment() {
        return this.streamExecutionEnvironment;
    }
}

