/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.flink;

import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.HopsworksConnectionBase;
import com.logicalclocks.hsfs.SecretStore;
import com.logicalclocks.hsfs.flink.FeatureStore;
import com.logicalclocks.hsfs.metadata.Credentials;
import com.logicalclocks.hsfs.metadata.HopsworksClient;
import com.logicalclocks.hsfs.metadata.HopsworksHttpClient;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import software.amazon.awssdk.regions.Region;

public class HopsworksConnection
extends HopsworksConnectionBase {
    public HopsworksConnection(String host, int port, String project, Region region, SecretStore secretStore, boolean hostnameVerification, String trustStorePath, String certPath, String apiKeyFilePath, String apiKeyValue) throws IOException, FeatureStoreException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        this.host = host;
        this.port = port;
        this.project = this.getProjectName(project);
        this.region = region;
        this.secretStore = secretStore;
        this.hostnameVerification = hostnameVerification;
        this.trustStorePath = trustStorePath;
        this.certPath = certPath;
        this.apiKeyFilePath = apiKeyFilePath;
        this.apiKeyValue = apiKeyValue;
        HopsworksClient.setupHopsworksClient((String)host, (int)port, (Region)region, (SecretStore)secretStore, (boolean)hostnameVerification, (String)trustStorePath, (String)this.apiKeyFilePath, (String)this.apiKeyValue);
        this.projectObj = this.getProject();
        HopsworksClient.getInstance().setProject(this.projectObj);
        if (!System.getProperties().containsKey("hopsworks.restendpoint")) {
            Credentials credentials = HopsworksClient.getInstance().getCredentials();
            HopsworksHttpClient hopsworksHttpClient = HopsworksClient.getInstance().getHopsworksHttpClient();
            hopsworksHttpClient.setTrustStorePath(credentials.gettStore());
            hopsworksHttpClient.setKeyStorePath(credentials.getkStore());
            hopsworksHttpClient.setCertKey(credentials.getPassword());
            HopsworksClient.getInstance().setHopsworksHttpClient(hopsworksHttpClient);
        }
    }

    public FeatureStore getFeatureStore() throws IOException, FeatureStoreException {
        return this.getFeatureStore(this.rewriteFeatureStoreName(this.project));
    }

    public FeatureStore getFeatureStore(String name) throws IOException, FeatureStoreException {
        return (FeatureStore)((Object)this.featureStoreApi.get(this.rewriteFeatureStoreName(name), FeatureStore.class));
    }

    public static HopsworksConnectionBuilder builder() {
        return new HopsworksConnectionBuilder();
    }

    public static class HopsworksConnectionBuilder {
        private String host;
        private int port;
        private String project;
        private Region region;
        private SecretStore secretStore;
        private boolean hostnameVerification;
        private String trustStorePath;
        private String certPath;
        private String apiKeyFilePath;
        private String apiKeyValue;

        HopsworksConnectionBuilder() {
        }

        public HopsworksConnectionBuilder host(String host) {
            this.host = host;
            return this;
        }

        public HopsworksConnectionBuilder port(int port) {
            this.port = port;
            return this;
        }

        public HopsworksConnectionBuilder project(String project) {
            this.project = project;
            return this;
        }

        public HopsworksConnectionBuilder region(Region region) {
            this.region = region;
            return this;
        }

        public HopsworksConnectionBuilder secretStore(SecretStore secretStore) {
            this.secretStore = secretStore;
            return this;
        }

        public HopsworksConnectionBuilder hostnameVerification(boolean hostnameVerification) {
            this.hostnameVerification = hostnameVerification;
            return this;
        }

        public HopsworksConnectionBuilder trustStorePath(String trustStorePath) {
            this.trustStorePath = trustStorePath;
            return this;
        }

        public HopsworksConnectionBuilder certPath(String certPath) {
            this.certPath = certPath;
            return this;
        }

        public HopsworksConnectionBuilder apiKeyFilePath(String apiKeyFilePath) {
            this.apiKeyFilePath = apiKeyFilePath;
            return this;
        }

        public HopsworksConnectionBuilder apiKeyValue(String apiKeyValue) {
            this.apiKeyValue = apiKeyValue;
            return this;
        }

        public HopsworksConnection build() throws IOException, FeatureStoreException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
            return new HopsworksConnection(this.host, this.port, this.project, this.region, this.secretStore, this.hostnameVerification, this.trustStorePath, this.certPath, this.apiKeyFilePath, this.apiKeyValue);
        }

        public String toString() {
            return "HopsworksConnection.HopsworksConnectionBuilder(host=" + this.host + ", port=" + this.port + ", project=" + this.project + ", region=" + this.region + ", secretStore=" + this.secretStore + ", hostnameVerification=" + this.hostnameVerification + ", trustStorePath=" + this.trustStorePath + ", certPath=" + this.certPath + ", apiKeyFilePath=" + this.apiKeyFilePath + ", apiKeyValue=" + this.apiKeyValue + ")";
        }
    }
}

