/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.flink;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.logicalclocks.hsfs.Feature;
import com.logicalclocks.hsfs.FeatureGroupBase;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.HudiOperationType;
import com.logicalclocks.hsfs.JobConfiguration;
import com.logicalclocks.hsfs.OnlineConfig;
import com.logicalclocks.hsfs.StatisticsConfig;
import com.logicalclocks.hsfs.Storage;
import com.logicalclocks.hsfs.StorageConnector;
import com.logicalclocks.hsfs.TimeTravelFormat;
import com.logicalclocks.hsfs.constructor.QueryBase;
import com.logicalclocks.hsfs.flink.FeatureStore;
import com.logicalclocks.hsfs.flink.engine.FeatureGroupEngine;
import com.logicalclocks.hsfs.metadata.Statistics;
import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;

@JsonIgnoreProperties(ignoreUnknown=true)
public class StreamFeatureGroup
extends FeatureGroupBase<DataStream<?>> {
    protected FeatureGroupEngine featureGroupEngine = new FeatureGroupEngine();

    public StreamFeatureGroup(FeatureStore featureStore, @NonNull String name, Integer version, String description, List<String> primaryKeys, List<String> partitionKeys, String hudiPrecombineKey, boolean onlineEnabled, TimeTravelFormat timeTravelFormat, List<Feature> features, StatisticsConfig statisticsConfig, String onlineTopicName, String topicName, String notificationTopicName, String eventTime, OnlineConfig onlineConfig, StorageConnector storageConnector, String path) {
        this();
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.featureStore = featureStore;
        this.name = name;
        this.version = version;
        this.description = description;
        this.primaryKeys = primaryKeys != null ? primaryKeys.stream().map(String::toLowerCase).collect(Collectors.toList()) : null;
        this.partitionKeys = partitionKeys != null ? partitionKeys.stream().map(String::toLowerCase).collect(Collectors.toList()) : null;
        this.hudiPrecombineKey = hudiPrecombineKey != null ? hudiPrecombineKey.toLowerCase() : null;
        this.onlineEnabled = onlineEnabled;
        this.timeTravelFormat = timeTravelFormat != null ? timeTravelFormat : TimeTravelFormat.HUDI;
        this.features = features;
        this.statisticsConfig = statisticsConfig != null ? statisticsConfig : new StatisticsConfig();
        this.onlineTopicName = onlineTopicName;
        this.topicName = topicName;
        this.notificationTopicName = notificationTopicName;
        this.eventTime = eventTime;
        this.onlineConfig = onlineConfig;
        this.storageConnector = storageConnector;
        this.path = path;
    }

    public StreamFeatureGroup() {
        this.type = "streamFeatureGroupDTO";
    }

    public StreamFeatureGroup(Integer id, String description, List<Feature> features) {
        this();
        this.id = id;
        this.description = description;
        this.features = features;
    }

    public StreamFeatureGroup(FeatureStore featureStore, int id) {
        this();
        this.featureStore = featureStore;
        this.id = id;
    }

    public DataStream<?> read() throws FeatureStoreException, IOException {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public DataStream<?> read(boolean online) throws FeatureStoreException, IOException {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public DataStream<?> read(Map<String, String> readOptions) throws FeatureStoreException, IOException {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public DataStream<?> read(boolean online, Map<String, String> readOptions) throws FeatureStoreException, IOException {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public DataStream<?> read(String wallclockTime) throws FeatureStoreException, IOException, ParseException {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public DataStream<?> read(String wallclockTime, Map<String, String> readOptions) throws FeatureStoreException, IOException, ParseException {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public QueryBase asOf(String wallclockTime) throws FeatureStoreException, ParseException {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public QueryBase asOf(String wallclockTime, String excludeUntil) throws FeatureStoreException, ParseException {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public void show(int numRows) throws FeatureStoreException, IOException {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public void show(int numRows, boolean online) throws FeatureStoreException, IOException {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public void insert(DataStream<?> featureData) throws IOException, FeatureStoreException, ParseException {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public void insert(DataStream<?> featureData, Map<String, String> writeOptions) throws FeatureStoreException, IOException, ParseException {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public void insert(DataStream<?> featureData, Storage storage) throws IOException, FeatureStoreException, ParseException {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public void insert(DataStream<?> featureData, boolean overwrite) throws IOException, FeatureStoreException, ParseException {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public void insert(DataStream<?> featureData, Storage storage, boolean overwrite) throws IOException, FeatureStoreException, ParseException {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public void insert(DataStream<?> featureData, boolean online, Map<String, String> writeOptions) throws FeatureStoreException, IOException, ParseException {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public void insert(DataStream<?> featureData, HudiOperationType hudiOperationType) throws FeatureStoreException, IOException, ParseException {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public void insert(DataStream<?> featureData, Storage storage, boolean online, HudiOperationType hudiOperationType, Map<String, String> writeOptions) throws FeatureStoreException, IOException, ParseException {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public void insert(DataStream<?> featureData, JobConfiguration jobConfiguration) throws FeatureStoreException, IOException, ParseException {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public void insert(DataStream<?> featureData, boolean online, Map<String, String> writeOptions, JobConfiguration jobConfiguration) throws FeatureStoreException, IOException, ParseException {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public void commitDeleteRecord(DataStream<?> featureData) throws FeatureStoreException, IOException, ParseException {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public void commitDeleteRecord(DataStream<?> featureData, Map<String, String> writeOptions) throws FeatureStoreException, IOException, ParseException {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public Map<Long, Map<String, String>> commitDetails() throws IOException, FeatureStoreException, ParseException {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public Map<Long, Map<String, String>> commitDetails(Integer integer) throws IOException, FeatureStoreException, ParseException {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public Map<Long, Map<String, String>> commitDetails(String limit) throws IOException, FeatureStoreException, ParseException {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public Map<Long, Map<String, String>> commitDetails(String wallclockTime, Integer limit) throws IOException, FeatureStoreException, ParseException {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public QueryBase selectFeatures(List<Feature> features) {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public QueryBase select(List<String> features) {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public QueryBase selectAll() {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public QueryBase selectExceptFeatures(List<Feature> features) {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public QueryBase selectExcept(List<String> features) {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public DataStreamSink<?> insertStream(DataStream<?> featureData) throws Exception {
        return this.featureGroupEngine.insertStream(this, featureData, null);
    }

    public DataStreamSink<?> insertStream(DataStream<?> featureData, Map<String, String> writeOptions) throws Exception {
        return this.featureGroupEngine.insertStream(this, featureData, writeOptions);
    }

    public Object insertStream(DataStream<?> featureData, String queryName) throws Exception {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public Object insertStream(DataStream<?> featureData, String queryName, Map<String, String> writeOptions) throws Exception {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public Object insertStream(DataStream<?> featureData, String queryName, String outputMode) throws Exception {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public Object insertStream(DataStream<?> featureData, String queryName, String outputMode, String checkpointLocation) throws Exception {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public Object insertStream(DataStream<?> featureData, String queryName, String outputMode, boolean awaitTermination, Long timeout) throws Exception {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public Object insertStream(DataStream<?> featureData, String queryName, String outputMode, boolean awaitTermination, Long timeout, String checkpointLocation) throws Exception {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public Object insertStream(DataStream<?> featureData, String queryName, String outputMode, boolean awaitTermination, Long timeout, String checkpointLocation, Map<String, String> writeOptions) throws Exception {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public Object insertStream(DataStream<?> featureData, String queryName, String outputMode, boolean awaitTermination, String checkpointLocation) throws Exception {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public Object insertStream(DataStream<?> featureData, String queryName, String outputMode, boolean awaitTermination, Long timeout, String checkpointLocation, Map<String, String> writeOptions, JobConfiguration jobConfiguration) throws Exception {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public void updateFeatures(Feature feature) throws FeatureStoreException, IOException, ParseException {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public void updateFeatures(List<Feature> feature) throws FeatureStoreException, IOException, ParseException {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public void appendFeatures(List<Feature> feature) throws FeatureStoreException, IOException, ParseException {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public void appendFeatures(Feature feature) throws FeatureStoreException, IOException, ParseException {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public Statistics computeStatistics() throws FeatureStoreException, IOException, ParseException {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public Statistics computeStatistics(String wallclockTime) throws FeatureStoreException, IOException, ParseException {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public Statistics getStatistics() throws FeatureStoreException, IOException {
        throw new UnsupportedOperationException("Not supported for Flink");
    }

    public static StreamFeatureGroupBuilder builder() {
        return new StreamFeatureGroupBuilder();
    }

    public StreamFeatureGroup(FeatureGroupEngine featureGroupEngine) {
        this.featureGroupEngine = featureGroupEngine;
    }

    public static class StreamFeatureGroupBuilder {
        private FeatureStore featureStore;
        private String name;
        private Integer version;
        private String description;
        private List<String> primaryKeys;
        private List<String> partitionKeys;
        private String hudiPrecombineKey;
        private boolean onlineEnabled;
        private TimeTravelFormat timeTravelFormat;
        private List<Feature> features;
        private StatisticsConfig statisticsConfig;
        private String onlineTopicName;
        private String topicName;
        private String notificationTopicName;
        private String eventTime;
        private OnlineConfig onlineConfig;
        private StorageConnector storageConnector;
        private String path;

        StreamFeatureGroupBuilder() {
        }

        public StreamFeatureGroupBuilder featureStore(FeatureStore featureStore) {
            this.featureStore = featureStore;
            return this;
        }

        public StreamFeatureGroupBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public StreamFeatureGroupBuilder version(Integer version) {
            this.version = version;
            return this;
        }

        public StreamFeatureGroupBuilder description(String description) {
            this.description = description;
            return this;
        }

        public StreamFeatureGroupBuilder primaryKeys(List<String> primaryKeys) {
            this.primaryKeys = primaryKeys;
            return this;
        }

        public StreamFeatureGroupBuilder partitionKeys(List<String> partitionKeys) {
            this.partitionKeys = partitionKeys;
            return this;
        }

        public StreamFeatureGroupBuilder hudiPrecombineKey(String hudiPrecombineKey) {
            this.hudiPrecombineKey = hudiPrecombineKey;
            return this;
        }

        public StreamFeatureGroupBuilder onlineEnabled(boolean onlineEnabled) {
            this.onlineEnabled = onlineEnabled;
            return this;
        }

        public StreamFeatureGroupBuilder timeTravelFormat(TimeTravelFormat timeTravelFormat) {
            this.timeTravelFormat = timeTravelFormat;
            return this;
        }

        public StreamFeatureGroupBuilder features(List<Feature> features) {
            this.features = features;
            return this;
        }

        public StreamFeatureGroupBuilder statisticsConfig(StatisticsConfig statisticsConfig) {
            this.statisticsConfig = statisticsConfig;
            return this;
        }

        public StreamFeatureGroupBuilder onlineTopicName(String onlineTopicName) {
            this.onlineTopicName = onlineTopicName;
            return this;
        }

        public StreamFeatureGroupBuilder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public StreamFeatureGroupBuilder notificationTopicName(String notificationTopicName) {
            this.notificationTopicName = notificationTopicName;
            return this;
        }

        public StreamFeatureGroupBuilder eventTime(String eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public StreamFeatureGroupBuilder onlineConfig(OnlineConfig onlineConfig) {
            this.onlineConfig = onlineConfig;
            return this;
        }

        public StreamFeatureGroupBuilder storageConnector(StorageConnector storageConnector) {
            this.storageConnector = storageConnector;
            return this;
        }

        public StreamFeatureGroupBuilder path(String path) {
            this.path = path;
            return this;
        }

        public StreamFeatureGroup build() {
            return new StreamFeatureGroup(this.featureStore, this.name, this.version, this.description, this.primaryKeys, this.partitionKeys, this.hudiPrecombineKey, this.onlineEnabled, this.timeTravelFormat, this.features, this.statisticsConfig, this.onlineTopicName, this.topicName, this.notificationTopicName, this.eventTime, this.onlineConfig, this.storageConnector, this.path);
        }

        public String toString() {
            return "StreamFeatureGroup.StreamFeatureGroupBuilder(featureStore=" + (Object)((Object)this.featureStore) + ", name=" + this.name + ", version=" + this.version + ", description=" + this.description + ", primaryKeys=" + this.primaryKeys + ", partitionKeys=" + this.partitionKeys + ", hudiPrecombineKey=" + this.hudiPrecombineKey + ", onlineEnabled=" + this.onlineEnabled + ", timeTravelFormat=" + this.timeTravelFormat + ", features=" + this.features + ", statisticsConfig=" + this.statisticsConfig + ", onlineTopicName=" + this.onlineTopicName + ", topicName=" + this.topicName + ", notificationTopicName=" + this.notificationTopicName + ", eventTime=" + this.eventTime + ", onlineConfig=" + this.onlineConfig + ", storageConnector=" + this.storageConnector + ", path=" + this.path + ")";
        }
    }
}

