/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.flink;

import com.logicalclocks.hsfs.Feature;
import com.logicalclocks.hsfs.FeatureStoreBase;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.OnlineConfig;
import com.logicalclocks.hsfs.StatisticsConfig;
import com.logicalclocks.hsfs.StorageConnector;
import com.logicalclocks.hsfs.TimeTravelFormat;
import com.logicalclocks.hsfs.flink.FeatureView;
import com.logicalclocks.hsfs.flink.StreamFeatureGroup;
import com.logicalclocks.hsfs.flink.constructor.Query;
import com.logicalclocks.hsfs.flink.engine.FeatureGroupEngine;
import com.logicalclocks.hsfs.flink.engine.FeatureViewEngine;
import com.logicalclocks.hsfs.metadata.StorageConnectorApi;
import java.io.IOException;
import java.util.List;
import lombok.NonNull;

public class FeatureStore
extends FeatureStoreBase<Query> {
    private FeatureGroupEngine featureGroupEngine;
    private FeatureViewEngine featureViewEngine = new FeatureViewEngine();

    public FeatureStore() {
        this.featureGroupEngine = new FeatureGroupEngine();
        this.storageConnectorApi = new StorageConnectorApi();
    }

    public StreamFeatureGroup.StreamFeatureGroupBuilder createStreamFeatureGroup() {
        return StreamFeatureGroup.builder().featureStore(this);
    }

    public StreamFeatureGroup createStreamFeatureGroup(@NonNull String name, Integer version, String description, Boolean onlineEnabled, TimeTravelFormat timeTravelFormat, List<String> primaryKeys, List<String> partitionKeys, String eventTime, String hudiPrecombineKey, List<Feature> features, StatisticsConfig statisticsConfig, StorageConnector storageConnector, String path) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return new StreamFeatureGroup.StreamFeatureGroupBuilder().featureStore(this).name(name).version(version).description(description).onlineEnabled(onlineEnabled).timeTravelFormat(timeTravelFormat).primaryKeys(primaryKeys).partitionKeys(partitionKeys).eventTime(eventTime).hudiPrecombineKey(hudiPrecombineKey).features(features).statisticsConfig(statisticsConfig).storageConnector(storageConnector).path(path).build();
    }

    public StreamFeatureGroup getOrCreateStreamFeatureGroup(@NonNull String name, Integer version, String description, Boolean onlineEnabled, TimeTravelFormat timeTravelFormat, List<String> primaryKeys, List<String> partitionKeys, String eventTime, String hudiPrecombineKey, List<Feature> features, StatisticsConfig statisticsConfig, StorageConnector storageConnector, String path, OnlineConfig onlineConfig) throws IOException, FeatureStoreException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.featureGroupEngine.getOrCreateFeatureGroup(this, name, version, description, onlineEnabled, timeTravelFormat, primaryKeys, partitionKeys, eventTime, hudiPrecombineKey, features, statisticsConfig, storageConnector, path, onlineConfig);
    }

    public StreamFeatureGroup getStreamFeatureGroup(String name) throws FeatureStoreException, IOException {
        LOGGER.info("VersionWarning: No version provided for getting feature group `" + name + "`, defaulting to `" + DEFAULT_VERSION + "`.");
        return this.getStreamFeatureGroup(name, DEFAULT_VERSION);
    }

    public StreamFeatureGroup getStreamFeatureGroup(@NonNull String name, @NonNull Integer version) throws FeatureStoreException, IOException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        return this.featureGroupEngine.getStreamFeatureGroup(this, name, version);
    }

    public FeatureView getFeatureView(@NonNull String name, @NonNull Integer version) throws FeatureStoreException, IOException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        return this.featureViewEngine.get(this, name, version);
    }

    public FeatureView getFeatureView(String name) throws FeatureStoreException, IOException {
        LOGGER.info("VersionWarning: No version provided for getting feature view `" + name + "`, defaulting to `" + DEFAULT_VERSION + "`.");
        return this.getFeatureView(name, DEFAULT_VERSION);
    }

    public FeatureView.FeatureViewBuilder createFeatureView() {
        return new FeatureView.FeatureViewBuilder(this);
    }

    public FeatureView getOrCreateFeatureView(String name, Query query, Integer version) throws FeatureStoreException, IOException {
        return this.featureViewEngine.getOrCreateFeatureView(this, name, version, query, null, null);
    }

    public StorageConnector.RdsConnector getRdsConnector(String name) throws FeatureStoreException, IOException {
        return (StorageConnector.RdsConnector)this.storageConnectorApi.getByName((FeatureStoreBase)this, name, StorageConnector.RdsConnector.class);
    }
}

