/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.flink.engine;

import com.logicalclocks.hsfs.engine.PojoToAvroUtils;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.formats.avro.typeutils.GenericRecordAvroTypeInfo;

public class PojoToAvroRecord<T>
extends RichMapFunction<T, GenericRecord>
implements ResultTypeQueryable<GenericRecord> {
    private final String featureGroupSchemaStr;
    private final String encodedFeatureGroupSchemaStr;
    private final Map<String, String> complexFeatureSchemasStr;
    private transient Schema featureGroupSchema;
    private transient Schema encodedFeatureGroupSchema;
    private transient Map<String, Schema> complexFeatureSchemas;
    private transient GenericRecordAvroTypeInfo producedType;

    public PojoToAvroRecord(String featureGroupSchema, String encodedFeatureGroupSchema, Map<String, String> complexFeatureSchemas) {
        this.featureGroupSchemaStr = featureGroupSchema;
        this.encodedFeatureGroupSchemaStr = encodedFeatureGroupSchema;
        this.complexFeatureSchemasStr = complexFeatureSchemas;
    }

    public void init() throws Exception {
        this.featureGroupSchema = new Schema.Parser().parse(this.featureGroupSchemaStr);
        this.encodedFeatureGroupSchema = new Schema.Parser().parse(this.encodedFeatureGroupSchemaStr);
        this.complexFeatureSchemas = this.complexFeatureSchemasStr.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new Schema.Parser().parse((String)e.getValue())));
        this.producedType = new GenericRecordAvroTypeInfo(this.encodedFeatureGroupSchema);
    }

    public GenericRecord map(T input) throws Exception {
        if (this.featureGroupSchema == null || this.encodedFeatureGroupSchema == null || this.complexFeatureSchemas == null) {
            this.init();
        }
        return PojoToAvroUtils.convertPojoToGenericRecord(input, (Schema)this.featureGroupSchema, (Schema)this.encodedFeatureGroupSchema, this.complexFeatureSchemas);
    }

    public TypeInformation<GenericRecord> getProducedType() {
        return this.producedType;
    }
}

