/*
 * Decompiled with CFR 0.152.
 */
package com.damnhandy.uri.template;

import com.damnhandy.uri.template.Expression;
import com.damnhandy.uri.template.Literal;
import com.damnhandy.uri.template.MalformedUriTemplateException;
import com.damnhandy.uri.template.UriTemplate;
import com.damnhandy.uri.template.UriTemplateBuilderException;
import com.damnhandy.uri.template.UriTemplateComponent;
import com.damnhandy.uri.template.impl.Modifier;
import com.damnhandy.uri.template.impl.Operator;
import com.damnhandy.uri.template.impl.UriTemplateParser;
import com.damnhandy.uri.template.impl.VarSpec;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public final class UriTemplateBuilder {
    private LinkedList<UriTemplateComponent> components = new LinkedList();
    private DateTimeFormatter defaultDateTimeFormatter = null;
    private Map<String, Object> values = null;

    UriTemplateBuilder() {
        this.components = new LinkedList();
    }

    UriTemplateBuilder(String templateString) throws MalformedUriTemplateException {
        this.components = new UriTemplateParser().scan(templateString);
    }

    UriTemplateBuilder(UriTemplate template) throws MalformedUriTemplateException {
        this(template.getTemplate());
        this.values = template.getValues();
        this.defaultDateTimeFormatter = template.defaultDateTimeFormatter;
    }

    public UriTemplateBuilder withDefaultDateFormat(String dateFormatString) {
        return this.withDefaultDateFormat(DateTimeFormat.forPattern(dateFormatString));
    }

    private UriTemplateBuilder withDefaultDateFormat(DateTimeFormatter dateTimeFormatter) {
        this.defaultDateTimeFormatter = dateTimeFormatter;
        return this;
    }

    @Deprecated
    public UriTemplateBuilder withDefaultDateFormat(DateFormat dateFormat) {
        if (!(dateFormat instanceof SimpleDateFormat)) {
            throw new IllegalArgumentException("The only supported subclass of java.text.DateFormat is java.text.SimpleDateFormat");
        }
        this.defaultDateTimeFormatter = DateTimeFormat.forPattern(((SimpleDateFormat)dateFormat).toPattern());
        return this;
    }

    void addComponent(UriTemplateComponent component) {
        this.components.add(component);
    }

    void addComponents(Collection<UriTemplateComponent> compoments) {
        this.components.addAll(compoments);
    }

    public UriTemplateBuilder literal(String string) {
        if (string == null) {
            return this;
        }
        this.addComponent(new Literal(string, 0));
        return this;
    }

    private static VarSpec[] toVarSpec(String ... varSpec) {
        VarSpec[] vars = new VarSpec[varSpec.length];
        for (int i = 0; i < varSpec.length; ++i) {
            vars[i] = UriTemplateBuilder.var(varSpec[i]);
        }
        return vars;
    }

    public UriTemplateBuilder simple(String ... var2) {
        this.simple(UriTemplateBuilder.toVarSpec(var2));
        return this;
    }

    public UriTemplateBuilder simple(VarSpec ... var2) {
        this.addComponent(Expression.simple(var2).build());
        return this;
    }

    public UriTemplateBuilder reserved(String ... var2) {
        this.reserved(UriTemplateBuilder.toVarSpec(var2));
        return this;
    }

    public UriTemplateBuilder reserved(VarSpec ... var2) {
        this.addComponent(Expression.reserved(var2).build());
        return this;
    }

    public UriTemplateBuilder fragment(String ... var2) throws UriTemplateBuilderException {
        this.fragment(UriTemplateBuilder.toVarSpec(var2));
        return this;
    }

    public UriTemplateBuilder fragment(VarSpec ... var2) throws UriTemplateBuilderException {
        if (this.hasExpressionWithOperator(Operator.FRAGMENT)) {
            throw new UriTemplateBuilderException("The template already has a fragment expression and this would not result in a valid URI");
        }
        this.addComponent(Expression.fragment(var2).build());
        return this;
    }

    private boolean hasExpressionWithOperator(Operator op) {
        for (UriTemplateComponent c : this.components) {
            Expression e;
            if (!Expression.class.isInstance(c) || (e = (Expression)c).getOperator() != op) continue;
            return true;
        }
        return false;
    }

    public UriTemplateBuilder label(String ... var2) {
        this.label(UriTemplateBuilder.toVarSpec(var2));
        return this;
    }

    public UriTemplateBuilder label(VarSpec ... var2) {
        this.addComponent(Expression.label(var2).build());
        return this;
    }

    public UriTemplateBuilder matrix(String ... var2) {
        this.matrix(UriTemplateBuilder.toVarSpec(var2));
        return this;
    }

    public UriTemplateBuilder matrix(VarSpec ... var2) {
        this.addComponent(Expression.matrix(var2).build());
        return this;
    }

    public UriTemplateBuilder path(String ... var2) {
        this.path(UriTemplateBuilder.toVarSpec(var2));
        return this;
    }

    public UriTemplateBuilder path(VarSpec ... var2) {
        this.addComponent(Expression.path(var2).build());
        return this;
    }

    public UriTemplateBuilder query(String ... var2) {
        this.query(UriTemplateBuilder.toVarSpec(var2));
        return this;
    }

    public UriTemplateBuilder query(VarSpec ... var2) {
        this.addComponent(Expression.query(var2).build());
        return this;
    }

    public UriTemplateBuilder continuation(String ... var2) {
        return this.continuation(UriTemplateBuilder.toVarSpec(var2));
    }

    public UriTemplateBuilder continuation(VarSpec ... var2) {
        this.addComponent(Expression.continuation(var2).build());
        return this;
    }

    public UriTemplateBuilder template(UriTemplate ... template) {
        for (UriTemplate t : template) {
            this.addComponents(t.getComponents());
        }
        return this;
    }

    public UriTemplateBuilder template(String ... template) {
        UriTemplateParser parser = new UriTemplateParser();
        for (String t : template) {
            this.addComponents(parser.scan(t));
        }
        return this;
    }

    public UriTemplateComponent[] getComponents() {
        return this.components.toArray(new UriTemplateComponent[this.components.size()]);
    }

    public UriTemplate build() throws MalformedUriTemplateException {
        UriTemplate template = new UriTemplate(this.components);
        if (this.values != null) {
            template.set(this.values);
        }
        if (this.defaultDateTimeFormatter != null) {
            template.defaultDateTimeFormatter = this.defaultDateTimeFormatter;
        }
        return template;
    }

    public static VarSpec var(String varName) {
        return UriTemplateBuilder.var(varName, Modifier.NONE, null);
    }

    public static VarSpec var(String varName, boolean explode) {
        if (explode) {
            return UriTemplateBuilder.var(varName, Modifier.EXPLODE, null);
        }
        return UriTemplateBuilder.var(varName, Modifier.NONE, null);
    }

    public static VarSpec var(String varName, int prefix) {
        return UriTemplateBuilder.var(varName, Modifier.PREFIX, prefix);
    }

    private static VarSpec var(String varName, Modifier modifier, Integer position) {
        return new VarSpec(varName, modifier, position);
    }
}

