/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.spark;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.logicalclocks.hsfs.EntityEndpointType;
import com.logicalclocks.hsfs.Feature;
import com.logicalclocks.hsfs.FeatureGroupBase;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.HudiOperationType;
import com.logicalclocks.hsfs.JobConfiguration;
import com.logicalclocks.hsfs.OnlineConfig;
import com.logicalclocks.hsfs.StatisticsConfig;
import com.logicalclocks.hsfs.Storage;
import com.logicalclocks.hsfs.metadata.Statistics;
import com.logicalclocks.hsfs.spark.FeatureStore;
import com.logicalclocks.hsfs.spark.constructor.Query;
import com.logicalclocks.hsfs.spark.engine.FeatureGroupEngine;
import com.logicalclocks.hsfs.spark.engine.StatisticsEngine;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.streaming.StreamingQuery;

@JsonIgnoreProperties(ignoreUnknown=true)
public class StreamFeatureGroup
extends FeatureGroupBase<Dataset<Row>> {
    protected FeatureGroupEngine featureGroupEngine = new FeatureGroupEngine();
    private final StatisticsEngine statisticsEngine = new StatisticsEngine(EntityEndpointType.FEATURE_GROUP);

    public StreamFeatureGroup(FeatureStore featureStore, @NonNull String name, Integer version, String description, List<String> primaryKeys, List<String> partitionKeys, String hudiPrecombineKey, boolean onlineEnabled, List<Feature> features, StatisticsConfig statisticsConfig, String onlineTopicName, String topicName, String notificationTopicName, String eventTime, OnlineConfig onlineConfig) {
        this();
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.featureStore = featureStore;
        this.name = name;
        this.version = version;
        this.description = description;
        this.primaryKeys = primaryKeys != null ? primaryKeys.stream().map(String::toLowerCase).collect(Collectors.toList()) : null;
        this.partitionKeys = partitionKeys != null ? partitionKeys.stream().map(String::toLowerCase).collect(Collectors.toList()) : null;
        this.hudiPrecombineKey = hudiPrecombineKey != null ? hudiPrecombineKey.toLowerCase() : null;
        this.onlineEnabled = onlineEnabled;
        this.features = features;
        this.statisticsConfig = statisticsConfig != null ? statisticsConfig : new StatisticsConfig();
        this.onlineTopicName = onlineTopicName;
        this.topicName = topicName;
        this.notificationTopicName = notificationTopicName;
        this.eventTime = eventTime;
        this.onlineConfig = onlineConfig;
    }

    public StreamFeatureGroup() {
        this.type = "streamFeatureGroupDTO";
    }

    public StreamFeatureGroup(Integer id, String description, List<Feature> features) {
        this();
        this.id = id;
        this.description = description;
        this.features = features;
    }

    public StreamFeatureGroup(FeatureStore featureStore, int id) {
        this();
        this.featureStore = featureStore;
        this.id = id;
    }

    public Dataset<Row> read() throws FeatureStoreException, IOException {
        return this.read(false, null);
    }

    public Dataset<Row> read(boolean online) throws FeatureStoreException, IOException {
        return this.read(online, null);
    }

    public Dataset<Row> read(Map<String, String> readOptions) throws FeatureStoreException, IOException {
        return this.read(false, readOptions);
    }

    public Dataset<Row> read(boolean online, Map<String, String> readOptions) throws FeatureStoreException, IOException {
        return this.selectAll().read(online, readOptions);
    }

    public Dataset<Row> read(String wallclockTime) throws FeatureStoreException, IOException, ParseException {
        return ((Query)this.selectAll().asOf(wallclockTime)).read(false, null);
    }

    public Dataset<Row> read(String wallclockTime, Map<String, String> readOptions) throws FeatureStoreException, IOException, ParseException {
        return ((Query)this.selectAll().asOf(wallclockTime)).read(false, readOptions);
    }

    public void show(int numRows) throws FeatureStoreException, IOException {
        this.read(false).show(numRows);
    }

    public void show(int numRows, boolean online) throws FeatureStoreException, IOException {
        this.read(online).show(numRows);
    }

    @Deprecated
    public Dataset<Row> readChanges(String wallclockStartTime, String wallclockEndTime) throws FeatureStoreException, IOException, ParseException {
        return ((Query)this.selectAll().pullChanges(wallclockStartTime, wallclockEndTime)).read(false, null);
    }

    @Deprecated
    public Dataset<Row> readChanges(String wallclockStartTime, String wallclockEndTime, Map<String, String> readOptions) throws FeatureStoreException, IOException, ParseException {
        return ((Query)this.selectAll().pullChanges(wallclockStartTime, wallclockEndTime)).read(false, readOptions);
    }

    public Query asOf(String wallclockTime) throws FeatureStoreException, ParseException {
        return (Query)this.selectAll().asOf(wallclockTime);
    }

    public Query asOf(String wallclockTime, String excludeUntil) throws FeatureStoreException, ParseException {
        return (Query)this.selectAll().asOf(wallclockTime, excludeUntil);
    }

    @Deprecated
    public void save(Dataset<Row> featureData, Map<String, String> writeOptions) throws FeatureStoreException, IOException, ParseException {
        this.featureGroupEngine.save(this, featureData, this.partitionKeys, this.hudiPrecombineKey, writeOptions, null);
    }

    @Deprecated
    public void save(Dataset<Row> featureData, Map<String, String> writeOptions, JobConfiguration jobConfiguration) throws FeatureStoreException, IOException, ParseException {
        this.featureGroupEngine.save(this, featureData, this.partitionKeys, this.hudiPrecombineKey, writeOptions, jobConfiguration);
    }

    public void insert(Dataset<Row> featureData) throws FeatureStoreException, IOException, ParseException {
        this.insert(featureData, false, null, null);
    }

    public void insert(Dataset<Row> featureData, Map<String, String> writeOptions) throws FeatureStoreException, IOException, ParseException {
        this.insert(featureData, false, writeOptions, null);
    }

    public void insert(Dataset<Row> featureData, Storage storage) throws IOException, FeatureStoreException, ParseException {
        new FeatureStoreException("This method is not implemented in StreamFeatureGroup");
    }

    public void insert(Dataset<Row> featureData, boolean overwrite) throws IOException, FeatureStoreException, ParseException {
        this.insert(featureData, overwrite, null, null);
    }

    public void insert(Dataset<Row> featureData, Storage storage, boolean overwrite) throws IOException, FeatureStoreException, ParseException {
        new FeatureStoreException("This method is not implemented in StreamFeatureGroup");
    }

    public void insert(Dataset<Row> featureData, boolean overwrite, Map<String, String> writeOptions) throws FeatureStoreException, IOException, ParseException {
        this.insert(featureData, overwrite, writeOptions, null);
    }

    public void insert(Dataset<Row> featureData, HudiOperationType operation) throws FeatureStoreException, IOException, ParseException {
        new FeatureStoreException("This method is not implemented in StreamFeatureGroup");
    }

    public void insert(Dataset<Row> featureData, Storage storage, boolean overwrite, HudiOperationType operation, Map<String, String> writeOptions) throws FeatureStoreException, IOException, ParseException {
        new FeatureStoreException("This method is not implemented in StreamFeatureGroup");
    }

    public void insert(Dataset<Row> featureData, JobConfiguration jobConfiguration) throws FeatureStoreException, IOException, ParseException {
        this.insert(featureData, false, null, jobConfiguration);
    }

    public void insert(Dataset<Row> featureData, boolean overwrite, Map<String, String> writeOptions, JobConfiguration jobConfiguration) throws FeatureStoreException, IOException, ParseException {
        this.featureGroupEngine.insert(this, featureData, overwrite ? SaveMode.Overwrite : SaveMode.Append, this.partitionKeys, this.hudiPrecombineKey, writeOptions, jobConfiguration);
    }

    public StreamingQuery insertStream(Dataset<Row> featureData) {
        return this.insertStream(featureData, null, null, false, null, null, null, null);
    }

    public StreamingQuery insertStream(Dataset<Row> featureData, String queryName) {
        return this.insertStream(featureData, queryName, null, false, null, null, null, null);
    }

    public StreamingQuery insertStream(Dataset<Row> featureData, Map<String, String> writeOptions) {
        return this.insertStream(featureData, null, null, false, null, null, writeOptions, null);
    }

    public StreamingQuery insertStream(Dataset<Row> featureData, String queryName, Map<String, String> writeOptions) {
        return this.insertStream(featureData, queryName, null, false, null, null, writeOptions, null);
    }

    public StreamingQuery insertStream(Dataset<Row> featureData, String queryName, String outputMode) {
        return this.insertStream(featureData, queryName, outputMode, false, null, null, null, null);
    }

    public StreamingQuery insertStream(Dataset<Row> featureData, String queryName, String outputMode, String checkpointLocation) {
        return this.insertStream(featureData, queryName, outputMode, false, null, checkpointLocation, null, null);
    }

    public StreamingQuery insertStream(Dataset<Row> featureData, String queryName, String outputMode, boolean awaitTermination, Long timeout) {
        return this.insertStream(featureData, queryName, outputMode, awaitTermination, timeout, null, null, null);
    }

    public StreamingQuery insertStream(Dataset<Row> featureData, String queryName, String outputMode, boolean awaitTermination, Long timeout, String checkpointLocation) {
        return this.insertStream(featureData, queryName, outputMode, awaitTermination, timeout, checkpointLocation, null, null);
    }

    public StreamingQuery insertStream(Dataset<Row> featureData, String queryName, String outputMode, boolean awaitTermination, Long timeout, String checkpointLocation, Map<String, String> writeOptions) {
        return this.insertStream(featureData, queryName, outputMode, awaitTermination, timeout, checkpointLocation, writeOptions, null);
    }

    public StreamingQuery insertStream(Dataset<Row> featureData, String queryName, String outputMode, boolean awaitTermination, String checkpointLocation) {
        return this.insertStream(featureData, queryName, outputMode, awaitTermination, null, checkpointLocation, null, null);
    }

    public StreamingQuery insertStream(Dataset<Row> featureData, String queryName, String outputMode, boolean awaitTermination, Long timeout, String checkpointLocation, Map<String, String> writeOptions, JobConfiguration jobConfiguration) {
        return this.featureGroupEngine.insertStream(this, featureData, queryName, outputMode, awaitTermination, timeout, checkpointLocation, this.partitionKeys, this.hudiPrecombineKey, writeOptions, jobConfiguration);
    }

    public Query selectFeatures(List<Feature> features) {
        return new Query(this, features);
    }

    public Query select(List<String> features) {
        List featureObjList = features.stream().map(Feature::new).collect(Collectors.toList());
        return this.selectFeatures(featureObjList);
    }

    public Query selectAll() {
        return new Query(this, this.getFeatures());
    }

    public Query selectExceptFeatures(List<Feature> features) {
        List exceptFeatures = features.stream().map(Feature::getName).collect(Collectors.toList());
        return this.selectExcept(exceptFeatures);
    }

    public Query selectExcept(List<String> features) {
        return new Query(this, this.getFeatures().stream().filter(f -> !features.contains(f.getName())).collect(Collectors.toList()));
    }

    public void commitDeleteRecord(Dataset<Row> featureData) throws FeatureStoreException, IOException, ParseException {
        this.featureGroupEngine.commitDelete(this, featureData, null);
    }

    public void commitDeleteRecord(Dataset<Row> featureData, Map<String, String> writeOptions) throws FeatureStoreException, IOException, ParseException {
        this.featureGroupEngine.commitDelete(this, featureData, writeOptions);
    }

    public Map<Long, Map<String, String>> commitDetails() throws IOException, FeatureStoreException, ParseException {
        return this.featureGroupEngine.commitDetails(this, null);
    }

    public Map<Long, Map<String, String>> commitDetails(Integer limit) throws IOException, FeatureStoreException, ParseException {
        return this.featureGroupEngine.commitDetails(this, limit);
    }

    public Map<Long, Map<String, String>> commitDetails(String wallclockTime) throws IOException, FeatureStoreException, ParseException {
        return this.featureGroupEngine.commitDetailsByWallclockTime(this, wallclockTime, null);
    }

    public Map<Long, Map<String, String>> commitDetails(String wallclockTime, Integer limit) throws IOException, FeatureStoreException, ParseException {
        return this.featureGroupEngine.commitDetailsByWallclockTime(this, wallclockTime, limit);
    }

    public void updateFeatures(List<Feature> features) throws FeatureStoreException, IOException, ParseException {
        this.featureGroupEngine.appendFeatures(this, features, ((Object)((Object)this)).getClass());
    }

    public void updateFeatures(Feature feature) throws FeatureStoreException, IOException, ParseException {
        this.featureGroupEngine.appendFeatures(this, Collections.singletonList(feature), ((Object)((Object)this)).getClass());
    }

    public void appendFeatures(List<Feature> features) throws FeatureStoreException, IOException, ParseException {
        this.featureGroupEngine.appendFeatures(this, new ArrayList<Feature>(features), ((Object)((Object)this)).getClass());
    }

    public void appendFeatures(Feature features) throws FeatureStoreException, IOException, ParseException {
        ArrayList<Feature> featureList = new ArrayList<Feature>();
        featureList.add(features);
        this.featureGroupEngine.appendFeatures(this, featureList, ((Object)((Object)this)).getClass());
    }

    public Statistics computeStatistics() throws FeatureStoreException, IOException {
        if (this.statisticsConfig.getEnabled().booleanValue()) {
            return this.statisticsEngine.computeStatistics(this, this.read(), null);
        }
        LOGGER.info("StorageWarning: The statistics are not enabled of feature group `" + this.name + "`, with version `" + this.version + "`. No statistics computed.");
        return null;
    }

    public Statistics computeStatistics(String wallclockTime) throws FeatureStoreException, IOException, ParseException {
        if (this.statisticsConfig.getEnabled().booleanValue()) {
            Map<Long, Map<String, String>> latestCommitMetaData = this.featureGroupEngine.commitDetailsByWallclockTime(this, wallclockTime, 1);
            Dataset<Row> featureData = ((Query)this.selectAll().asOf(wallclockTime)).read(false, null);
            Long commitId = (Long)latestCommitMetaData.keySet().toArray()[0];
            return this.statisticsEngine.computeStatistics(this, featureData, commitId);
        }
        LOGGER.info("StorageWarning: The statistics are not enabled of feature group `" + this.name + "`, with version `" + this.version + "`. No statistics computed.");
        return null;
    }

    public Statistics getStatistics() throws FeatureStoreException, IOException {
        return null;
    }

    public static StreamFeatureGroupBuilder builder() {
        return new StreamFeatureGroupBuilder();
    }

    public StreamFeatureGroup(FeatureGroupEngine featureGroupEngine) {
        this.featureGroupEngine = featureGroupEngine;
    }

    public static class StreamFeatureGroupBuilder {
        private FeatureStore featureStore;
        private String name;
        private Integer version;
        private String description;
        private List<String> primaryKeys;
        private List<String> partitionKeys;
        private String hudiPrecombineKey;
        private boolean onlineEnabled;
        private List<Feature> features;
        private StatisticsConfig statisticsConfig;
        private String onlineTopicName;
        private String topicName;
        private String notificationTopicName;
        private String eventTime;
        private OnlineConfig onlineConfig;

        StreamFeatureGroupBuilder() {
        }

        public StreamFeatureGroupBuilder featureStore(FeatureStore featureStore) {
            this.featureStore = featureStore;
            return this;
        }

        public StreamFeatureGroupBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public StreamFeatureGroupBuilder version(Integer version) {
            this.version = version;
            return this;
        }

        public StreamFeatureGroupBuilder description(String description) {
            this.description = description;
            return this;
        }

        public StreamFeatureGroupBuilder primaryKeys(List<String> primaryKeys) {
            this.primaryKeys = primaryKeys;
            return this;
        }

        public StreamFeatureGroupBuilder partitionKeys(List<String> partitionKeys) {
            this.partitionKeys = partitionKeys;
            return this;
        }

        public StreamFeatureGroupBuilder hudiPrecombineKey(String hudiPrecombineKey) {
            this.hudiPrecombineKey = hudiPrecombineKey;
            return this;
        }

        public StreamFeatureGroupBuilder onlineEnabled(boolean onlineEnabled) {
            this.onlineEnabled = onlineEnabled;
            return this;
        }

        public StreamFeatureGroupBuilder features(List<Feature> features) {
            this.features = features;
            return this;
        }

        public StreamFeatureGroupBuilder statisticsConfig(StatisticsConfig statisticsConfig) {
            this.statisticsConfig = statisticsConfig;
            return this;
        }

        public StreamFeatureGroupBuilder onlineTopicName(String onlineTopicName) {
            this.onlineTopicName = onlineTopicName;
            return this;
        }

        public StreamFeatureGroupBuilder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public StreamFeatureGroupBuilder notificationTopicName(String notificationTopicName) {
            this.notificationTopicName = notificationTopicName;
            return this;
        }

        public StreamFeatureGroupBuilder eventTime(String eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public StreamFeatureGroupBuilder onlineConfig(OnlineConfig onlineConfig) {
            this.onlineConfig = onlineConfig;
            return this;
        }

        public StreamFeatureGroup build() {
            return new StreamFeatureGroup(this.featureStore, this.name, this.version, this.description, this.primaryKeys, this.partitionKeys, this.hudiPrecombineKey, this.onlineEnabled, this.features, this.statisticsConfig, this.onlineTopicName, this.topicName, this.notificationTopicName, this.eventTime, this.onlineConfig);
        }

        public String toString() {
            return "StreamFeatureGroup.StreamFeatureGroupBuilder(featureStore=" + (Object)((Object)this.featureStore) + ", name=" + this.name + ", version=" + this.version + ", description=" + this.description + ", primaryKeys=" + this.primaryKeys + ", partitionKeys=" + this.partitionKeys + ", hudiPrecombineKey=" + this.hudiPrecombineKey + ", onlineEnabled=" + this.onlineEnabled + ", features=" + this.features + ", statisticsConfig=" + this.statisticsConfig + ", onlineTopicName=" + this.onlineTopicName + ", topicName=" + this.topicName + ", notificationTopicName=" + this.notificationTopicName + ", eventTime=" + this.eventTime + ", onlineConfig=" + this.onlineConfig + ")";
        }
    }
}

