/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.spark;

import com.logicalclocks.hsfs.FeatureGroupBase;
import com.logicalclocks.hsfs.FeatureStoreBase;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.OnlineConfig;
import com.logicalclocks.hsfs.StatisticsConfig;
import com.logicalclocks.hsfs.StorageConnector;
import com.logicalclocks.hsfs.TimeTravelFormat;
import com.logicalclocks.hsfs.TrainingDatasetBase;
import com.logicalclocks.hsfs.metadata.StorageConnectorApi;
import com.logicalclocks.hsfs.metadata.TrainingDatasetApi;
import com.logicalclocks.hsfs.spark.ExternalFeatureGroup;
import com.logicalclocks.hsfs.spark.FeatureGroup;
import com.logicalclocks.hsfs.spark.FeatureView;
import com.logicalclocks.hsfs.spark.StreamFeatureGroup;
import com.logicalclocks.hsfs.spark.TrainingDataset;
import com.logicalclocks.hsfs.spark.constructor.Query;
import com.logicalclocks.hsfs.spark.engine.FeatureGroupEngine;
import com.logicalclocks.hsfs.spark.engine.FeatureViewEngine;
import com.logicalclocks.hsfs.spark.engine.SparkEngine;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.collection.JavaConverters;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;

public class FeatureStore
extends FeatureStoreBase<Query> {
    private FeatureGroupEngine featureGroupEngine;
    private FeatureViewEngine featureViewEngine;

    public FeatureStore() {
        this.trainingDatasetApi = new TrainingDatasetApi();
        this.storageConnectorApi = new StorageConnectorApi();
        this.featureViewEngine = new FeatureViewEngine();
        this.featureGroupEngine = new FeatureGroupEngine();
    }

    public FeatureGroup getFeatureGroup(@NonNull String name, @NonNull Integer version) throws FeatureStoreException, IOException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        return this.featureGroupEngine.getFeatureGroup(this, name, version);
    }

    public FeatureGroup getFeatureGroup(String name) throws FeatureStoreException, IOException {
        LOGGER.info("VersionWarning: No version provided for getting feature group `" + name + "`, defaulting to `" + FeatureStoreBase.DEFAULT_VERSION + "`.");
        return this.getFeatureGroup(name, FeatureStoreBase.DEFAULT_VERSION);
    }

    public Seq<FeatureGroup> getFeatureGroups(@NonNull String name) throws FeatureStoreException, IOException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        ArrayList<FeatureGroup> featureGroups = new ArrayList<FeatureGroup>();
        for (FeatureGroupBase featureGroupBase : this.featureGroupEngine.getFeatureGroups(this, name)) {
            featureGroups.add((FeatureGroup)featureGroupBase);
        }
        return ((Buffer)JavaConverters.asScalaBufferConverter(featureGroups).asScala()).toSeq();
    }

    public FeatureGroup.FeatureGroupBuilder createFeatureGroup() {
        return FeatureGroup.builder().featureStore(this);
    }

    public FeatureGroup getOrCreateFeatureGroup(String name, Integer version) throws IOException, FeatureStoreException {
        return this.featureGroupEngine.getOrCreateFeatureGroup(this, name, version, null, null, null, null, false, null, null, null, null, null, null);
    }

    public FeatureGroup getOrCreateFeatureGroup(String name, Integer version, List<String> primaryKeys, boolean onlineEnabled, String eventTime) throws IOException, FeatureStoreException {
        return this.featureGroupEngine.getOrCreateFeatureGroup(this, name, version, null, primaryKeys, null, null, onlineEnabled, null, null, null, null, eventTime, null);
    }

    public FeatureGroup getOrCreateFeatureGroup(String name, Integer version, List<String> primaryKeys, List<String> partitionKeys, boolean onlineEnabled, String eventTime) throws IOException, FeatureStoreException {
        return this.featureGroupEngine.getOrCreateFeatureGroup(this, name, version, null, primaryKeys, partitionKeys, null, onlineEnabled, null, null, null, null, eventTime, null);
    }

    public FeatureGroup getOrCreateFeatureGroup(String name, Integer version, String description, List<String> primaryKeys, List<String> partitionKeys, String hudiPrecombineKey, boolean onlineEnabled, TimeTravelFormat timeTravelFormat, StatisticsConfig statisticsConfig, String topicName, String notificationTopicName, String eventTime, OnlineConfig onlineConfig) throws IOException, FeatureStoreException {
        return this.featureGroupEngine.getOrCreateFeatureGroup(this, name, version, description, primaryKeys, partitionKeys, hudiPrecombineKey, onlineEnabled, timeTravelFormat, statisticsConfig, topicName, notificationTopicName, eventTime, onlineConfig);
    }

    public StreamFeatureGroup getStreamFeatureGroup(String name) throws FeatureStoreException, IOException {
        LOGGER.info("VersionWarning: No version provided for getting feature group `" + name + "`, defaulting to `" + FeatureStoreBase.DEFAULT_VERSION + "`.");
        return this.getStreamFeatureGroup(name, FeatureStoreBase.DEFAULT_VERSION);
    }

    public StreamFeatureGroup getStreamFeatureGroup(@NonNull String name, @NonNull Integer version) throws FeatureStoreException, IOException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        return this.featureGroupEngine.getStreamFeatureGroup(this, name, version);
    }

    public StreamFeatureGroup.StreamFeatureGroupBuilder createStreamFeatureGroup() {
        return StreamFeatureGroup.builder().featureStore(this);
    }

    public StreamFeatureGroup getOrCreateStreamFeatureGroup(String name, Integer version) throws IOException, FeatureStoreException {
        return this.featureGroupEngine.getOrCreateStreamFeatureGroup(this, name, version, null, null, null, null, false, null, null, null);
    }

    public StreamFeatureGroup getOrCreateStreamFeatureGroup(String name, Integer version, List<String> primaryKeys, boolean onlineEnabled, String eventTime) throws IOException, FeatureStoreException {
        return this.featureGroupEngine.getOrCreateStreamFeatureGroup(this, name, version, null, primaryKeys, null, null, onlineEnabled, null, eventTime, null);
    }

    public StreamFeatureGroup getOrCreateStreamFeatureGroup(String name, Integer version, List<String> primaryKeys, List<String> partitionKeys, boolean onlineEnabled, String eventTime) throws IOException, FeatureStoreException {
        return this.featureGroupEngine.getOrCreateStreamFeatureGroup(this, name, version, null, primaryKeys, partitionKeys, null, onlineEnabled, null, eventTime, null);
    }

    public StreamFeatureGroup getOrCreateStreamFeatureGroup(String name, Integer version, String description, List<String> primaryKeys, List<String> partitionKeys, String hudiPrecombineKey, boolean onlineEnabled, StatisticsConfig statisticsConfig, String eventTime, OnlineConfig onlineConfig) throws IOException, FeatureStoreException {
        return this.featureGroupEngine.getOrCreateStreamFeatureGroup(this, name, version, description, primaryKeys, partitionKeys, hudiPrecombineKey, onlineEnabled, statisticsConfig, eventTime, onlineConfig);
    }

    public ExternalFeatureGroup.ExternalFeatureGroupBuilder createExternalFeatureGroup() {
        return ExternalFeatureGroup.builder().featureStore(this);
    }

    @Deprecated
    public ExternalFeatureGroup.ExternalFeatureGroupBuilder createOnDemandFeatureGroup() {
        return ExternalFeatureGroup.builder().featureStore(this);
    }

    public Seq<ExternalFeatureGroup> getExternalFeatureGroups(@NonNull String name) throws FeatureStoreException, IOException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return ((Buffer)JavaConverters.asScalaBufferConverter(this.featureGroupEngine.getExternalFeatureGroups(this, name)).asScala()).toSeq();
    }

    public ExternalFeatureGroup getExternalFeatureGroup(@NonNull String name, @NonNull Integer version) throws FeatureStoreException, IOException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        return this.featureGroupEngine.getExternalFeatureGroup(this, name, version);
    }

    public ExternalFeatureGroup getExternalFeatureGroup(String name) throws FeatureStoreException, IOException {
        LOGGER.info("VersionWarning: No version provided for getting feature group `" + name + "`, defaulting to `" + FeatureStoreBase.DEFAULT_VERSION + "`.");
        return this.getExternalFeatureGroup(name, FeatureStoreBase.DEFAULT_VERSION);
    }

    public StorageConnector getStorageConnector(String name) throws FeatureStoreException, IOException {
        return (StorageConnector)this.storageConnectorApi.getByName((FeatureStoreBase)this, name, StorageConnector.class);
    }

    public StorageConnector.HopsFsConnector getHopsFsConnector(String name) throws FeatureStoreException, IOException {
        return (StorageConnector.HopsFsConnector)this.storageConnectorApi.getByName((FeatureStoreBase)this, name, StorageConnector.HopsFsConnector.class);
    }

    public StorageConnector.JdbcConnector getJdbcConnector(String name) throws FeatureStoreException, IOException {
        return (StorageConnector.JdbcConnector)this.storageConnectorApi.getByName((FeatureStoreBase)this, name, StorageConnector.JdbcConnector.class);
    }

    public StorageConnector.JdbcConnector getOnlineStorageConnector() throws FeatureStoreException, IOException {
        return (StorageConnector.JdbcConnector)this.storageConnectorApi.getOnlineStorageConnector((FeatureStoreBase)this, StorageConnector.JdbcConnector.class);
    }

    public StorageConnector.S3Connector getS3Connector(String name) throws FeatureStoreException, IOException {
        return (StorageConnector.S3Connector)this.storageConnectorApi.getByName((FeatureStoreBase)this, name, StorageConnector.S3Connector.class);
    }

    public StorageConnector.RedshiftConnector getRedshiftConnector(String name) throws FeatureStoreException, IOException {
        return (StorageConnector.RedshiftConnector)this.storageConnectorApi.getByName((FeatureStoreBase)this, name, StorageConnector.RedshiftConnector.class);
    }

    public StorageConnector.SnowflakeConnector getSnowflakeConnector(String name) throws FeatureStoreException, IOException {
        return (StorageConnector.SnowflakeConnector)this.storageConnectorApi.getByName((FeatureStoreBase)this, name, StorageConnector.SnowflakeConnector.class);
    }

    public StorageConnector.AdlsConnector getAdlsConnector(String name) throws FeatureStoreException, IOException {
        return (StorageConnector.AdlsConnector)this.storageConnectorApi.getByName((FeatureStoreBase)this, name, StorageConnector.AdlsConnector.class);
    }

    public StorageConnector.KafkaConnector getKafkaConnector(String name) throws FeatureStoreException, IOException {
        return (StorageConnector.KafkaConnector)this.storageConnectorApi.getByName((FeatureStoreBase)this, name, StorageConnector.KafkaConnector.class);
    }

    public StorageConnector.BigqueryConnector getBigqueryConnector(String name) throws FeatureStoreException, IOException {
        return (StorageConnector.BigqueryConnector)this.storageConnectorApi.getByName((FeatureStoreBase)this, name, StorageConnector.BigqueryConnector.class);
    }

    public StorageConnector.GcsConnector getGcsConnector(String name) throws FeatureStoreException, IOException {
        return (StorageConnector.GcsConnector)this.storageConnectorApi.getByName((FeatureStoreBase)this, name, StorageConnector.GcsConnector.class);
    }

    @Deprecated
    public ExternalFeatureGroup getOnDemandFeatureGroup(@NonNull String name, @NonNull Integer version) throws FeatureStoreException, IOException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        return this.featureGroupEngine.getExternalFeatureGroup(this, name, version);
    }

    @Deprecated
    public ExternalFeatureGroup getOnDemandFeatureGroup(String name) throws FeatureStoreException, IOException {
        LOGGER.info("VersionWarning: No version provided for getting feature group `" + name + "`, defaulting to `" + FeatureStoreBase.DEFAULT_VERSION + "`.");
        return this.getExternalFeatureGroup(name, FeatureStoreBase.DEFAULT_VERSION);
    }

    @Deprecated
    public Seq<ExternalFeatureGroup> getOnDemandFeatureGroups(@NonNull String name) throws FeatureStoreException, IOException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return ((Buffer)JavaConverters.asScalaBufferConverter(this.featureGroupEngine.getExternalFeatureGroups(this, name)).asScala()).toSeq();
    }

    public FeatureView.FeatureViewBuilder createFeatureView() {
        return new FeatureView.FeatureViewBuilder(this);
    }

    public FeatureView getOrCreateFeatureView(String name, Query query, Integer version) throws FeatureStoreException, IOException {
        return this.featureViewEngine.getOrCreateFeatureView(this, name, version, query, null, null);
    }

    public FeatureView getOrCreateFeatureView(String name, Query query, Integer version, String description, List<String> labels) throws FeatureStoreException, IOException {
        return this.featureViewEngine.getOrCreateFeatureView(this, name, version, query, description, labels);
    }

    public FeatureView getFeatureView(@NonNull String name, @NonNull Integer version) throws FeatureStoreException, IOException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        return this.featureViewEngine.get(this, name, version);
    }

    public FeatureView getFeatureView(String name) throws FeatureStoreException, IOException {
        LOGGER.info("VersionWarning: No version provided for getting feature view `" + name + "`, defaulting to `" + FeatureStoreBase.DEFAULT_VERSION + "`.");
        return this.getFeatureView(name, FeatureStoreBase.DEFAULT_VERSION);
    }

    public Dataset<Row> sql(String query) {
        return SparkEngine.getInstance().sql(query);
    }

    @Deprecated
    public TrainingDataset.TrainingDatasetBuilder createTrainingDataset() {
        return TrainingDataset.builder().featureStore(this);
    }

    @Deprecated
    public TrainingDataset getTrainingDataset(@NonNull String name, @NonNull Integer version) throws FeatureStoreException, IOException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        return (TrainingDataset)this.trainingDatasetApi.getTrainingDataset((FeatureStoreBase)this, name, version);
    }

    @Deprecated
    public TrainingDataset getTrainingDataset(String name) throws FeatureStoreException, IOException {
        LOGGER.info("VersionWarning: No version provided for getting training dataset `" + name + "`, defaulting to `" + FeatureStoreBase.DEFAULT_VERSION + "`.");
        return this.getTrainingDataset(name, FeatureStoreBase.DEFAULT_VERSION);
    }

    @Deprecated
    public Seq<TrainingDataset> getTrainingDatasets(@NonNull String name) throws FeatureStoreException, IOException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        ArrayList<TrainingDataset> trainingDatasets = new ArrayList<TrainingDataset>();
        for (TrainingDatasetBase td : this.trainingDatasetApi.get((FeatureStoreBase)this, name, null)) {
            trainingDatasets.add((TrainingDataset)td);
        }
        return ((Buffer)JavaConverters.asScalaBufferConverter(trainingDatasets).asScala()).toSeq();
    }
}

