/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.spark;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.logicalclocks.hsfs.DataFormat;
import com.logicalclocks.hsfs.EntityEndpointType;
import com.logicalclocks.hsfs.FeatureStoreBase;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.Split;
import com.logicalclocks.hsfs.StatisticsConfig;
import com.logicalclocks.hsfs.StorageConnector;
import com.logicalclocks.hsfs.TrainingDatasetBase;
import com.logicalclocks.hsfs.TrainingDatasetType;
import com.logicalclocks.hsfs.constructor.Filter;
import com.logicalclocks.hsfs.constructor.FilterLogic;
import com.logicalclocks.hsfs.engine.FeatureGroupUtils;
import com.logicalclocks.hsfs.metadata.Statistics;
import com.logicalclocks.hsfs.spark.engine.StatisticsEngine;
import com.logicalclocks.hsfs.spark.engine.TrainingDatasetEngine;
import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class TrainingDataset
extends TrainingDatasetBase {
    private TrainingDatasetEngine trainingDatasetEngine = new TrainingDatasetEngine();
    private StatisticsEngine statisticsEngine = new StatisticsEngine(EntityEndpointType.TRAINING_DATASET);

    public TrainingDataset(Integer version, String description, DataFormat dataFormat, Boolean coalesce, StorageConnector storageConnector, String location, List<Split> splits, String trainSplit, Long seed, FeatureStoreBase featureStore, StatisticsConfig statisticsConfig, List<String> label, String eventStartTime, String eventEndTime, TrainingDatasetType trainingDatasetType, Float validationSize, Float testSize, String trainStart, String trainEnd, String validationStart, String validationEnd, String testStart, String testEnd, Integer timeSplitSize, FilterLogic extraFilterLogic, Filter extraFilter) throws FeatureStoreException, ParseException {
        this.version = version;
        this.description = description;
        this.dataFormat = dataFormat != null ? dataFormat : DataFormat.PARQUET;
        this.coalesce = coalesce != null ? coalesce : false;
        this.location = location;
        this.storageConnector = storageConnector;
        this.trainSplit = trainSplit;
        this.splits = splits == null ? Lists.newArrayList() : splits;
        this.seed = seed;
        this.featureStore = featureStore;
        this.statisticsConfig = statisticsConfig != null ? statisticsConfig : new StatisticsConfig();
        this.label = label != null ? label.stream().map(String::toLowerCase).collect(Collectors.toList()) : null;
        this.eventStartTime = eventStartTime != null ? FeatureGroupUtils.getDateFromDateString((String)eventStartTime) : null;
        this.eventEndTime = eventEndTime != null ? FeatureGroupUtils.getDateFromDateString((String)eventEndTime) : null;
        this.trainingDatasetType = trainingDatasetType != null ? trainingDatasetType : this.getTrainingDatasetType(storageConnector);
        this.setValTestSplit(validationSize, testSize);
        this.setTimeSeriesSplits(timeSplitSize, trainStart, trainEnd, validationStart, validationEnd, testStart, testEnd);
        if (extraFilter != null) {
            this.extraFilter = new FilterLogic(extraFilter);
        }
        if (extraFilterLogic != null) {
            this.extraFilter = extraFilterLogic;
        }
        if (this.splits != null && !this.splits.isEmpty() && Strings.isNullOrEmpty((String)this.trainSplit)) {
            LOGGER.info("Training dataset splits were defined but no `trainSplit` (the name of the split that is going to be used for training) was provided. Setting this property to `train`.");
            this.trainSplit = "train";
        }
    }

    public Dataset<Row> read() throws FeatureStoreException, IOException {
        return this.read("");
    }

    public Dataset<Row> read(Map<String, String> readOptions) throws FeatureStoreException, IOException {
        return this.read("", readOptions);
    }

    public Dataset<Row> read(String split) throws FeatureStoreException, IOException {
        return this.read(split, null);
    }

    public Dataset<Row> read(String split, Map<String, String> readOptions) throws FeatureStoreException, IOException {
        if (this.splits != null && !this.splits.isEmpty() && Strings.isNullOrEmpty((String)split)) {
            throw new FeatureStoreException("The training dataset has splits, please specify the split you want to read");
        }
        return this.trainingDatasetEngine.read(this, split, readOptions);
    }

    public void show(int numRows) throws FeatureStoreException, IOException {
        this.read("").show(numRows);
    }

    public Statistics computeStatistics() throws FeatureStoreException, IOException {
        if (this.statisticsConfig.getEnabled().booleanValue()) {
            if (this.splits != null && !this.splits.isEmpty()) {
                return this.statisticsEngine.computeAndSaveSplitStatistics(this);
            }
            return this.statisticsEngine.computeStatistics(this, this.read());
        }
        return null;
    }

    @Generated
    public static TrainingDatasetBuilder buildTrainingDataset() {
        return new TrainingDatasetBuilder();
    }

    @Generated
    public TrainingDataset() {
    }

    @Generated
    public static class TrainingDatasetBuilder {
        @Generated
        private Integer version;
        @Generated
        private String description;
        @Generated
        private DataFormat dataFormat;
        @Generated
        private Boolean coalesce;
        @Generated
        private StorageConnector storageConnector;
        @Generated
        private String location;
        @Generated
        private List<Split> splits;
        @Generated
        private String trainSplit;
        @Generated
        private Long seed;
        @Generated
        private FeatureStoreBase featureStore;
        @Generated
        private StatisticsConfig statisticsConfig;
        @Generated
        private List<String> label;
        @Generated
        private String eventStartTime;
        @Generated
        private String eventEndTime;
        @Generated
        private TrainingDatasetType trainingDatasetType;
        @Generated
        private Float validationSize;
        @Generated
        private Float testSize;
        @Generated
        private String trainStart;
        @Generated
        private String trainEnd;
        @Generated
        private String validationStart;
        @Generated
        private String validationEnd;
        @Generated
        private String testStart;
        @Generated
        private String testEnd;
        @Generated
        private Integer timeSplitSize;
        @Generated
        private FilterLogic extraFilterLogic;
        @Generated
        private Filter extraFilter;

        @Generated
        TrainingDatasetBuilder() {
        }

        @Generated
        public TrainingDatasetBuilder version(Integer version) {
            this.version = version;
            return this;
        }

        @Generated
        public TrainingDatasetBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public TrainingDatasetBuilder dataFormat(DataFormat dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        @Generated
        public TrainingDatasetBuilder coalesce(Boolean coalesce) {
            this.coalesce = coalesce;
            return this;
        }

        @Generated
        public TrainingDatasetBuilder storageConnector(StorageConnector storageConnector) {
            this.storageConnector = storageConnector;
            return this;
        }

        @Generated
        public TrainingDatasetBuilder location(String location) {
            this.location = location;
            return this;
        }

        @Generated
        public TrainingDatasetBuilder splits(List<Split> splits) {
            this.splits = splits;
            return this;
        }

        @Generated
        public TrainingDatasetBuilder trainSplit(String trainSplit) {
            this.trainSplit = trainSplit;
            return this;
        }

        @Generated
        public TrainingDatasetBuilder seed(Long seed) {
            this.seed = seed;
            return this;
        }

        @Generated
        public TrainingDatasetBuilder featureStore(FeatureStoreBase featureStore) {
            this.featureStore = featureStore;
            return this;
        }

        @Generated
        public TrainingDatasetBuilder statisticsConfig(StatisticsConfig statisticsConfig) {
            this.statisticsConfig = statisticsConfig;
            return this;
        }

        @Generated
        public TrainingDatasetBuilder label(List<String> label) {
            this.label = label;
            return this;
        }

        @Generated
        public TrainingDatasetBuilder eventStartTime(String eventStartTime) {
            this.eventStartTime = eventStartTime;
            return this;
        }

        @Generated
        public TrainingDatasetBuilder eventEndTime(String eventEndTime) {
            this.eventEndTime = eventEndTime;
            return this;
        }

        @Generated
        public TrainingDatasetBuilder trainingDatasetType(TrainingDatasetType trainingDatasetType) {
            this.trainingDatasetType = trainingDatasetType;
            return this;
        }

        @Generated
        public TrainingDatasetBuilder validationSize(Float validationSize) {
            this.validationSize = validationSize;
            return this;
        }

        @Generated
        public TrainingDatasetBuilder testSize(Float testSize) {
            this.testSize = testSize;
            return this;
        }

        @Generated
        public TrainingDatasetBuilder trainStart(String trainStart) {
            this.trainStart = trainStart;
            return this;
        }

        @Generated
        public TrainingDatasetBuilder trainEnd(String trainEnd) {
            this.trainEnd = trainEnd;
            return this;
        }

        @Generated
        public TrainingDatasetBuilder validationStart(String validationStart) {
            this.validationStart = validationStart;
            return this;
        }

        @Generated
        public TrainingDatasetBuilder validationEnd(String validationEnd) {
            this.validationEnd = validationEnd;
            return this;
        }

        @Generated
        public TrainingDatasetBuilder testStart(String testStart) {
            this.testStart = testStart;
            return this;
        }

        @Generated
        public TrainingDatasetBuilder testEnd(String testEnd) {
            this.testEnd = testEnd;
            return this;
        }

        @Generated
        public TrainingDatasetBuilder timeSplitSize(Integer timeSplitSize) {
            this.timeSplitSize = timeSplitSize;
            return this;
        }

        @Generated
        public TrainingDatasetBuilder extraFilterLogic(FilterLogic extraFilterLogic) {
            this.extraFilterLogic = extraFilterLogic;
            return this;
        }

        @Generated
        public TrainingDatasetBuilder extraFilter(Filter extraFilter) {
            this.extraFilter = extraFilter;
            return this;
        }

        @Generated
        public TrainingDataset build() throws FeatureStoreException, ParseException {
            return new TrainingDataset(this.version, this.description, this.dataFormat, this.coalesce, this.storageConnector, this.location, this.splits, this.trainSplit, this.seed, this.featureStore, this.statisticsConfig, this.label, this.eventStartTime, this.eventEndTime, this.trainingDatasetType, this.validationSize, this.testSize, this.trainStart, this.trainEnd, this.validationStart, this.validationEnd, this.testStart, this.testEnd, this.timeSplitSize, this.extraFilterLogic, this.extraFilter);
        }

        @Generated
        public String toString() {
            return "TrainingDataset.TrainingDatasetBuilder(version=" + this.version + ", description=" + this.description + ", dataFormat=" + this.dataFormat + ", coalesce=" + this.coalesce + ", storageConnector=" + this.storageConnector + ", location=" + this.location + ", splits=" + this.splits + ", trainSplit=" + this.trainSplit + ", seed=" + this.seed + ", featureStore=" + this.featureStore + ", statisticsConfig=" + this.statisticsConfig + ", label=" + this.label + ", eventStartTime=" + this.eventStartTime + ", eventEndTime=" + this.eventEndTime + ", trainingDatasetType=" + this.trainingDatasetType + ", validationSize=" + this.validationSize + ", testSize=" + this.testSize + ", trainStart=" + this.trainStart + ", trainEnd=" + this.trainEnd + ", validationStart=" + this.validationStart + ", validationEnd=" + this.validationEnd + ", testStart=" + this.testStart + ", testEnd=" + this.testEnd + ", timeSplitSize=" + this.timeSplitSize + ", extraFilterLogic=" + this.extraFilterLogic + ", extraFilter=" + this.extraFilter + ")";
        }
    }
}

