/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.spark.constructor;

import com.logicalclocks.hsfs.Feature;
import com.logicalclocks.hsfs.FeatureGroupBase;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.Storage;
import com.logicalclocks.hsfs.StorageConnector;
import com.logicalclocks.hsfs.constructor.QueryBase;
import com.logicalclocks.hsfs.spark.StreamFeatureGroup;
import com.logicalclocks.hsfs.spark.constructor.FsQuery;
import com.logicalclocks.hsfs.spark.engine.SparkEngine;
import com.logicalclocks.hsfs.spark.util.StorageConnectorUtils;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class Query
extends QueryBase<Query, StreamFeatureGroup, Dataset<Row>> {
    private final StorageConnectorUtils storageConnectorUtils = new StorageConnectorUtils();

    public Query(FeatureGroupBase leftFeatureGroup, List<Feature> leftFeatures) {
        super(leftFeatureGroup, leftFeatures);
    }

    public String sql() {
        return this.sql(Storage.OFFLINE, FsQuery.class);
    }

    public String sql(Storage storage) {
        return this.sql(storage, FsQuery.class);
    }

    public Dataset<Row> read() throws FeatureStoreException, IOException {
        return this.read(false, null);
    }

    public Dataset<Row> read(boolean online) throws FeatureStoreException, IOException {
        return this.read(online, null);
    }

    public Dataset<Row> read(boolean online, Map<String, String> readOptions) throws FeatureStoreException, IOException {
        FsQuery fsQuery = (FsQuery)this.queryConstructorApi.constructQuery(this.leftFeatureGroup.getFeatureStore(), (QueryBase)this, FsQuery.class);
        if (online) {
            QueryBase.LOGGER.info("Executing query: " + fsQuery.getStorageQuery(Storage.ONLINE));
            StorageConnector.JdbcConnector onlineConnector = (StorageConnector.JdbcConnector)this.storageConnectorApi.getOnlineStorageConnector(this.leftFeatureGroup.getFeatureStore(), StorageConnector.JdbcConnector.class);
            return this.storageConnectorUtils.read(onlineConnector, fsQuery.getStorageQuery(Storage.ONLINE));
        }
        fsQuery.registerOnDemandFeatureGroups();
        fsQuery.registerHudiFeatureGroups(readOptions);
        QueryBase.LOGGER.info("Executing query: " + fsQuery.getStorageQuery(Storage.OFFLINE));
        return SparkEngine.getInstance().sql(fsQuery.getStorageQuery(Storage.OFFLINE));
    }

    public void show(int numRows) throws FeatureStoreException, IOException {
        this.show(false, numRows);
    }

    public void show(boolean online, int numRows) throws FeatureStoreException, IOException {
        SparkEngine.getInstance().objectToDataset(this.read(online)).show(numRows);
    }

    @Generated
    public Query() {
    }
}

