/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.spark.engine;

import com.logicalclocks.hsfs.EntityEndpointType;
import com.logicalclocks.hsfs.FeatureGroupBase;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.FeatureViewBase;
import com.logicalclocks.hsfs.Split;
import com.logicalclocks.hsfs.TrainingDatasetBase;
import com.logicalclocks.hsfs.metadata.FeatureDescriptiveStatistics;
import com.logicalclocks.hsfs.metadata.SplitStatistics;
import com.logicalclocks.hsfs.metadata.Statistics;
import com.logicalclocks.hsfs.metadata.StatisticsApi;
import com.logicalclocks.hsfs.spark.FeatureView;
import com.logicalclocks.hsfs.spark.TrainingDataset;
import com.logicalclocks.hsfs.spark.engine.SparkEngine;
import java.io.IOException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsEngine {
    private StatisticsApi statisticsApi;
    private static final Logger LOGGER = LoggerFactory.getLogger(StatisticsEngine.class);

    public StatisticsEngine(EntityEndpointType entityType) {
        this.statisticsApi = new StatisticsApi(entityType);
    }

    public Statistics computeStatistics(TrainingDataset trainingDataset, Dataset<Row> dataFrame) throws IOException, FeatureStoreException {
        Statistics statistics = this.computeStatistics(dataFrame, trainingDataset.getStatisticsConfig().getColumns(), trainingDataset.getStatisticsConfig().getHistograms(), trainingDataset.getStatisticsConfig().getCorrelations(), trainingDataset.getStatisticsConfig().getExactUniqueness(), null);
        return this.statisticsApi.post((TrainingDatasetBase)trainingDataset, statistics);
    }

    public Statistics computeStatistics(FeatureView featureView, TrainingDataset trainingDataset, Dataset<Row> dataFrame) throws FeatureStoreException, IOException {
        Statistics statistics = this.computeStatistics(dataFrame, trainingDataset.getStatisticsConfig().getColumns(), trainingDataset.getStatisticsConfig().getHistograms(), trainingDataset.getStatisticsConfig().getCorrelations(), trainingDataset.getStatisticsConfig().getExactUniqueness(), null);
        return this.statisticsApi.post((FeatureViewBase)featureView, trainingDataset.getVersion(), statistics);
    }

    public Statistics computeStatistics(FeatureGroupBase featureGroup, Dataset<Row> dataFrame, Long commitId) throws FeatureStoreException, IOException {
        Statistics statistics = this.computeStatistics(dataFrame, featureGroup.getStatisticsConfig().getColumns(), featureGroup.getStatisticsConfig().getHistograms(), featureGroup.getStatisticsConfig().getCorrelations(), featureGroup.getStatisticsConfig().getExactUniqueness(), commitId);
        return this.statisticsApi.post(featureGroup, statistics);
    }

    private Statistics computeStatistics(Dataset<Row> dataFrame, List<String> statisticColumns, Boolean histograms, Boolean correlations, Boolean exactUniqueness, Long commitId) {
        String content;
        if (dataFrame.isEmpty()) {
            if (statisticColumns == null || statisticColumns.isEmpty()) {
                statisticColumns = Arrays.asList(dataFrame.columns());
            }
            LOGGER.warn("There is no data in the entity that you are trying to compute statistics for. A possible cause might be that you inserted only data to the online storage of a feature group.");
            content = this.buildEmptyStatistics(statisticColumns);
        } else {
            content = SparkEngine.getInstance().profile(dataFrame, statisticColumns, histograms, correlations, exactUniqueness);
        }
        Collection<FeatureDescriptiveStatistics> featureDescriptiveStatistics = this.parseDeequStatistics(content);
        Long commitTime = Timestamp.valueOf(LocalDateTime.now()).getTime();
        return new Statistics(commitTime, Float.valueOf(1.0f), featureDescriptiveStatistics, commitId, null);
    }

    public Statistics computeAndSaveSplitStatistics(TrainingDataset trainingDataset) throws FeatureStoreException, IOException {
        Statistics statistics = this.computeSplitStatistics(trainingDataset);
        return this.statisticsApi.post((TrainingDatasetBase)trainingDataset, statistics);
    }

    public Statistics computeAndSaveSplitStatistics(FeatureView featureView, TrainingDataset trainingDataset, Map<String, Dataset<Row>> splitDatasets) throws FeatureStoreException, IOException {
        Statistics statistics = this.computeSplitStatistics(trainingDataset, splitDatasets);
        return this.statisticsApi.post((FeatureViewBase)featureView, trainingDataset.getVersion(), statistics);
    }

    public Statistics computeSplitStatistics(TrainingDataset trainingDataset) throws FeatureStoreException, IOException {
        ArrayList<SplitStatistics> splitStatistics = new ArrayList<SplitStatistics>();
        for (Split split : trainingDataset.getSplits()) {
            Statistics statistics = this.computeStatistics(trainingDataset.read(split.getName()), trainingDataset.getStatisticsConfig().getColumns(), trainingDataset.getStatisticsConfig().getHistograms(), trainingDataset.getStatisticsConfig().getCorrelations(), trainingDataset.getStatisticsConfig().getExactUniqueness(), null);
            splitStatistics.add(new SplitStatistics(split.getName(), statistics.getFeatureDescriptiveStatistics()));
        }
        Long commitTime = Timestamp.valueOf(LocalDateTime.now()).getTime();
        return new Statistics(commitTime, Float.valueOf(1.0f), splitStatistics);
    }

    public Statistics computeSplitStatistics(TrainingDataset trainingDataset, Map<String, Dataset<Row>> splitDatasets) {
        ArrayList<SplitStatistics> splitStatistics = new ArrayList<SplitStatistics>();
        for (Map.Entry<String, Dataset<Row>> entry : splitDatasets.entrySet()) {
            Statistics statistics = this.computeStatistics(entry.getValue(), trainingDataset.getStatisticsConfig().getColumns(), trainingDataset.getStatisticsConfig().getHistograms(), trainingDataset.getStatisticsConfig().getCorrelations(), trainingDataset.getStatisticsConfig().getExactUniqueness(), null);
            splitStatistics.add(new SplitStatistics(entry.getKey(), statistics.getFeatureDescriptiveStatistics()));
        }
        Long commitTime = Timestamp.valueOf(LocalDateTime.now()).getTime();
        return new Statistics(commitTime, Float.valueOf(1.0f), splitStatistics);
    }

    public Statistics get(FeatureGroupBase featureGroup, String commitTime) throws FeatureStoreException, IOException {
        return this.statisticsApi.get(featureGroup, commitTime);
    }

    public Statistics get(TrainingDataset trainingDataset, String commitTime) throws FeatureStoreException, IOException {
        return this.statisticsApi.get((TrainingDatasetBase)trainingDataset, commitTime);
    }

    public Statistics getLast(FeatureGroupBase featureGroup) throws FeatureStoreException, IOException {
        return this.statisticsApi.getLast(featureGroup);
    }

    public Statistics getLast(TrainingDataset trainingDataset) throws FeatureStoreException, IOException {
        return this.statisticsApi.getLast((TrainingDatasetBase)trainingDataset);
    }

    private Collection<FeatureDescriptiveStatistics> parseDeequStatistics(String content) {
        JSONArray columns = new JSONObject(content).getJSONArray("columns");
        ArrayList<FeatureDescriptiveStatistics> descStats = new ArrayList<FeatureDescriptiveStatistics>();
        for (int i = 0; i < columns.length(); ++i) {
            JSONObject colStats = (JSONObject)columns.get(i);
            descStats.add(FeatureDescriptiveStatistics.fromDeequStatisticsJson((JSONObject)colStats));
        }
        return descStats;
    }

    private String buildEmptyStatistics(List<String> featureNames) {
        JSONArray columns = new JSONArray();
        for (String name : featureNames) {
            JSONObject colStats = new JSONObject();
            colStats.put("column", (Object)name);
            colStats.put("count", 0L);
            columns.put((Object)colStats);
        }
        JSONObject emptyStats = new JSONObject();
        emptyStats.put("columns", (Object)columns);
        return emptyStats.toString();
    }
}

