/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.spark.engine;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.logicalclocks.hsfs.DataSource;
import com.logicalclocks.hsfs.EntityEndpointType;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.Storage;
import com.logicalclocks.hsfs.TrainingDatasetBase;
import com.logicalclocks.hsfs.constructor.FsQueryBase;
import com.logicalclocks.hsfs.metadata.TagsApi;
import com.logicalclocks.hsfs.metadata.TrainingDatasetApi;
import com.logicalclocks.hsfs.spark.TrainingDataset;
import com.logicalclocks.hsfs.spark.constructor.Query;
import com.logicalclocks.hsfs.spark.engine.SparkEngine;
import com.logicalclocks.hsfs.spark.util.StorageConnectorUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainingDatasetEngine {
    private TrainingDatasetApi trainingDatasetApi = new TrainingDatasetApi();
    private TagsApi tagsApi = new TagsApi(EntityEndpointType.TRAINING_DATASET);
    private final StorageConnectorUtils storageConnectorUtils = new StorageConnectorUtils();
    private static final Logger LOGGER = LoggerFactory.getLogger(TrainingDatasetEngine.class);

    public TrainingDataset save(TrainingDataset trainingDataset, Query query, Map<String, String> userWriteOptions, List<String> labels) throws FeatureStoreException, IOException {
        TrainingDataset apiTD = (TrainingDataset)this.trainingDatasetApi.createTrainingDataset((TrainingDatasetBase)trainingDataset);
        if (trainingDataset.getVersion() == null) {
            LOGGER.info("VersionWarning: No version provided for creating training dataset `" + trainingDataset.getName() + "`, incremented version to `" + apiTD.getVersion() + "`.");
        }
        trainingDataset.setLocation(apiTD.getLocation());
        trainingDataset.setVersion(apiTD.getVersion());
        trainingDataset.setId(apiTD.getId());
        trainingDataset.setStorageConnector(apiTD.getStorageConnector());
        Map<String, String> writeOptions = SparkEngine.getInstance().getWriteOptions(userWriteOptions, trainingDataset.getDataFormat());
        SparkEngine.getInstance().write(trainingDataset, query, Maps.newHashMap(), writeOptions, SaveMode.Overwrite);
        return trainingDataset;
    }

    public Dataset<Row> read(TrainingDataset trainingDataset, String split, Map<String, String> providedOptions) throws FeatureStoreException, IOException {
        Map<String, String> readOptions = SparkEngine.getInstance().getReadOptions(providedOptions, trainingDataset.getDataFormat());
        String path = null;
        path = !Strings.isNullOrEmpty((String)split) ? new Path(trainingDataset.getLocation(), split).toString() : new Path(trainingDataset.getLocation(), trainingDataset.getName()).toString();
        DataSource dataSource = new DataSource();
        dataSource.setPath(path);
        return this.storageConnectorUtils.read(trainingDataset.getStorageConnector(), dataSource, trainingDataset.getDataFormat().toString(), readOptions);
    }

    public void addTag(TrainingDataset trainingDataset, String name, Object value) throws FeatureStoreException, IOException {
        this.tagsApi.add((TrainingDatasetBase)trainingDataset, name, value);
    }

    public Map<String, Object> getTags(TrainingDataset trainingDataset) throws FeatureStoreException, IOException {
        return this.tagsApi.get((TrainingDatasetBase)trainingDataset);
    }

    public Object getTag(TrainingDataset trainingDataset, String name) throws FeatureStoreException, IOException {
        return this.tagsApi.get((TrainingDatasetBase)trainingDataset, name);
    }

    public void deleteTag(TrainingDataset trainingDataset, String name) throws FeatureStoreException, IOException {
        this.tagsApi.deleteTag((TrainingDatasetBase)trainingDataset, name);
    }

    public String getQuery(TrainingDataset trainingDataset, Storage storage, boolean withLabel, boolean isHiveQuery) throws FeatureStoreException, IOException {
        FsQueryBase fsQueryBase = this.trainingDatasetApi.getQuery((TrainingDatasetBase)trainingDataset, withLabel, isHiveQuery);
        if (storage == Storage.OFFLINE) {
            fsQueryBase.registerOnDemandFeatureGroups();
            fsQueryBase.registerHudiFeatureGroups(new HashMap());
        }
        return fsQueryBase.getStorageQuery(storage);
    }

    public void updateStatisticsConfig(TrainingDataset trainingDataset) throws FeatureStoreException, IOException {
        TrainingDataset apiTD = (TrainingDataset)this.trainingDatasetApi.updateMetadata((TrainingDatasetBase)trainingDataset, "updateStatsConfig");
        trainingDataset.getStatisticsConfig().setCorrelations(apiTD.getStatisticsConfig().getCorrelations());
        trainingDataset.getStatisticsConfig().setHistograms(apiTD.getStatisticsConfig().getHistograms());
        trainingDataset.getStatisticsConfig().setExactUniqueness(apiTD.getStatisticsConfig().getExactUniqueness());
    }

    public void delete(TrainingDataset trainingDataset) throws FeatureStoreException, IOException {
        this.trainingDatasetApi.delete((TrainingDatasetBase)trainingDataset);
    }
}

