/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.spark;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.logicalclocks.hsfs.DataSource;
import com.logicalclocks.hsfs.EntityEndpointType;
import com.logicalclocks.hsfs.ExternalDataFormat;
import com.logicalclocks.hsfs.Feature;
import com.logicalclocks.hsfs.FeatureGroupBase;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.OnlineConfig;
import com.logicalclocks.hsfs.StatisticsConfig;
import com.logicalclocks.hsfs.Storage;
import com.logicalclocks.hsfs.StorageConnector;
import com.logicalclocks.hsfs.metadata.OnDemandOptions;
import com.logicalclocks.hsfs.metadata.Statistics;
import com.logicalclocks.hsfs.spark.FeatureStore;
import com.logicalclocks.hsfs.spark.constructor.Query;
import com.logicalclocks.hsfs.spark.engine.FeatureGroupEngine;
import com.logicalclocks.hsfs.spark.engine.StatisticsEngine;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ExternalFeatureGroup
extends FeatureGroupBase<Dataset<Row>> {
    private ExternalDataFormat dataFormat;
    private List<OnDemandOptions> options;
    private final FeatureGroupEngine featureGroupEngine = new FeatureGroupEngine();
    private final StatisticsEngine statisticsEngine = new StatisticsEngine(EntityEndpointType.FEATURE_GROUP);

    public ExternalFeatureGroup(FeatureStore featureStore, @NonNull String name, Integer version, String query, ExternalDataFormat dataFormat, String path, Map<String, String> options, @NonNull StorageConnector storageConnector, String description, List<String> primaryKeys, List<Feature> features, StatisticsConfig statisticsConfig, String eventTime, boolean onlineEnabled, String onlineTopicName, String topicName, String notificationTopicName, OnlineConfig onlineConfig) {
        this();
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (storageConnector == null) {
            throw new NullPointerException("storageConnector is marked non-null but is null");
        }
        this.timeTravelFormat = null;
        this.featureStore = featureStore;
        this.name = name;
        this.version = version;
        this.dataFormat = dataFormat;
        this.options = options != null ? options.entrySet().stream().map(e -> new OnDemandOptions((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList()) : null;
        this.description = description;
        this.primaryKeys = primaryKeys != null ? primaryKeys.stream().map(String::toLowerCase).collect(Collectors.toList()) : null;
        this.storageConnector = storageConnector;
        this.features = features;
        this.statisticsConfig = statisticsConfig != null ? statisticsConfig : new StatisticsConfig();
        this.eventTime = eventTime;
        this.onlineEnabled = onlineEnabled;
        this.onlineTopicName = onlineTopicName;
        this.topicName = topicName;
        this.notificationTopicName = notificationTopicName;
        this.onlineConfig = onlineConfig;
        this.dataSource.setPath(path);
        this.dataSource.setQuery(query);
    }

    public ExternalFeatureGroup() {
        this.type = "onDemandFeaturegroupDTO";
        this.dataSource = new DataSource();
    }

    public ExternalFeatureGroup(FeatureStore featureStore, int id) {
        this();
        this.featureStore = featureStore;
        this.id = id;
    }

    public void save() throws FeatureStoreException, IOException {
        this.featureGroupEngine.saveExternalFeatureGroup(this);
        if (this.statisticsConfig.getEnabled().booleanValue()) {
            this.statisticsEngine.computeStatistics(this, this.read(), null);
        }
    }

    public Dataset<Row> read() throws FeatureStoreException, IOException {
        return this.selectAll().read();
    }

    public Dataset<Row> read(boolean online) throws FeatureStoreException, IOException {
        return this.selectAll().read(online);
    }

    public Dataset<Row> read(Map<String, String> readOptions) throws FeatureStoreException, IOException {
        return this.selectAll().read(false, readOptions);
    }

    public Dataset<Row> read(boolean online, Map<String, String> readOptions) throws FeatureStoreException, IOException {
        return this.selectAll().read(online, readOptions);
    }

    public void show(int numRows) throws FeatureStoreException, IOException {
        this.read().show(numRows);
    }

    public void show(int numRows, boolean online) throws FeatureStoreException, IOException {
        this.read(true).show(numRows);
    }

    public void insert(Dataset<Row> featureData, Storage storage) throws IOException, FeatureStoreException, ParseException {
    }

    public void insert(Dataset<Row> featureData) throws FeatureStoreException, IOException {
        this.featureGroupEngine.insert(this, featureData, null);
        this.computeStatistics();
    }

    public void insert(Dataset<Row> featureData, Map<String, String> writeOptions) throws FeatureStoreException, IOException, ParseException {
        this.featureGroupEngine.insert(this, featureData, writeOptions);
        this.computeStatistics();
    }

    public Query selectFeatures(List<Feature> features) {
        return new Query(this, features);
    }

    public Query select(List<String> features) {
        List<Feature> featureObjList = features.stream().map(Feature::new).collect(Collectors.toList());
        return this.selectFeatures(featureObjList);
    }

    public Query selectAll() {
        return new Query(this, this.getFeatures());
    }

    public Query selectExceptFeatures(List<Feature> features) {
        List<String> exceptFeatures = features.stream().map(Feature::getName).collect(Collectors.toList());
        return this.selectExcept(exceptFeatures);
    }

    public Query selectExcept(List<String> features) {
        return new Query(this, this.getFeatures().stream().filter(f -> !features.contains(f.getName())).collect(Collectors.toList()));
    }

    public Object insertStream(Dataset<Row> featureData) throws Exception {
        throw new UnsupportedOperationException("insertStream method is not supported in ExternalFeatureGroup");
    }

    public Object insertStream(Dataset<Row> featureData, Map<String, String> writeOptions) throws Exception {
        throw new UnsupportedOperationException("insertStream method is not supported in ExternalFeatureGroup");
    }

    public void updateFeatures(List<Feature> features) throws FeatureStoreException, IOException, ParseException {
        this.featureGroupEngine.appendFeatures(this, features, ((Object)((Object)this)).getClass());
    }

    public void updateFeatures(Feature feature) throws FeatureStoreException, IOException, ParseException {
        this.featureGroupEngine.appendFeatures(this, Collections.singletonList(feature), ((Object)((Object)this)).getClass());
    }

    public void appendFeatures(List<Feature> features) throws FeatureStoreException, IOException, ParseException {
        this.featureGroupEngine.appendFeatures(this, new ArrayList<Feature>(features), ((Object)((Object)this)).getClass());
    }

    public void appendFeatures(Feature features) throws FeatureStoreException, IOException, ParseException {
        ArrayList<Feature> featureList = new ArrayList<Feature>();
        featureList.add(features);
        this.featureGroupEngine.appendFeatures(this, featureList, ((Object)((Object)this)).getClass());
    }

    public Statistics computeStatistics() throws FeatureStoreException, IOException {
        if (this.statisticsConfig.getEnabled().booleanValue()) {
            return this.statisticsEngine.computeStatistics(this, this.read(), null);
        }
        LOGGER.info("StorageWarning: The statistics are not enabled of feature group `" + this.name + "`, with version `" + this.version + "`. No statistics computed.");
        return null;
    }

    public Statistics getStatistics() throws FeatureStoreException, IOException {
        return this.statisticsEngine.getLast(this);
    }

    @Generated
    public static ExternalFeatureGroupBuilder builder() {
        return new ExternalFeatureGroupBuilder();
    }

    @Generated
    public ExternalFeatureGroup(ExternalDataFormat dataFormat, List<OnDemandOptions> options) {
        this.dataFormat = dataFormat;
        this.options = options;
    }

    @Generated
    public ExternalDataFormat getDataFormat() {
        return this.dataFormat;
    }

    @Generated
    public void setDataFormat(ExternalDataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    @Generated
    public List<OnDemandOptions> getOptions() {
        return this.options;
    }

    @Generated
    public void setOptions(List<OnDemandOptions> options) {
        this.options = options;
    }

    @Generated
    public static class ExternalFeatureGroupBuilder {
        @Generated
        private FeatureStore featureStore;
        @Generated
        private String name;
        @Generated
        private Integer version;
        @Generated
        private String query;
        @Generated
        private ExternalDataFormat dataFormat;
        @Generated
        private String path;
        @Generated
        private Map<String, String> options;
        @Generated
        private StorageConnector storageConnector;
        @Generated
        private String description;
        @Generated
        private List<String> primaryKeys;
        @Generated
        private List<Feature> features;
        @Generated
        private StatisticsConfig statisticsConfig;
        @Generated
        private String eventTime;
        @Generated
        private boolean onlineEnabled;
        @Generated
        private String onlineTopicName;
        @Generated
        private String topicName;
        @Generated
        private String notificationTopicName;
        @Generated
        private OnlineConfig onlineConfig;

        @Generated
        ExternalFeatureGroupBuilder() {
        }

        @Generated
        public ExternalFeatureGroupBuilder featureStore(FeatureStore featureStore) {
            this.featureStore = featureStore;
            return this;
        }

        @Generated
        public ExternalFeatureGroupBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @Generated
        public ExternalFeatureGroupBuilder version(Integer version) {
            this.version = version;
            return this;
        }

        @Generated
        public ExternalFeatureGroupBuilder query(String query) {
            this.query = query;
            return this;
        }

        @Generated
        public ExternalFeatureGroupBuilder dataFormat(ExternalDataFormat dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        @Generated
        public ExternalFeatureGroupBuilder path(String path) {
            this.path = path;
            return this;
        }

        @Generated
        public ExternalFeatureGroupBuilder options(Map<String, String> options) {
            this.options = options;
            return this;
        }

        @Generated
        public ExternalFeatureGroupBuilder storageConnector(@NonNull StorageConnector storageConnector) {
            if (storageConnector == null) {
                throw new NullPointerException("storageConnector is marked non-null but is null");
            }
            this.storageConnector = storageConnector;
            return this;
        }

        @Generated
        public ExternalFeatureGroupBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public ExternalFeatureGroupBuilder primaryKeys(List<String> primaryKeys) {
            this.primaryKeys = primaryKeys;
            return this;
        }

        @Generated
        public ExternalFeatureGroupBuilder features(List<Feature> features) {
            this.features = features;
            return this;
        }

        @Generated
        public ExternalFeatureGroupBuilder statisticsConfig(StatisticsConfig statisticsConfig) {
            this.statisticsConfig = statisticsConfig;
            return this;
        }

        @Generated
        public ExternalFeatureGroupBuilder eventTime(String eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        @Generated
        public ExternalFeatureGroupBuilder onlineEnabled(boolean onlineEnabled) {
            this.onlineEnabled = onlineEnabled;
            return this;
        }

        @Generated
        public ExternalFeatureGroupBuilder onlineTopicName(String onlineTopicName) {
            this.onlineTopicName = onlineTopicName;
            return this;
        }

        @Generated
        public ExternalFeatureGroupBuilder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        @Generated
        public ExternalFeatureGroupBuilder notificationTopicName(String notificationTopicName) {
            this.notificationTopicName = notificationTopicName;
            return this;
        }

        @Generated
        public ExternalFeatureGroupBuilder onlineConfig(OnlineConfig onlineConfig) {
            this.onlineConfig = onlineConfig;
            return this;
        }

        @Generated
        public ExternalFeatureGroup build() {
            return new ExternalFeatureGroup(this.featureStore, this.name, this.version, this.query, this.dataFormat, this.path, this.options, this.storageConnector, this.description, this.primaryKeys, this.features, this.statisticsConfig, this.eventTime, this.onlineEnabled, this.onlineTopicName, this.topicName, this.notificationTopicName, this.onlineConfig);
        }

        @Generated
        public String toString() {
            return "ExternalFeatureGroup.ExternalFeatureGroupBuilder(featureStore=" + (Object)((Object)this.featureStore) + ", name=" + this.name + ", version=" + this.version + ", query=" + this.query + ", dataFormat=" + this.dataFormat + ", path=" + this.path + ", options=" + this.options + ", storageConnector=" + this.storageConnector + ", description=" + this.description + ", primaryKeys=" + this.primaryKeys + ", features=" + this.features + ", statisticsConfig=" + this.statisticsConfig + ", eventTime=" + this.eventTime + ", onlineEnabled=" + this.onlineEnabled + ", onlineTopicName=" + this.onlineTopicName + ", topicName=" + this.topicName + ", notificationTopicName=" + this.notificationTopicName + ", onlineConfig=" + this.onlineConfig + ")";
        }
    }
}

