/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.spark.engine;

import com.google.common.collect.Maps;
import com.logicalclocks.hsfs.DataFormat;
import com.logicalclocks.hsfs.EntityEndpointType;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.FeatureViewBase;
import com.logicalclocks.hsfs.Split;
import com.logicalclocks.hsfs.TrainingDatasetBase;
import com.logicalclocks.hsfs.TrainingDatasetFeature;
import com.logicalclocks.hsfs.TrainingDatasetType;
import com.logicalclocks.hsfs.engine.FeatureViewEngineBase;
import com.logicalclocks.hsfs.metadata.Statistics;
import com.logicalclocks.hsfs.spark.FeatureStore;
import com.logicalclocks.hsfs.spark.FeatureView;
import com.logicalclocks.hsfs.spark.StreamFeatureGroup;
import com.logicalclocks.hsfs.spark.TrainingDataset;
import com.logicalclocks.hsfs.spark.TrainingDatasetBundle;
import com.logicalclocks.hsfs.spark.constructor.Query;
import com.logicalclocks.hsfs.spark.engine.SparkEngine;
import com.logicalclocks.hsfs.spark.engine.StatisticsEngine;
import com.logicalclocks.hsfs.spark.engine.TrainingDatasetEngine;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.mapred.InvalidInputException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;

public class FeatureViewEngine
extends FeatureViewEngineBase<Query, FeatureView, FeatureStore, StreamFeatureGroup, Dataset<Row>> {
    private TrainingDatasetEngine trainingDatasetEngine = new TrainingDatasetEngine();
    private StatisticsEngine statisticsEngine = new StatisticsEngine(EntityEndpointType.TRAINING_DATASET);

    public FeatureView update(FeatureView featureView) throws FeatureStoreException, IOException {
        this.featureViewApi.update((FeatureViewBase)featureView, FeatureView.class);
        return featureView;
    }

    public FeatureView get(FeatureStore featureStore, String name, Integer version) throws FeatureStoreException, IOException {
        FeatureView featureView = (FeatureView)this.get(featureStore, name, version, FeatureView.class);
        featureView.setFeatureStore(featureStore);
        return featureView;
    }

    public TrainingDatasetBundle createTrainingDataset(FeatureView featureView, TrainingDataset trainingDataset, Map<String, String> userWriteOptions) throws IOException, FeatureStoreException {
        trainingDataset = this.createTrainingDataMetadata(featureView, trainingDataset);
        this.writeTrainingDataset(featureView, trainingDataset, userWriteOptions);
        return new TrainingDatasetBundle(trainingDataset.getVersion());
    }

    public void writeTrainingDataset(FeatureView featureView, TrainingDataset trainingDataset, Map<String, String> userWriteOptions) throws IOException, FeatureStoreException {
        Map<String, String> writeOptions = SparkEngine.getInstance().getWriteOptions(userWriteOptions, trainingDataset.getDataFormat());
        Query query = (Query)this.getBatchQuery(featureView, trainingDataset.getEventStartTime(), trainingDataset.getEventEndTime(), true, trainingDataset.getVersion(), Query.class);
        Dataset<Row>[] datasets = SparkEngine.getInstance().write(trainingDataset, query, Maps.newHashMap(), writeOptions, SaveMode.Overwrite);
        this.computeStatistics(featureView, trainingDataset, datasets);
    }

    public TrainingDatasetBundle getTrainingDataset(FeatureView featureView, Integer trainingDatasetVersion, List<String> requestedSplits, Map<String, String> userReadOptions) throws IOException, FeatureStoreException, ParseException {
        TrainingDataset trainingDataset = ((FeatureStore)featureView.getFeatureStore()).createTrainingDataset().version(trainingDatasetVersion).build();
        return this.getTrainingDataset(featureView, trainingDataset, requestedSplits, userReadOptions);
    }

    public TrainingDatasetBundle getTrainingDataset(FeatureView featureView, TrainingDataset trainingDataset, Map<String, String> userReadOptions) throws IOException, FeatureStoreException {
        return this.getTrainingDataset(featureView, trainingDataset, null, userReadOptions);
    }

    public TrainingDatasetBundle getTrainingDataset(FeatureView featureView, TrainingDataset trainingDataset, List<String> requestedSplits, Map<String, String> userReadOptions) throws IOException, FeatureStoreException {
        TrainingDatasetBundle trainingDatasetBundle;
        TrainingDataset trainingDatasetUpdated = null;
        trainingDatasetUpdated = trainingDataset.getVersion() != null ? this.getTrainingDataMetadata(featureView, trainingDataset.getVersion()) : this.createTrainingDataMetadata(featureView, trainingDataset);
        if (requestedSplits != null) {
            int splitSize = trainingDatasetUpdated.getSplits().size();
            String methodName = "";
            if (splitSize != requestedSplits.size()) {
                if (splitSize == 0) {
                    methodName = "getTrainingData";
                } else if (splitSize == 2) {
                    methodName = "getTrainTestSplit";
                } else if (splitSize == 3) {
                    methodName = "getTrainValidationTestSplit";
                }
                throw new FeatureStoreException(String.format("Incorrect `get` method is used. Use `FeatureView.%s` instead.", methodName));
            }
        }
        if (!TrainingDatasetType.IN_MEMORY_TRAINING_DATASET.equals((Object)trainingDatasetUpdated.getTrainingDatasetType())) {
            try {
                List splits = trainingDatasetUpdated.getSplits();
                if (splits != null && !splits.isEmpty()) {
                    HashMap datasets = Maps.newHashMap();
                    for (Split split : splits) {
                        datasets.put(split.getName(), this.castColumnType(trainingDatasetUpdated.getDataFormat(), this.trainingDatasetEngine.read(trainingDatasetUpdated, split.getName(), userReadOptions), featureView.getFeatures()));
                    }
                    return new TrainingDatasetBundle(trainingDatasetUpdated.getVersion(), datasets, (List<String>)featureView.getLabels());
                }
                return new TrainingDatasetBundle(trainingDatasetUpdated.getVersion(), this.castColumnType(trainingDatasetUpdated.getDataFormat(), this.trainingDatasetEngine.read(trainingDatasetUpdated, "", userReadOptions), featureView.getFeatures()), (List<String>)featureView.getLabels());
            }
            catch (InvalidInputException e) {
                throw new IllegalStateException("Failed to read datasets. Check if path exists or recreate a training dataset.");
            }
        }
        if (trainingDatasetUpdated.getSplits() != null && !trainingDatasetUpdated.getSplits().isEmpty()) {
            Query query = (Query)this.getBatchQuery(featureView, trainingDataset.getEventStartTime(), trainingDataset.getEventEndTime(), true, trainingDataset.getVersion(), Query.class);
            Dataset<Row>[] datasets = SparkEngine.getInstance().splitDataset(trainingDatasetUpdated, query, userReadOptions);
            trainingDatasetBundle = new TrainingDatasetBundle(trainingDatasetUpdated.getVersion(), this.convertSplitDatasetsToMap(trainingDatasetUpdated.getSplits(), datasets), (List<String>)featureView.getLabels());
            this.computeStatistics(featureView, trainingDatasetUpdated, datasets);
        } else {
            Dataset<Row> dataset = this.readDataset(featureView, trainingDatasetUpdated, userReadOptions);
            trainingDatasetBundle = new TrainingDatasetBundle(trainingDatasetUpdated.getVersion(), dataset, (List<String>)featureView.getLabels());
            this.computeStatistics(featureView, trainingDatasetUpdated, new Dataset[]{dataset});
        }
        return trainingDatasetBundle;
    }

    private Dataset<Row> castColumnType(DataFormat dataFormat, Dataset<Row> dataset, List<TrainingDatasetFeature> features) throws FeatureStoreException {
        if (DataFormat.CSV.equals((Object)dataFormat) || DataFormat.TSV.equals((Object)dataFormat)) {
            return SparkEngine.getInstance().castColumnType(dataset, features);
        }
        return dataset;
    }

    private TrainingDataset createTrainingDataMetadata(FeatureView featureView, TrainingDataset trainingDataset) throws IOException, FeatureStoreException {
        this.setEventTime(featureView, trainingDataset);
        return (TrainingDataset)this.featureViewApi.createTrainingData(featureView.getName(), featureView.getVersion(), (TrainingDatasetBase)trainingDataset, TrainingDataset.class);
    }

    private TrainingDataset getTrainingDataMetadata(FeatureView featureView, Integer trainingDatasetVersion) throws IOException, FeatureStoreException {
        return (TrainingDataset)this.featureViewApi.getTrainingData(featureView.getFeatureStore(), featureView.getName(), featureView.getVersion(), trainingDatasetVersion, TrainingDataset.class);
    }

    public Statistics computeStatistics(FeatureView featureView, TrainingDataset trainingDataset, Dataset<Row>[] datasets) throws FeatureStoreException, IOException {
        if (trainingDataset.getStatisticsConfig().getEnabled().booleanValue()) {
            if (trainingDataset.getSplits() != null && !trainingDataset.getSplits().isEmpty()) {
                return this.statisticsEngine.computeAndSaveSplitStatistics(featureView, trainingDataset, this.convertSplitDatasetsToMap(trainingDataset.getSplits(), datasets));
            }
            return this.statisticsEngine.computeStatistics(featureView, trainingDataset, datasets[0]);
        }
        return null;
    }

    protected Map<String, Dataset<Row>> convertSplitDatasetsToMap(List<Split> splits, Dataset<Row>[] datasets) {
        HashMap datasetSplits = Maps.newHashMap();
        for (int i = 0; i < datasets.length; ++i) {
            datasetSplits.put(splits.get(i).getName(), datasets[i]);
        }
        return datasetSplits;
    }

    public void recreateTrainingDataset(FeatureView featureView, Integer version, Map<String, String> userWriteOptions) throws IOException, FeatureStoreException {
        TrainingDataset trainingDataset = this.getTrainingDataMetadata(featureView, version);
        this.writeTrainingDataset(featureView, trainingDataset, userWriteOptions);
    }

    private Dataset<Row> readDataset(FeatureView featureView, TrainingDataset trainingDataset, Map<String, String> userReadOptions) throws IOException, FeatureStoreException {
        Query query = (Query)this.getBatchQuery(featureView, trainingDataset.getEventStartTime(), trainingDataset.getEventEndTime(), true, trainingDataset.getVersion(), Query.class);
        return query.read(false, userReadOptions);
    }

    public String getBatchQueryString(FeatureView featureView, Date startTime, Date endTime, Integer trainingDataVersion) throws FeatureStoreException, IOException {
        Query query = (Query)this.getBatchQuery(featureView, startTime, endTime, false, trainingDataVersion, Query.class);
        return query.sql();
    }

    public Dataset<Row> getBatchData(FeatureView featureView, Date startTime, Date endTime, Map<String, String> readOptions, Integer trainingDataVersion) throws FeatureStoreException, IOException {
        return ((Query)this.getBatchQuery(featureView, startTime, endTime, false, trainingDataVersion, Query.class)).read(false, readOptions);
    }

    public Query getBatchQuery(FeatureView featureView, Date startTime, Date endTime, Boolean withLabels, Integer trainingDataVersion) throws FeatureStoreException, IOException {
        return (Query)this.getBatchQuery(featureView, startTime, endTime, false, trainingDataVersion, Query.class);
    }

    public FeatureView getOrCreateFeatureView(FeatureStore featureStore, String name, Integer version, Query query, String description, List<String> labels) throws FeatureStoreException, IOException {
        FeatureView featureView;
        try {
            featureView = (FeatureView)this.get(featureStore, name, version, FeatureView.class);
        }
        catch (FeatureStoreException | IOException e) {
            if (e.getMessage().contains("Error: 404") && e.getMessage().contains("\"errorCode\":270181")) {
                featureView = new FeatureView.FeatureViewBuilder(featureStore).name(name).version(version).query(query).description(description).labels(labels).build();
            }
            throw e;
        }
        return featureView;
    }
}

