/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.spark;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.logicalclocks.hsfs.EntityEndpointType;
import com.logicalclocks.hsfs.Feature;
import com.logicalclocks.hsfs.FeatureGroupBase;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.HudiOperationType;
import com.logicalclocks.hsfs.JobConfiguration;
import com.logicalclocks.hsfs.StatisticsConfig;
import com.logicalclocks.hsfs.Storage;
import com.logicalclocks.hsfs.TimeTravelFormat;
import com.logicalclocks.hsfs.engine.CodeEngine;
import com.logicalclocks.hsfs.metadata.Statistics;
import com.logicalclocks.hsfs.spark.FeatureStore;
import com.logicalclocks.hsfs.spark.constructor.Query;
import com.logicalclocks.hsfs.spark.engine.FeatureGroupEngine;
import com.logicalclocks.hsfs.spark.engine.StatisticsEngine;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.streaming.StreamingQueryException;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FeatureGroup
extends FeatureGroupBase<Dataset<Row>> {
    private final FeatureGroupEngine featureGroupEngine = new FeatureGroupEngine();
    protected StatisticsEngine statisticsEngine = new StatisticsEngine(EntityEndpointType.FEATURE_GROUP);
    private final CodeEngine codeEngine = new CodeEngine(EntityEndpointType.FEATURE_GROUP);

    public FeatureGroup(FeatureStore featureStore, @NonNull String name, Integer version, String description, List<String> primaryKeys, List<String> partitionKeys, String hudiPrecombineKey, boolean onlineEnabled, TimeTravelFormat timeTravelFormat, List<Feature> features, StatisticsConfig statisticsConfig, String onlineTopicName, String eventTime) {
        this();
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.featureStore = featureStore;
        this.name = name;
        this.version = version;
        this.description = description;
        this.primaryKeys = primaryKeys != null ? primaryKeys.stream().map(String::toLowerCase).collect(Collectors.toList()) : null;
        this.partitionKeys = partitionKeys != null ? partitionKeys.stream().map(String::toLowerCase).collect(Collectors.toList()) : null;
        this.hudiPrecombineKey = timeTravelFormat == TimeTravelFormat.HUDI && hudiPrecombineKey != null ? hudiPrecombineKey.toLowerCase() : null;
        this.onlineEnabled = onlineEnabled;
        this.timeTravelFormat = timeTravelFormat != null ? timeTravelFormat : TimeTravelFormat.HUDI;
        this.features = features;
        this.statisticsConfig = statisticsConfig != null ? statisticsConfig : new StatisticsConfig();
        this.onlineTopicName = onlineTopicName;
        this.eventTime = eventTime;
    }

    public FeatureGroup() {
        this.type = "cachedFeaturegroupDTO";
    }

    public FeatureGroup(FeatureStore featureStore, Integer id) {
        this.featureStore = featureStore;
        this.id = id;
    }

    public FeatureGroup(Integer id, String description, List<Feature> features) {
        this();
        this.id = id;
        this.description = description;
        this.features = features;
    }

    public FeatureGroup(FeatureStore featureStore, int id) {
        this();
        this.featureStore = featureStore;
        this.id = id;
    }

    public Dataset<Row> read() throws FeatureStoreException, IOException {
        return this.read(false, null);
    }

    public Dataset<Row> read(boolean online) throws FeatureStoreException, IOException {
        return this.selectAll().read(online);
    }

    public Dataset<Row> read(Map<String, String> readOptions) throws FeatureStoreException, IOException {
        return this.read(false, readOptions);
    }

    public Dataset<Row> read(boolean online, Map<String, String> readOptions) throws FeatureStoreException, IOException {
        return this.selectAll().read(online, readOptions);
    }

    public Dataset<Row> read(String wallclockTime) throws FeatureStoreException, IOException, ParseException {
        return ((Query)this.selectAll().asOf(wallclockTime)).read(false, null);
    }

    public Dataset<Row> read(String wallclockTime, Map<String, String> readOptions) throws FeatureStoreException, IOException, ParseException {
        return ((Query)this.selectAll().asOf(wallclockTime)).read(false, readOptions);
    }

    @Deprecated
    public Dataset<Row> readChanges(String wallclockStartTime, String wallclockEndTime) throws FeatureStoreException, IOException, ParseException {
        return ((Query)this.selectAll().pullChanges(wallclockStartTime, wallclockEndTime)).read(false, null);
    }

    @Deprecated
    public Dataset<Row> readChanges(String wallclockStartTime, String wallclockEndTime, Map<String, String> readOptions) throws FeatureStoreException, IOException, ParseException {
        return ((Query)this.selectAll().pullChanges(wallclockStartTime, wallclockEndTime)).read(false, readOptions);
    }

    public Query asOf(String wallclockTime) throws FeatureStoreException, ParseException {
        return (Query)this.selectAll().asOf(wallclockTime);
    }

    public Query asOf(String wallclockTime, String excludeUntil) throws FeatureStoreException, ParseException {
        return (Query)this.selectAll().asOf(wallclockTime, excludeUntil);
    }

    public void show(int numRows) throws FeatureStoreException, IOException {
        this.show(numRows, false);
    }

    public void show(int numRows, boolean online) throws FeatureStoreException, IOException {
        this.read(online).show(numRows);
    }

    @Deprecated
    public void save(Dataset<Row> featureData) throws FeatureStoreException, IOException, ParseException {
        this.save(featureData, null);
    }

    @Deprecated
    public void save(Dataset<Row> featureData, Map<String, String> writeOptions) throws FeatureStoreException, IOException, ParseException {
        this.featureGroupEngine.save(this, featureData, this.partitionKeys, this.hudiPrecombineKey, writeOptions);
        this.codeEngine.saveCode((FeatureGroupBase)this);
        if (this.statisticsConfig.getEnabled().booleanValue()) {
            this.statisticsEngine.computeStatistics(this, featureData, null);
        }
    }

    public void insert(Dataset<Row> featureData) throws IOException, FeatureStoreException, ParseException {
        this.insert(featureData, (Storage)null, false);
    }

    public void insert(Dataset<Row> featureData, Map<String, String> writeOptions) throws FeatureStoreException, IOException, ParseException {
        this.insert(featureData, null, false, null, writeOptions);
    }

    public void insert(Dataset<Row> featureData, Storage storage) throws IOException, FeatureStoreException, ParseException {
        this.insert(featureData, storage, false, null, null);
    }

    public void insert(Dataset<Row> featureData, boolean overwrite) throws IOException, FeatureStoreException, ParseException {
        this.insert(featureData, (Storage)null, overwrite);
    }

    public void insert(Dataset<Row> featureData, Storage storage, boolean overwrite) throws IOException, FeatureStoreException, ParseException {
        this.insert(featureData, storage, overwrite, null, null);
    }

    public void insert(Dataset<Row> featureData, boolean overwrite, Map<String, String> writeOptions) throws FeatureStoreException, IOException, ParseException {
        this.insert(featureData, null, overwrite, null, writeOptions);
    }

    public void insert(Dataset<Row> featureData, HudiOperationType operation) throws FeatureStoreException, IOException, ParseException {
        this.insert(featureData, null, false, operation, null);
    }

    public void insert(Dataset<Row> featureData, Storage storage, boolean overwrite, HudiOperationType operation, Map<String, String> writeOptions) throws FeatureStoreException, IOException, ParseException {
        if (operation != null && this.timeTravelFormat == TimeTravelFormat.NONE) {
            throw new IllegalArgumentException("operation argument is valid only for time travel enable feature groups");
        }
        if (operation == null && this.timeTravelFormat == TimeTravelFormat.HUDI) {
            operation = overwrite ? HudiOperationType.BULK_INSERT : HudiOperationType.UPSERT;
        }
        this.featureGroupEngine.insert(this, featureData, storage, operation, overwrite ? SaveMode.Overwrite : SaveMode.Append, this.partitionKeys, this.hudiPrecombineKey, writeOptions);
        this.codeEngine.saveCode((FeatureGroupBase)this);
        this.computeStatistics();
    }

    public void insert(Dataset<Row> featureData, JobConfiguration jobConfiguration) throws FeatureStoreException, IOException, ParseException {
        new FeatureStoreException("This method is not implemented for FeatureGroup class");
    }

    public void insert(Dataset<Row> featureData, boolean overwrite, Map<String, String> writeOptions, JobConfiguration jobConfiguration) throws FeatureStoreException, IOException, ParseException {
        new FeatureStoreException("This method is not implemented for FeatureGroup class");
    }

    @Deprecated
    public StreamingQuery insertStream(Dataset<Row> featureData) throws StreamingQueryException, IOException, FeatureStoreException, TimeoutException, ParseException {
        return this.insertStream(featureData, null, null, false, null, null, null);
    }

    @Deprecated
    public StreamingQuery insertStream(Dataset<Row> featureData, String queryName) throws StreamingQueryException, IOException, FeatureStoreException, TimeoutException, ParseException {
        return this.insertStream(featureData, queryName, null, false, null, null, null);
    }

    @Deprecated
    public StreamingQuery insertStream(Dataset<Row> featureData, Map<String, String> writeOptions) throws FeatureStoreException, IOException, StreamingQueryException, TimeoutException, ParseException {
        return this.insertStream(featureData, null, null, false, null, null, writeOptions);
    }

    public StreamingQuery insertStream(Dataset<Row> featureData, String queryName, Map<String, String> writeOptions) throws FeatureStoreException, IOException, StreamingQueryException, TimeoutException, ParseException {
        return this.insertStream(featureData, queryName, null, false, null, null, writeOptions);
    }

    @Deprecated
    public StreamingQuery insertStream(Dataset<Row> featureData, String queryName, String outputMode) throws StreamingQueryException, IOException, FeatureStoreException, TimeoutException, ParseException {
        return this.insertStream(featureData, queryName, outputMode, false, null, null, null);
    }

    @Deprecated
    public StreamingQuery insertStream(Dataset<Row> featureData, String queryName, String outputMode, String checkpointLocation) throws FeatureStoreException, IOException, StreamingQueryException, TimeoutException, ParseException {
        return this.insertStream(featureData, queryName, outputMode, false, null, checkpointLocation, null);
    }

    @Deprecated
    public StreamingQuery insertStream(Dataset<Row> featureData, String queryName, String outputMode, boolean awaitTermination, Long timeout) throws StreamingQueryException, IOException, FeatureStoreException, TimeoutException, ParseException {
        return this.insertStream(featureData, queryName, outputMode, awaitTermination, timeout, null, null);
    }

    @Deprecated
    public StreamingQuery insertStream(Dataset<Row> featureData, String queryName, String outputMode, boolean awaitTermination, Long timeout, String checkpointLocation) throws FeatureStoreException, IOException, StreamingQueryException, TimeoutException, ParseException {
        return this.insertStream(featureData, queryName, outputMode, awaitTermination, timeout, checkpointLocation, null);
    }

    @Deprecated
    public StreamingQuery insertStream(Dataset<Row> featureData, String queryName, String outputMode, boolean awaitTermination, String checkpointLocation) throws StreamingQueryException, IOException, FeatureStoreException, TimeoutException, ParseException {
        return this.insertStream(featureData, queryName, outputMode, awaitTermination, null, checkpointLocation, null);
    }

    @Deprecated
    public StreamingQuery insertStream(Dataset<Row> featureData, String queryName, String outputMode, boolean awaitTermination, Long timeout, String checkpointLocation, Map<String, String> writeOptions) throws FeatureStoreException, IOException, StreamingQueryException, TimeoutException, ParseException {
        if (!featureData.isStreaming()) {
            throw new FeatureStoreException("Features have to be a streaming type spark dataframe. Use `insert()` method instead.");
        }
        LOGGER.info("StatisticsWarning: Stream ingestion for feature group `" + this.name + "`, with version `" + this.version + "` will not compute statistics.");
        return this.featureGroupEngine.insertStream(this, featureData, queryName, outputMode, awaitTermination, timeout, checkpointLocation, this.partitionKeys, this.hudiPrecombineKey, writeOptions);
    }

    public Object insertStream(Dataset<Row> featureData, String queryName, String outputMode, boolean awaitTermination, Long timeout, String checkpointLocation, Map<String, String> writeOptions, JobConfiguration jobConfiguration) throws FeatureStoreException, IOException, StreamingQueryException, TimeoutException, ParseException {
        return null;
    }

    public void commitDeleteRecord(Dataset<Row> featureData) throws FeatureStoreException, IOException, ParseException {
        this.featureGroupEngine.commitDelete(this, featureData, null);
    }

    public void commitDeleteRecord(Dataset<Row> featureData, Map<String, String> writeOptions) throws FeatureStoreException, IOException, ParseException {
        this.featureGroupEngine.commitDelete(this, featureData, writeOptions);
    }

    public Map<Long, Map<String, String>> commitDetails() throws IOException, FeatureStoreException, ParseException {
        return this.featureGroupEngine.commitDetails(this, null);
    }

    public Map<Long, Map<String, String>> commitDetails(Integer limit) throws IOException, FeatureStoreException, ParseException {
        return this.featureGroupEngine.commitDetails(this, limit);
    }

    public Map<Long, Map<String, String>> commitDetails(String wallclockTime) throws IOException, FeatureStoreException, ParseException {
        return this.featureGroupEngine.commitDetailsByWallclockTime(this, wallclockTime, null);
    }

    public Map<Long, Map<String, String>> commitDetails(String wallclockTime, Integer limit) throws IOException, FeatureStoreException, ParseException {
        return this.featureGroupEngine.commitDetailsByWallclockTime(this, wallclockTime, limit);
    }

    public Query selectFeatures(List<Feature> features) {
        return new Query(this, features);
    }

    public Query select(List<String> features) {
        List featureObjList = features.stream().map(Feature::new).collect(Collectors.toList());
        return this.selectFeatures(featureObjList);
    }

    public Query selectAll() {
        return new Query(this, this.getFeatures());
    }

    public Query selectExceptFeatures(List<Feature> features) {
        List exceptFeatures = features.stream().map(Feature::getName).collect(Collectors.toList());
        return this.selectExcept(exceptFeatures);
    }

    public Query selectExcept(List<String> features) {
        return new Query(this, this.getFeatures().stream().filter(f -> !features.contains(f.getName())).collect(Collectors.toList()));
    }

    public void updateFeatures(List<Feature> features) throws FeatureStoreException, IOException, ParseException {
        this.featureGroupEngine.appendFeatures(this, features, ((Object)((Object)this)).getClass());
    }

    public void updateFeatures(Feature feature) throws FeatureStoreException, IOException, ParseException {
        this.featureGroupEngine.appendFeatures(this, Collections.singletonList(feature), ((Object)((Object)this)).getClass());
    }

    public void appendFeatures(List<Feature> features) throws FeatureStoreException, IOException, ParseException {
        this.featureGroupEngine.appendFeatures(this, new ArrayList<Feature>(features), ((Object)((Object)this)).getClass());
    }

    public void appendFeatures(Feature features) throws FeatureStoreException, IOException, ParseException {
        ArrayList<Feature> featureList = new ArrayList<Feature>();
        featureList.add(features);
        this.featureGroupEngine.appendFeatures(this, featureList, ((Object)((Object)this)).getClass());
    }

    public Statistics computeStatistics() throws FeatureStoreException, IOException {
        if (this.statisticsConfig.getEnabled().booleanValue()) {
            return this.statisticsEngine.computeStatistics(this, this.read(), null);
        }
        LOGGER.info("StorageWarning: The statistics are not enabled of feature group `" + this.name + "`, with version `" + this.version + "`. No statistics computed.");
        return null;
    }

    public Statistics computeStatistics(String wallclockTime) throws FeatureStoreException, IOException, ParseException {
        if (this.statisticsConfig.getEnabled().booleanValue()) {
            Map<Long, Map<String, String>> latestCommitMetaData = this.featureGroupEngine.commitDetailsByWallclockTime(this, wallclockTime, 1);
            Dataset<Row> featureData = ((Query)this.selectAll().asOf(wallclockTime)).read(false, null);
            Long commitId = (Long)latestCommitMetaData.keySet().toArray()[0];
            return this.statisticsEngine.computeStatistics(this, featureData, commitId);
        }
        LOGGER.info("StorageWarning: The statistics are not enabled of feature group `" + this.name + "`, with version `" + this.version + "`. No statistics computed.");
        return null;
    }

    @JsonIgnore
    public Statistics getStatistics() throws FeatureStoreException, IOException {
        return this.statisticsEngine.getLast(this);
    }

    public static FeatureGroupBuilder builder() {
        return new FeatureGroupBuilder();
    }

    public FeatureGroup(StatisticsEngine statisticsEngine) {
        this.statisticsEngine = statisticsEngine;
    }

    public static class FeatureGroupBuilder {
        private FeatureStore featureStore;
        private String name;
        private Integer version;
        private String description;
        private List<String> primaryKeys;
        private List<String> partitionKeys;
        private String hudiPrecombineKey;
        private boolean onlineEnabled;
        private TimeTravelFormat timeTravelFormat;
        private List<Feature> features;
        private StatisticsConfig statisticsConfig;
        private String onlineTopicName;
        private String eventTime;

        FeatureGroupBuilder() {
        }

        public FeatureGroupBuilder featureStore(FeatureStore featureStore) {
            this.featureStore = featureStore;
            return this;
        }

        public FeatureGroupBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public FeatureGroupBuilder version(Integer version) {
            this.version = version;
            return this;
        }

        public FeatureGroupBuilder description(String description) {
            this.description = description;
            return this;
        }

        public FeatureGroupBuilder primaryKeys(List<String> primaryKeys) {
            this.primaryKeys = primaryKeys;
            return this;
        }

        public FeatureGroupBuilder partitionKeys(List<String> partitionKeys) {
            this.partitionKeys = partitionKeys;
            return this;
        }

        public FeatureGroupBuilder hudiPrecombineKey(String hudiPrecombineKey) {
            this.hudiPrecombineKey = hudiPrecombineKey;
            return this;
        }

        public FeatureGroupBuilder onlineEnabled(boolean onlineEnabled) {
            this.onlineEnabled = onlineEnabled;
            return this;
        }

        public FeatureGroupBuilder timeTravelFormat(TimeTravelFormat timeTravelFormat) {
            this.timeTravelFormat = timeTravelFormat;
            return this;
        }

        public FeatureGroupBuilder features(List<Feature> features) {
            this.features = features;
            return this;
        }

        public FeatureGroupBuilder statisticsConfig(StatisticsConfig statisticsConfig) {
            this.statisticsConfig = statisticsConfig;
            return this;
        }

        public FeatureGroupBuilder onlineTopicName(String onlineTopicName) {
            this.onlineTopicName = onlineTopicName;
            return this;
        }

        public FeatureGroupBuilder eventTime(String eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public FeatureGroup build() {
            return new FeatureGroup(this.featureStore, this.name, this.version, this.description, this.primaryKeys, this.partitionKeys, this.hudiPrecombineKey, this.onlineEnabled, this.timeTravelFormat, this.features, this.statisticsConfig, this.onlineTopicName, this.eventTime);
        }

        public String toString() {
            return "FeatureGroup.FeatureGroupBuilder(featureStore=" + (Object)((Object)this.featureStore) + ", name=" + this.name + ", version=" + this.version + ", description=" + this.description + ", primaryKeys=" + this.primaryKeys + ", partitionKeys=" + this.partitionKeys + ", hudiPrecombineKey=" + this.hudiPrecombineKey + ", onlineEnabled=" + this.onlineEnabled + ", timeTravelFormat=" + this.timeTravelFormat + ", features=" + this.features + ", statisticsConfig=" + this.statisticsConfig + ", onlineTopicName=" + this.onlineTopicName + ", eventTime=" + this.eventTime + ")";
        }
    }
}

