/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.spark;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.logicalclocks.hsfs.EntityEndpointType;
import com.logicalclocks.hsfs.ExternalDataFormat;
import com.logicalclocks.hsfs.Feature;
import com.logicalclocks.hsfs.FeatureGroupBase;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.HudiOperationType;
import com.logicalclocks.hsfs.JobConfiguration;
import com.logicalclocks.hsfs.StatisticsConfig;
import com.logicalclocks.hsfs.Storage;
import com.logicalclocks.hsfs.StorageConnector;
import com.logicalclocks.hsfs.constructor.QueryBase;
import com.logicalclocks.hsfs.engine.CodeEngine;
import com.logicalclocks.hsfs.metadata.OnDemandOptions;
import com.logicalclocks.hsfs.metadata.Statistics;
import com.logicalclocks.hsfs.spark.FeatureStore;
import com.logicalclocks.hsfs.spark.constructor.Query;
import com.logicalclocks.hsfs.spark.engine.FeatureGroupEngine;
import com.logicalclocks.hsfs.spark.engine.StatisticsEngine;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ExternalFeatureGroup
extends FeatureGroupBase<Dataset<Row>> {
    private StorageConnector storageConnector;
    private String query;
    private ExternalDataFormat dataFormat;
    private String path;
    private List<OnDemandOptions> options;
    private final FeatureGroupEngine featureGroupEngine = new FeatureGroupEngine();
    private final StatisticsEngine statisticsEngine = new StatisticsEngine(EntityEndpointType.FEATURE_GROUP);
    private final CodeEngine codeEngine = new CodeEngine(EntityEndpointType.FEATURE_GROUP);

    public ExternalFeatureGroup(FeatureStore featureStore, @NonNull String name, Integer version, String query, ExternalDataFormat dataFormat, String path, Map<String, String> options, @NonNull StorageConnector storageConnector, String description, List<String> primaryKeys, List<Feature> features, StatisticsConfig statisticsConfig, String eventTime, boolean onlineEnabled, String onlineTopicName) {
        this();
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (storageConnector == null) {
            throw new NullPointerException("storageConnector is marked non-null but is null");
        }
        this.timeTravelFormat = null;
        this.featureStore = featureStore;
        this.name = name;
        this.version = version;
        this.query = query;
        this.dataFormat = dataFormat;
        this.path = path;
        this.options = options != null ? options.entrySet().stream().map(e -> new OnDemandOptions((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList()) : null;
        this.description = description;
        this.primaryKeys = primaryKeys != null ? primaryKeys.stream().map(String::toLowerCase).collect(Collectors.toList()) : null;
        this.storageConnector = storageConnector;
        this.features = features;
        this.statisticsConfig = statisticsConfig != null ? statisticsConfig : new StatisticsConfig();
        this.eventTime = eventTime;
        this.onlineEnabled = onlineEnabled;
        this.onlineTopicName = onlineTopicName;
    }

    public ExternalFeatureGroup() {
        this.type = "onDemandFeaturegroupDTO";
    }

    public ExternalFeatureGroup(FeatureStore featureStore, int id) {
        this();
        this.featureStore = featureStore;
        this.id = id;
    }

    public void save() throws FeatureStoreException, IOException {
        this.featureGroupEngine.saveExternalFeatureGroup(this);
        this.codeEngine.saveCode((FeatureGroupBase)this);
        if (this.statisticsConfig.getEnabled().booleanValue()) {
            this.statisticsEngine.computeStatistics(this, this.read(), null);
        }
    }

    public Dataset<Row> read() throws FeatureStoreException, IOException {
        return this.selectAll().read();
    }

    public Dataset<Row> read(boolean online) throws FeatureStoreException, IOException {
        return this.selectAll().read(online);
    }

    public Dataset<Row> read(Map<String, String> readOptions) throws FeatureStoreException, IOException {
        return this.selectAll().read(false, readOptions);
    }

    public Dataset<Row> read(boolean online, Map<String, String> readOptions) throws FeatureStoreException, IOException {
        return this.selectAll().read(online, readOptions);
    }

    public Dataset<Row> read(String wallclockTime) throws FeatureStoreException, IOException, ParseException {
        return null;
    }

    public Dataset<Row> read(String wallclockTime, Map<String, String> readOptions) throws FeatureStoreException, IOException, ParseException {
        return null;
    }

    public QueryBase asOf(String wallclockTime) throws FeatureStoreException, ParseException {
        return null;
    }

    public QueryBase asOf(String wallclockTime, String excludeUntil) throws FeatureStoreException, ParseException {
        return null;
    }

    public void show(int numRows) throws FeatureStoreException, IOException {
        this.read().show(numRows);
    }

    public void show(int numRows, boolean online) throws FeatureStoreException, IOException {
        this.read(true).show(numRows);
    }

    public void insert(Dataset<Row> featureData, Storage storage) throws IOException, FeatureStoreException, ParseException {
    }

    public void insert(Dataset<Row> featureData, boolean overwrite) throws IOException, FeatureStoreException, ParseException {
    }

    public void insert(Dataset<Row> featureData, Storage storage, boolean overwrite) throws IOException, FeatureStoreException, ParseException {
    }

    public void insert(Dataset<Row> featureData, boolean overwrite, Map<String, String> writeOptions) throws FeatureStoreException, IOException, ParseException {
    }

    public void insert(Dataset<Row> featureData, HudiOperationType operation) throws FeatureStoreException, IOException, ParseException {
    }

    public void insert(Dataset<Row> featureData, Storage storage, boolean overwrite, HudiOperationType operation, Map<String, String> writeOptions) throws FeatureStoreException, IOException, ParseException {
    }

    public void insert(Dataset<Row> featureData, JobConfiguration jobConfiguration) throws FeatureStoreException, IOException, ParseException {
    }

    public void insert(Dataset<Row> featureData, boolean overwrite, Map<String, String> writeOptions, JobConfiguration jobConfiguration) throws FeatureStoreException, IOException, ParseException {
    }

    public void insert(Dataset<Row> featureData) throws FeatureStoreException, IOException {
        this.featureGroupEngine.insert(this, featureData, null);
        this.codeEngine.saveCode((FeatureGroupBase)this);
        this.computeStatistics();
    }

    public void insert(Dataset<Row> featureData, Map<String, String> writeOptions) throws FeatureStoreException, IOException, ParseException {
        this.featureGroupEngine.insert(this, featureData, writeOptions);
        this.codeEngine.saveCode((FeatureGroupBase)this);
        this.computeStatistics();
    }

    public void commitDeleteRecord(Dataset<Row> featureData) throws FeatureStoreException, IOException, ParseException {
    }

    public void commitDeleteRecord(Dataset<Row> featureData, Map<String, String> writeOptions) throws FeatureStoreException, IOException, ParseException {
    }

    public Map<Long, Map<String, String>> commitDetails() throws IOException, FeatureStoreException, ParseException {
        return null;
    }

    public Map<Long, Map<String, String>> commitDetails(Integer limit) throws IOException, FeatureStoreException, ParseException {
        return null;
    }

    public Map<Long, Map<String, String>> commitDetails(String wallclockTime) throws IOException, FeatureStoreException, ParseException {
        return null;
    }

    public Map<Long, Map<String, String>> commitDetails(String wallclockTime, Integer limit) throws IOException, FeatureStoreException, ParseException {
        return null;
    }

    public Query selectFeatures(List<Feature> features) {
        return new Query(this, features);
    }

    public Query select(List<String> features) {
        List featureObjList = features.stream().map(Feature::new).collect(Collectors.toList());
        return this.selectFeatures(featureObjList);
    }

    public Query selectAll() {
        return new Query(this, this.getFeatures());
    }

    public Query selectExceptFeatures(List<Feature> features) {
        List exceptFeatures = features.stream().map(Feature::getName).collect(Collectors.toList());
        return this.selectExcept(exceptFeatures);
    }

    public Query selectExcept(List<String> features) {
        return new Query(this, this.getFeatures().stream().filter(f -> !features.contains(f.getName())).collect(Collectors.toList()));
    }

    public Object insertStream(Dataset<Row> featureData) throws Exception {
        throw new UnsupportedOperationException("insertStream method is not supported in ExternalFeatureGroup");
    }

    public Object insertStream(Dataset<Row> featureData, String queryName) throws Exception {
        throw new UnsupportedOperationException("insertStream method is not supported in ExternalFeatureGroup");
    }

    public Object insertStream(Dataset<Row> featureData, Map<String, String> writeOptions) throws Exception {
        throw new UnsupportedOperationException("insertStream method is not supported in ExternalFeatureGroup");
    }

    public Object insertStream(Dataset<Row> featureData, String queryName, Map<String, String> writeOptions) throws Exception {
        throw new UnsupportedOperationException("insertStream method is not supported in ExternalFeatureGroup");
    }

    public Object insertStream(Dataset<Row> featureData, String queryName, String outputMode) throws Exception {
        throw new UnsupportedOperationException("insertStream method is not supported in ExternalFeatureGroup");
    }

    public Object insertStream(Dataset<Row> featureData, String queryName, String outputMode, String checkpointLocation) throws Exception {
        throw new UnsupportedOperationException("insertStream method is not supported in ExternalFeatureGroup");
    }

    public Object insertStream(Dataset<Row> featureData, String queryName, String outputMode, boolean awaitTermination, Long timeout) throws Exception {
        throw new UnsupportedOperationException("insertStream method is not supported in ExternalFeatureGroup");
    }

    public Object insertStream(Dataset<Row> featureData, String queryName, String outputMode, boolean awaitTermination, Long timeout, String checkpointLocation) throws Exception {
        throw new UnsupportedOperationException("insertStream method is not supported in ExternalFeatureGroup");
    }

    public Object insertStream(Dataset<Row> featureData, String queryName, String outputMode, boolean awaitTermination, Long timeout, String checkpointLocation, Map<String, String> writeOptions) throws Exception {
        throw new UnsupportedOperationException("insertStream method is not supported in ExternalFeatureGroup");
    }

    public Object insertStream(Dataset<Row> featureData, String queryName, String outputMode, boolean awaitTermination, String checkpointLocation) throws Exception {
        throw new UnsupportedOperationException("insertStream method is not supported in ExternalFeatureGroup");
    }

    public Object insertStream(Dataset<Row> featureData, String queryName, String outputMode, boolean awaitTermination, Long timeout, String checkpointLocation, Map<String, String> writeOptions, JobConfiguration jobConfiguration) throws Exception {
        throw new UnsupportedOperationException("insertStream method is not supported in ExternalFeatureGroup");
    }

    public void updateFeatures(List<Feature> features) throws FeatureStoreException, IOException, ParseException {
        this.featureGroupEngine.appendFeatures(this, features, ((Object)((Object)this)).getClass());
    }

    public void updateFeatures(Feature feature) throws FeatureStoreException, IOException, ParseException {
        this.featureGroupEngine.appendFeatures(this, Collections.singletonList(feature), ((Object)((Object)this)).getClass());
    }

    public void appendFeatures(List<Feature> features) throws FeatureStoreException, IOException, ParseException {
        this.featureGroupEngine.appendFeatures(this, new ArrayList<Feature>(features), ((Object)((Object)this)).getClass());
    }

    public void appendFeatures(Feature features) throws FeatureStoreException, IOException, ParseException {
        ArrayList<Feature> featureList = new ArrayList<Feature>();
        featureList.add(features);
        this.featureGroupEngine.appendFeatures(this, featureList, ((Object)((Object)this)).getClass());
    }

    public Statistics computeStatistics() throws FeatureStoreException, IOException {
        if (this.statisticsConfig.getEnabled().booleanValue()) {
            return this.statisticsEngine.computeStatistics(this, this.read(), null);
        }
        LOGGER.info("StorageWarning: The statistics are not enabled of feature group `" + this.name + "`, with version `" + this.version + "`. No statistics computed.");
        return null;
    }

    public Statistics computeStatistics(String wallclockTime) throws FeatureStoreException, IOException, ParseException {
        return null;
    }

    public Statistics getStatistics() throws FeatureStoreException, IOException {
        return null;
    }

    public static ExternalFeatureGroupBuilder builder() {
        return new ExternalFeatureGroupBuilder();
    }

    public ExternalFeatureGroup(StorageConnector storageConnector, String query, ExternalDataFormat dataFormat, String path, List<OnDemandOptions> options) {
        this.storageConnector = storageConnector;
        this.query = query;
        this.dataFormat = dataFormat;
        this.path = path;
        this.options = options;
    }

    public StorageConnector getStorageConnector() {
        return this.storageConnector;
    }

    public void setStorageConnector(StorageConnector storageConnector) {
        this.storageConnector = storageConnector;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public ExternalDataFormat getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(ExternalDataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public List<OnDemandOptions> getOptions() {
        return this.options;
    }

    public void setOptions(List<OnDemandOptions> options) {
        this.options = options;
    }

    public static class ExternalFeatureGroupBuilder {
        private FeatureStore featureStore;
        private String name;
        private Integer version;
        private String query;
        private ExternalDataFormat dataFormat;
        private String path;
        private Map<String, String> options;
        private StorageConnector storageConnector;
        private String description;
        private List<String> primaryKeys;
        private List<Feature> features;
        private StatisticsConfig statisticsConfig;
        private String eventTime;
        private boolean onlineEnabled;
        private String onlineTopicName;

        ExternalFeatureGroupBuilder() {
        }

        public ExternalFeatureGroupBuilder featureStore(FeatureStore featureStore) {
            this.featureStore = featureStore;
            return this;
        }

        public ExternalFeatureGroupBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public ExternalFeatureGroupBuilder version(Integer version) {
            this.version = version;
            return this;
        }

        public ExternalFeatureGroupBuilder query(String query) {
            this.query = query;
            return this;
        }

        public ExternalFeatureGroupBuilder dataFormat(ExternalDataFormat dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        public ExternalFeatureGroupBuilder path(String path) {
            this.path = path;
            return this;
        }

        public ExternalFeatureGroupBuilder options(Map<String, String> options) {
            this.options = options;
            return this;
        }

        public ExternalFeatureGroupBuilder storageConnector(@NonNull StorageConnector storageConnector) {
            if (storageConnector == null) {
                throw new NullPointerException("storageConnector is marked non-null but is null");
            }
            this.storageConnector = storageConnector;
            return this;
        }

        public ExternalFeatureGroupBuilder description(String description) {
            this.description = description;
            return this;
        }

        public ExternalFeatureGroupBuilder primaryKeys(List<String> primaryKeys) {
            this.primaryKeys = primaryKeys;
            return this;
        }

        public ExternalFeatureGroupBuilder features(List<Feature> features) {
            this.features = features;
            return this;
        }

        public ExternalFeatureGroupBuilder statisticsConfig(StatisticsConfig statisticsConfig) {
            this.statisticsConfig = statisticsConfig;
            return this;
        }

        public ExternalFeatureGroupBuilder eventTime(String eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public ExternalFeatureGroupBuilder onlineEnabled(boolean onlineEnabled) {
            this.onlineEnabled = onlineEnabled;
            return this;
        }

        public ExternalFeatureGroupBuilder onlineTopicName(String onlineTopicName) {
            this.onlineTopicName = onlineTopicName;
            return this;
        }

        public ExternalFeatureGroup build() {
            return new ExternalFeatureGroup(this.featureStore, this.name, this.version, this.query, this.dataFormat, this.path, this.options, this.storageConnector, this.description, this.primaryKeys, this.features, this.statisticsConfig, this.eventTime, this.onlineEnabled, this.onlineTopicName);
        }

        public String toString() {
            return "ExternalFeatureGroup.ExternalFeatureGroupBuilder(featureStore=" + (Object)((Object)this.featureStore) + ", name=" + this.name + ", version=" + this.version + ", query=" + this.query + ", dataFormat=" + this.dataFormat + ", path=" + this.path + ", options=" + this.options + ", storageConnector=" + this.storageConnector + ", description=" + this.description + ", primaryKeys=" + this.primaryKeys + ", features=" + this.features + ", statisticsConfig=" + this.statisticsConfig + ", eventTime=" + this.eventTime + ", onlineEnabled=" + this.onlineEnabled + ", onlineTopicName=" + this.onlineTopicName + ")";
        }
    }
}

