/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs;

import com.logicalclocks.hsfs.FeatureStoreException;
import org.apache.parquet.Strings;

public class Feature {
    private String name;
    private String type;
    private String onlineType;
    private String description;
    private Boolean primary;
    private Boolean partition;

    public Feature(String name) {
        this.name = name;
    }

    public Feature(String name, String type) {
        this.name = name;
        this.type = type;
    }

    public Feature(String name, String type, String onlineType, Boolean primary, Boolean partition) throws FeatureStoreException {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new FeatureStoreException("Name is required when creating a feature");
        }
        this.name = name;
        if (Strings.isNullOrEmpty((String)type)) {
            throw new FeatureStoreException("Type is required when creating a feature");
        }
        this.type = type;
        this.onlineType = onlineType;
        this.primary = primary;
        this.partition = partition;
    }

    public static FeatureBuilder builder() {
        return new FeatureBuilder();
    }

    public Feature(String name, String type, String onlineType, String description, Boolean primary, Boolean partition) {
        this.name = name;
        this.type = type;
        this.onlineType = onlineType;
        this.description = description;
        this.primary = primary;
        this.partition = partition;
    }

    public Feature() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getOnlineType() {
        return this.onlineType;
    }

    public void setOnlineType(String onlineType) {
        this.onlineType = onlineType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getPrimary() {
        return this.primary;
    }

    public void setPrimary(Boolean primary) {
        this.primary = primary;
    }

    public Boolean getPartition() {
        return this.partition;
    }

    public void setPartition(Boolean partition) {
        this.partition = partition;
    }

    public static class FeatureBuilder {
        private String name;
        private String type;
        private String onlineType;
        private Boolean primary;
        private Boolean partition;

        FeatureBuilder() {
        }

        public FeatureBuilder name(String name) {
            this.name = name;
            return this;
        }

        public FeatureBuilder type(String type) {
            this.type = type;
            return this;
        }

        public FeatureBuilder onlineType(String onlineType) {
            this.onlineType = onlineType;
            return this;
        }

        public FeatureBuilder primary(Boolean primary) {
            this.primary = primary;
            return this;
        }

        public FeatureBuilder partition(Boolean partition) {
            this.partition = partition;
            return this;
        }

        public Feature build() throws FeatureStoreException {
            return new Feature(this.name, this.type, this.onlineType, this.primary, this.partition);
        }

        public String toString() {
            return "Feature.FeatureBuilder(name=" + this.name + ", type=" + this.type + ", onlineType=" + this.onlineType + ", primary=" + this.primary + ", partition=" + this.partition + ")";
        }
    }
}

