/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.logicalclocks.hsfs.EntityEndpointType;
import com.logicalclocks.hsfs.Feature;
import com.logicalclocks.hsfs.FeatureStore;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.Storage;
import com.logicalclocks.hsfs.engine.FeatureGroupEngine;
import com.logicalclocks.hsfs.engine.StatisticsEngine;
import com.logicalclocks.hsfs.metadata.Query;
import com.logicalclocks.hsfs.metadata.Statistics;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FeatureGroup {
    private Integer id;
    private String name;
    private Integer version;
    private String description;
    private FeatureStore featureStore;
    private List<Feature> features;
    private Date created;
    private String creator;
    private Storage defaultStorage;
    private Boolean onlineEnabled;
    private String type = "cachedFeaturegroupDTO";
    @JsonProperty(value="descStatsEnabled")
    private Boolean statisticsEnabled;
    @JsonProperty(value="featHistEnabled")
    private Boolean histograms;
    @JsonProperty(value="featCorrEnabled")
    private Boolean correlations;
    private List<String> statisticColumns;
    @JsonIgnore
    private List<String> primaryKeys;
    @JsonIgnore
    private List<String> partitionKeys;
    private FeatureGroupEngine featureGroupEngine = new FeatureGroupEngine();
    private StatisticsEngine statisticsEngine = new StatisticsEngine(EntityEndpointType.FEATURE_GROUP);
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureGroup.class);

    public FeatureGroup(FeatureStore featureStore, @NonNull String name, Integer version, String description, List<String> primaryKeys, List<String> partitionKeys, boolean onlineEnabled, Storage defaultStorage, List<Feature> features, Boolean statisticsEnabled, Boolean histograms, Boolean correlations, List<String> statisticColumns) throws FeatureStoreException {
        if (name == null) {
            throw new NullPointerException("name is marked @NonNull but is null");
        }
        this.featureStore = featureStore;
        this.name = name;
        this.version = version;
        this.description = description;
        this.primaryKeys = primaryKeys;
        this.partitionKeys = partitionKeys;
        this.onlineEnabled = onlineEnabled;
        this.defaultStorage = defaultStorage != null ? defaultStorage : Storage.OFFLINE;
        this.features = features;
        this.statisticsEnabled = statisticsEnabled != null ? statisticsEnabled : true;
        this.histograms = histograms;
        this.correlations = correlations;
        this.statisticColumns = statisticColumns;
    }

    public FeatureGroup() {
    }

    public Query selectFeatures(List<Feature> features) throws FeatureStoreException, IOException {
        return new Query(this, features);
    }

    public Query selectAll() throws FeatureStoreException, IOException {
        return new Query(this, this.getFeatures());
    }

    public Query select(List<String> features) throws FeatureStoreException, IOException {
        List<Feature> featureObjList = features.stream().map(Feature::new).collect(Collectors.toList());
        return this.selectFeatures(featureObjList);
    }

    public Dataset<Row> read() throws FeatureStoreException, IOException {
        return this.read(this.defaultStorage);
    }

    public Dataset<Row> read(Storage storage) throws FeatureStoreException, IOException {
        return this.selectAll().read(storage);
    }

    public void show(int numRows) throws FeatureStoreException, IOException {
        this.show(numRows, this.defaultStorage);
    }

    public void show(int numRows, Storage storage) throws FeatureStoreException, IOException {
        this.read(storage).show(numRows);
    }

    public void save(Dataset<Row> featureData) throws FeatureStoreException, IOException {
        this.save(featureData, null);
    }

    public void save(Dataset<Row> featureData, Map<String, String> writeOptions) throws FeatureStoreException, IOException {
        this.featureGroupEngine.saveFeatureGroup(this, featureData, this.primaryKeys, this.partitionKeys, this.defaultStorage, writeOptions);
        if (this.statisticsEnabled.booleanValue()) {
            this.statisticsEngine.computeStatistics(this, featureData);
        }
    }

    public void insert(Dataset<Row> featureData, Storage storage) throws IOException, FeatureStoreException {
        this.insert(featureData, storage, false, null);
    }

    public void insert(Dataset<Row> featureData, boolean overwrite) throws IOException, FeatureStoreException {
        this.insert(featureData, overwrite, null);
    }

    public void insert(Dataset<Row> featureData, Storage storage, boolean overwrite) throws IOException, FeatureStoreException {
        this.insert(featureData, storage, overwrite, null);
    }

    public void insert(Dataset<Row> featureData, boolean overwrite, Map<String, String> writeOptions) throws FeatureStoreException, IOException {
        this.insert(featureData, this.defaultStorage, overwrite, writeOptions);
    }

    public void insert(Dataset<Row> featureData, Storage storage, boolean overwrite, Map<String, String> writeOptions) throws FeatureStoreException, IOException {
        this.featureGroupEngine.saveDataframe(this, featureData, storage, overwrite ? SaveMode.Overwrite : SaveMode.Append, writeOptions);
        this.computeStatistics();
    }

    public void delete() throws FeatureStoreException, IOException {
        this.featureGroupEngine.delete(this);
    }

    public void updateStatisticsConfig() throws FeatureStoreException, IOException {
        this.featureGroupEngine.updateStatisticsConfig(this);
    }

    public Statistics computeStatistics() throws FeatureStoreException, IOException {
        if (this.statisticsEnabled.booleanValue()) {
            if (this.defaultStorage == Storage.ALL || this.defaultStorage == Storage.OFFLINE) {
                return this.statisticsEngine.computeStatistics(this, this.read(Storage.OFFLINE));
            }
            LOGGER.info("StorageWarning: The default storage of feature group `" + this.name + "`, with version `" + this.version + "`, is `" + (Object)((Object)this.defaultStorage) + "`. Statistics are only computed for default storage `offline and `all`.");
        }
        return null;
    }

    @JsonIgnore
    public Statistics getStatistics() throws FeatureStoreException, IOException {
        return this.statisticsEngine.getLast(this);
    }

    @JsonIgnore
    public Statistics getStatistics(String commitTime) throws FeatureStoreException, IOException {
        return this.statisticsEngine.get(this, commitTime);
    }

    public void addTag(String name) throws FeatureStoreException, IOException {
        this.addTag(name, null);
    }

    public void addTag(String name, String value) throws FeatureStoreException, IOException {
        this.featureGroupEngine.addTag(this, name, value);
    }

    @JsonIgnore
    public Map<String, String> getTag() throws FeatureStoreException, IOException {
        return this.getTag(null);
    }

    @JsonIgnore
    public Map<String, String> getTag(String name) throws FeatureStoreException, IOException {
        return this.featureGroupEngine.getTag(this, name);
    }

    public void deleteTag(String name) throws FeatureStoreException, IOException {
        this.featureGroupEngine.deleteTag(this, name);
    }

    public static FeatureGroupBuilder builder() {
        return new FeatureGroupBuilder();
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public FeatureStore getFeatureStore() {
        return this.featureStore;
    }

    public void setFeatureStore(FeatureStore featureStore) {
        this.featureStore = featureStore;
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<Feature> features) {
        this.features = features;
    }

    public Date getCreated() {
        return this.created;
    }

    public String getCreator() {
        return this.creator;
    }

    public Storage getDefaultStorage() {
        return this.defaultStorage;
    }

    public void setDefaultStorage(Storage defaultStorage) {
        this.defaultStorage = defaultStorage;
    }

    public Boolean getOnlineEnabled() {
        return this.onlineEnabled;
    }

    public void setOnlineEnabled(Boolean onlineEnabled) {
        this.onlineEnabled = onlineEnabled;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Boolean getStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public void setStatisticsEnabled(Boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }

    public Boolean getHistograms() {
        return this.histograms;
    }

    public void setHistograms(Boolean histograms) {
        this.histograms = histograms;
    }

    public Boolean getCorrelations() {
        return this.correlations;
    }

    public void setCorrelations(Boolean correlations) {
        this.correlations = correlations;
    }

    public List<String> getStatisticColumns() {
        return this.statisticColumns;
    }

    public void setStatisticColumns(List<String> statisticColumns) {
        this.statisticColumns = statisticColumns;
    }

    public static class FeatureGroupBuilder {
        private FeatureStore featureStore;
        private String name;
        private Integer version;
        private String description;
        private List<String> primaryKeys;
        private List<String> partitionKeys;
        private boolean onlineEnabled;
        private Storage defaultStorage;
        private List<Feature> features;
        private Boolean statisticsEnabled;
        private Boolean histograms;
        private Boolean correlations;
        private List<String> statisticColumns;

        FeatureGroupBuilder() {
        }

        public FeatureGroupBuilder featureStore(FeatureStore featureStore) {
            this.featureStore = featureStore;
            return this;
        }

        public FeatureGroupBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked @NonNull but is null");
            }
            this.name = name;
            return this;
        }

        public FeatureGroupBuilder version(Integer version) {
            this.version = version;
            return this;
        }

        public FeatureGroupBuilder description(String description) {
            this.description = description;
            return this;
        }

        public FeatureGroupBuilder primaryKeys(List<String> primaryKeys) {
            this.primaryKeys = primaryKeys;
            return this;
        }

        public FeatureGroupBuilder partitionKeys(List<String> partitionKeys) {
            this.partitionKeys = partitionKeys;
            return this;
        }

        public FeatureGroupBuilder onlineEnabled(boolean onlineEnabled) {
            this.onlineEnabled = onlineEnabled;
            return this;
        }

        public FeatureGroupBuilder defaultStorage(Storage defaultStorage) {
            this.defaultStorage = defaultStorage;
            return this;
        }

        public FeatureGroupBuilder features(List<Feature> features) {
            this.features = features;
            return this;
        }

        public FeatureGroupBuilder statisticsEnabled(Boolean statisticsEnabled) {
            this.statisticsEnabled = statisticsEnabled;
            return this;
        }

        public FeatureGroupBuilder histograms(Boolean histograms) {
            this.histograms = histograms;
            return this;
        }

        public FeatureGroupBuilder correlations(Boolean correlations) {
            this.correlations = correlations;
            return this;
        }

        public FeatureGroupBuilder statisticColumns(List<String> statisticColumns) {
            this.statisticColumns = statisticColumns;
            return this;
        }

        public FeatureGroup build() throws FeatureStoreException {
            return new FeatureGroup(this.featureStore, this.name, this.version, this.description, this.primaryKeys, this.partitionKeys, this.onlineEnabled, this.defaultStorage, this.features, this.statisticsEnabled, this.histograms, this.correlations, this.statisticColumns);
        }

        public String toString() {
            return "FeatureGroup.FeatureGroupBuilder(featureStore=" + this.featureStore + ", name=" + this.name + ", version=" + this.version + ", description=" + this.description + ", primaryKeys=" + this.primaryKeys + ", partitionKeys=" + this.partitionKeys + ", onlineEnabled=" + this.onlineEnabled + ", defaultStorage=" + (Object)((Object)this.defaultStorage) + ", features=" + this.features + ", statisticsEnabled=" + this.statisticsEnabled + ", histograms=" + this.histograms + ", correlations=" + this.correlations + ", statisticColumns=" + this.statisticColumns + ")";
        }
    }
}

