/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.Storage;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FsQuery {
    private String query;
    private String queryOnline;

    public void removeNewLines() {
        this.query = this.query.replace("\n", " ");
        this.queryOnline = this.queryOnline.replace("\n", " ");
    }

    public String getStorageQuery(Storage storage) throws FeatureStoreException {
        switch (storage) {
            case OFFLINE: {
                return this.query;
            }
            case ONLINE: {
                return this.queryOnline;
            }
        }
        throw new FeatureStoreException("Cannot run query on ALL storages");
    }

    public FsQuery(String query, String queryOnline) {
        this.query = query;
        this.queryOnline = queryOnline;
    }

    public FsQuery() {
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getQueryOnline() {
        return this.queryOnline;
    }

    public void setQueryOnline(String queryOnline) {
        this.queryOnline = queryOnline;
    }
}

