/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs;

import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.StorageConnectorType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class StorageConnector {
    private Integer id;
    private String name;
    private String accessKey;
    private String secretKey;
    private String serverEncryptionAlgorithm;
    private String serverEncryptionKey;
    private String bucket;
    private String connectionString;
    private String arguments;
    private StorageConnectorType storageConnectorType;

    public Map<String, String> getSparkOptions() throws FeatureStoreException {
        List args = Arrays.stream(this.arguments.split(",")).map(arg -> arg.split("=")).collect(Collectors.toList());
        String user = args.stream().filter(arg -> arg[0].equalsIgnoreCase("user")).findFirst().orElseThrow(() -> new FeatureStoreException("No user provided for storage connector"))[1];
        String password = args.stream().filter(arg -> arg[0].equalsIgnoreCase("password")).findFirst().orElseThrow(() -> new FeatureStoreException("No password provided for storage connector"))[1];
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("url", this.connectionString);
        options.put("user", user);
        options.put("password", password);
        return options;
    }

    public StorageConnector(Integer id, String name, String accessKey, String secretKey, String serverEncryptionAlgorithm, String serverEncryptionKey, String bucket, String connectionString, String arguments, StorageConnectorType storageConnectorType) {
        this.id = id;
        this.name = name;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.serverEncryptionAlgorithm = serverEncryptionAlgorithm;
        this.serverEncryptionKey = serverEncryptionKey;
        this.bucket = bucket;
        this.connectionString = connectionString;
        this.arguments = arguments;
        this.storageConnectorType = storageConnectorType;
    }

    public StorageConnector() {
    }

    public String toString() {
        return "StorageConnector(id=" + this.getId() + ", name=" + this.getName() + ", accessKey=" + this.getAccessKey() + ", secretKey=" + this.getSecretKey() + ", serverEncryptionAlgorithm=" + this.getServerEncryptionAlgorithm() + ", serverEncryptionKey=" + this.getServerEncryptionKey() + ", bucket=" + this.getBucket() + ", connectionString=" + this.getConnectionString() + ", arguments=" + this.getArguments() + ", storageConnectorType=" + (Object)((Object)this.getStorageConnectorType()) + ")";
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getServerEncryptionAlgorithm() {
        return this.serverEncryptionAlgorithm;
    }

    public void setServerEncryptionAlgorithm(String serverEncryptionAlgorithm) {
        this.serverEncryptionAlgorithm = serverEncryptionAlgorithm;
    }

    public String getServerEncryptionKey() {
        return this.serverEncryptionKey;
    }

    public void setServerEncryptionKey(String serverEncryptionKey) {
        this.serverEncryptionKey = serverEncryptionKey;
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public String getArguments() {
        return this.arguments;
    }

    public void setArguments(String arguments) {
        this.arguments = arguments;
    }

    public StorageConnectorType getStorageConnectorType() {
        return this.storageConnectorType;
    }

    public void setStorageConnectorType(StorageConnectorType storageConnectorType) {
        this.storageConnectorType = storageConnectorType;
    }
}

