/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.engine;

import com.logicalclocks.hsfs.EntityEndpointType;
import com.logicalclocks.hsfs.FeatureGroup;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.Storage;
import com.logicalclocks.hsfs.StorageConnector;
import com.logicalclocks.hsfs.engine.SparkEngine;
import com.logicalclocks.hsfs.engine.Utils;
import com.logicalclocks.hsfs.metadata.FeatureGroupApi;
import com.logicalclocks.hsfs.metadata.StorageConnectorApi;
import com.logicalclocks.hsfs.metadata.TagsApi;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureGroupEngine {
    private FeatureGroupApi featureGroupApi = new FeatureGroupApi();
    private StorageConnectorApi storageConnectorApi = new StorageConnectorApi();
    private TagsApi tagsApi = new TagsApi(EntityEndpointType.FEATURE_GROUP);
    private Utils utils = new Utils();
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureGroupEngine.class);

    public void saveFeatureGroup(FeatureGroup featureGroup, Dataset<Row> dataset, List<String> primaryKeys, List<String> partitionKeys, Storage storage, Map<String, String> writeOptions) throws FeatureStoreException, IOException {
        if (featureGroup.getFeatureStore() != null) {
            featureGroup.setFeatures(this.utils.parseSchema(dataset));
        }
        LOGGER.info("Featuregroup features: " + featureGroup.getFeatures());
        if (primaryKeys != null) {
            primaryKeys.forEach(pk -> featureGroup.getFeatures().forEach(f -> {
                if (f.getName().equals(pk)) {
                    f.setPrimary(true);
                }
            }));
        }
        if (partitionKeys != null) {
            partitionKeys.forEach(pk -> featureGroup.getFeatures().forEach(f -> {
                if (f.getName().equals(pk)) {
                    f.setPartition(true);
                }
            }));
        }
        FeatureGroup apiFG = this.featureGroupApi.save(featureGroup);
        if (featureGroup.getVersion() == null) {
            LOGGER.info("VersionWarning: No version provided for creating feature group `" + featureGroup.getName() + "`, incremented version to `" + apiFG.getVersion() + "`.");
        }
        featureGroup.setVersion(apiFG.getVersion());
        featureGroup.setId(apiFG.getId());
        featureGroup.setCorrelations(apiFG.getCorrelations());
        featureGroup.setHistograms(apiFG.getHistograms());
        this.saveDataframe(featureGroup, dataset, storage, SaveMode.Append, writeOptions);
    }

    public void saveDataframe(FeatureGroup featureGroup, Dataset<Row> dataset, Storage storage, SaveMode saveMode, Map<String, String> writeOptions) throws IOException, FeatureStoreException {
        if (storage == null) {
            throw new FeatureStoreException("Storage not supported");
        }
        switch (storage) {
            case OFFLINE: {
                this.saveOfflineDataframe(featureGroup, dataset, saveMode, writeOptions);
                break;
            }
            case ONLINE: {
                this.saveOnlineDataframe(featureGroup, dataset, saveMode, writeOptions);
                break;
            }
            case ALL: {
                this.saveOfflineDataframe(featureGroup, dataset, saveMode, writeOptions);
                this.saveOnlineDataframe(featureGroup, dataset, saveMode, writeOptions);
                break;
            }
            default: {
                throw new FeatureStoreException("Storage: " + (Object)((Object)storage) + " not recognized");
            }
        }
    }

    private void saveOfflineDataframe(FeatureGroup featureGroup, Dataset<Row> dataset, SaveMode saveMode, Map<String, String> writeOptions) throws FeatureStoreException, IOException {
        if (saveMode == SaveMode.Overwrite) {
            this.featureGroupApi.deleteContent(featureGroup);
            saveMode = SaveMode.Append;
        }
        SparkEngine.getInstance().writeOfflineDataframe(featureGroup, dataset, saveMode, writeOptions);
    }

    private void saveOnlineDataframe(FeatureGroup featureGroup, Dataset<Row> dataset, SaveMode saveMode, Map<String, String> providedWriteOptions) throws IOException, FeatureStoreException {
        StorageConnector storageConnector = this.storageConnectorApi.getOnlineStorageConnector(featureGroup.getFeatureStore());
        Map<String, String> writeOptions = SparkEngine.getInstance().getOnlineOptions(providedWriteOptions, featureGroup, storageConnector);
        SparkEngine.getInstance().writeOnlineDataframe(dataset, saveMode, writeOptions);
    }

    public void delete(FeatureGroup featureGroup) throws FeatureStoreException, IOException {
        this.featureGroupApi.delete(featureGroup);
    }

    public void addTag(FeatureGroup featureGroup, String name, String value) throws FeatureStoreException, IOException {
        this.tagsApi.add(featureGroup, name, value);
    }

    public Map<String, String> getTag(FeatureGroup featureGroup, String name) throws FeatureStoreException, IOException {
        return this.tagsApi.get(featureGroup, name);
    }

    public void deleteTag(FeatureGroup featureGroup, String name) throws FeatureStoreException, IOException {
        this.tagsApi.deleteTag(featureGroup, name);
    }

    public void updateStatisticsConfig(FeatureGroup featureGroup) throws FeatureStoreException, IOException {
        FeatureGroup apiFG = this.featureGroupApi.updateStatsConfig(featureGroup);
        featureGroup.setCorrelations(apiFG.getCorrelations());
        featureGroup.setHistograms(apiFG.getHistograms());
    }
}

