/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.engine;

import com.google.common.base.Strings;
import com.logicalclocks.hsfs.EntityEndpointType;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.TrainingDataset;
import com.logicalclocks.hsfs.engine.SparkEngine;
import com.logicalclocks.hsfs.engine.Utils;
import com.logicalclocks.hsfs.metadata.TagsApi;
import com.logicalclocks.hsfs.metadata.TrainingDatasetApi;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainingDatasetEngine {
    private TrainingDatasetApi trainingDatasetApi = new TrainingDatasetApi();
    private TagsApi tagsApi = new TagsApi(EntityEndpointType.TRAINING_DATASET);
    private Utils utils = new Utils();
    private static final Logger LOGGER = LoggerFactory.getLogger(TrainingDatasetEngine.class);

    public void save(TrainingDataset trainingDataset, Dataset<Row> dataset, Map<String, String> userWriteOptions) throws FeatureStoreException, IOException {
        trainingDataset.setFeatures(this.utils.parseSchema(dataset));
        TrainingDataset apiTD = this.trainingDatasetApi.createTrainingDataset(trainingDataset);
        if (trainingDataset.getVersion() == null) {
            LOGGER.info("VersionWarning: No version provided for creating training dataset `" + trainingDataset.getName() + "`, incremented version to `" + apiTD.getVersion() + "`.");
        }
        trainingDataset.setLocation(apiTD.getLocation());
        trainingDataset.setVersion(apiTD.getVersion());
        trainingDataset.setId(apiTD.getId());
        Map<String, String> writeOptions = SparkEngine.getInstance().getWriteOptions(userWriteOptions, trainingDataset.getDataFormat());
        SparkEngine.getInstance().write(trainingDataset, dataset, writeOptions, SaveMode.Overwrite);
    }

    public void insert(TrainingDataset trainingDataset, Dataset<Row> dataset, Map<String, String> providedOptions, SaveMode saveMode) throws FeatureStoreException {
        this.utils.schemaMatches(dataset, trainingDataset.getFeatures());
        Map<String, String> writeOptions = SparkEngine.getInstance().getWriteOptions(providedOptions, trainingDataset.getDataFormat());
        SparkEngine.getInstance().write(trainingDataset, dataset, writeOptions, saveMode);
    }

    public Dataset<Row> read(TrainingDataset trainingDataset, String split, Map<String, String> providedOptions) {
        if (trainingDataset.getStorageConnector() != null) {
            SparkEngine.getInstance().configureConnector(trainingDataset.getStorageConnector());
        }
        String path = "";
        path = Strings.isNullOrEmpty((String)split) ? new Path(trainingDataset.getLocation(), "**").toString() : new Path(trainingDataset.getLocation(), split).toString();
        Map<String, String> readOptions = SparkEngine.getInstance().getReadOptions(providedOptions, trainingDataset.getDataFormat());
        return SparkEngine.getInstance().read(trainingDataset.getDataFormat(), readOptions, path);
    }

    public void addTag(TrainingDataset trainingDataset, String name, String value) throws FeatureStoreException, IOException {
        this.tagsApi.add(trainingDataset, name, value);
    }

    public Map<String, String> getTag(TrainingDataset trainingDataset, String name) throws FeatureStoreException, IOException {
        return this.tagsApi.get(trainingDataset, name);
    }

    public void deleteTag(TrainingDataset trainingDataset, String name) throws FeatureStoreException, IOException {
        this.tagsApi.deleteTag(trainingDataset, name);
    }
}

