/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.engine;

import com.logicalclocks.hsfs.Feature;
import com.logicalclocks.hsfs.FeatureGroup;
import com.logicalclocks.hsfs.FeatureStoreException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.collection.Iterator;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class Utils {
    public List<Feature> parseSchema(Dataset<Row> dataset) throws FeatureStoreException {
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (StructField structField : dataset.schema().fields()) {
            features.add(new Feature(structField.name(), structField.dataType().catalogString(), structField.dataType().catalogString(), false, false));
        }
        return features;
    }

    public void schemaMatches(Dataset<Row> dataset, List<Feature> features) throws FeatureStoreException {
        StructType tdStructType = new StructType((StructField[])features.stream().map(f -> new StructField(f.getName(), new CatalystSqlParser(null).parseDataType(f.getType()), true, Metadata.empty())).toArray(StructField[]::new));
        if (!dataset.schema().equals((Object)tdStructType)) {
            throw new FeatureStoreException("The Dataframe schema: " + dataset.schema() + " does not match the training dataset schema: " + tdStructType);
        }
    }

    public String getTableName(FeatureGroup offlineFeatureGroup) {
        return offlineFeatureGroup.getFeatureStore().getName() + "." + offlineFeatureGroup.getName() + "_" + offlineFeatureGroup.getVersion();
    }

    public Seq<String> getPartitionColumns(FeatureGroup offlineFeatureGroup) {
        List partitionCols = offlineFeatureGroup.getFeatures().stream().filter(Feature::getPartition).map(Feature::getName).collect(Collectors.toList());
        return ((Iterator)JavaConverters.asScalaIteratorConverter(partitionCols.iterator()).asScala()).toSeq();
    }

    public String getFgName(FeatureGroup featureGroup) {
        return featureGroup.getName() + "_" + featureGroup.getVersion();
    }
}

