/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.metadata;

import com.damnhandy.uri.template.UriTemplate;
import com.logicalclocks.hsfs.FeatureGroup;
import com.logicalclocks.hsfs.FeatureStore;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.metadata.HopsworksClient;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureGroupApi {
    public static final String FEATURE_GROUP_ROOT_PATH = "/featuregroups";
    public static final String FEATURE_GROUP_PATH = "/featuregroups{/fgName}{?version}";
    public static final String FEATURE_GROUP_ID_PATH = "/featuregroups{/fgId}{?updateStatsSettings}";
    public static final String FEATURE_GROUP_CLEAR_PATH = "/featuregroups{/fgId}{?updateStatsSettings}/clear";
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureGroupApi.class);

    public FeatureGroup get(FeatureStore featureStore, String fgName, Integer fgVersion) throws IOException, FeatureStoreException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/featuregroups{/fgName}{?version}";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)featureStore.getProjectId()).set("fsId", (Object)featureStore.getId()).set("fgName", (Object)fgName).set("version", (Object)fgVersion).expand();
        LOGGER.info("Sending metadata request: " + uri);
        FeatureGroup[] offlineFeatureGroups = hopsworksClient.handleRequest((HttpRequest)new HttpGet(uri), FeatureGroup[].class);
        FeatureGroup resultFg = offlineFeatureGroups[0];
        resultFg.setFeatureStore(featureStore);
        return resultFg;
    }

    public FeatureGroup save(FeatureGroup featureGroup) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/featuregroups";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)featureGroup.getFeatureStore().getProjectId()).set("fsId", (Object)featureGroup.getFeatureStore().getId()).expand();
        String featureGroupJson = hopsworksClient.getObjectMapper().writeValueAsString((Object)featureGroup);
        HttpPost postRequest = new HttpPost(uri);
        postRequest.setHeader("Content-Type", "application/json");
        postRequest.setEntity((HttpEntity)new StringEntity(featureGroupJson));
        LOGGER.info("Sending metadata request: " + uri);
        LOGGER.info(featureGroupJson);
        return hopsworksClient.handleRequest((HttpRequest)postRequest, FeatureGroup.class);
    }

    public void delete(FeatureGroup featureGroup) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/featuregroups{/fgId}{?updateStatsSettings}";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)featureGroup.getFeatureStore().getProjectId()).set("fsId", (Object)featureGroup.getFeatureStore().getId()).set("fgId", (Object)featureGroup.getId()).expand();
        HttpDelete deleteRequest = new HttpDelete(uri);
        LOGGER.info("Sending metadata request: " + uri);
        hopsworksClient.handleRequest((HttpRequest)deleteRequest);
    }

    public void deleteContent(FeatureGroup featureGroup) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/featuregroups{/fgId}{?updateStatsSettings}/clear";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)featureGroup.getFeatureStore().getProjectId()).set("fsId", (Object)featureGroup.getFeatureStore().getId()).set("fgId", (Object)featureGroup.getId()).expand();
        LOGGER.info("Sending metadata request: " + uri);
        HttpPost postRequest = new HttpPost(uri);
        hopsworksClient.handleRequest((HttpRequest)postRequest);
    }

    public FeatureGroup updateStatsConfig(FeatureGroup featureGroup) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/featuregroups{/fgId}{?updateStatsSettings}";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)featureGroup.getFeatureStore().getProjectId()).set("fsId", (Object)featureGroup.getFeatureStore().getId()).set("fgId", (Object)featureGroup.getId()).set("updateStatsSettings", (Object)true).expand();
        String featureGroupJson = hopsworksClient.getObjectMapper().writeValueAsString((Object)featureGroup);
        HttpPut putRequest = new HttpPut(uri);
        putRequest.setHeader("Content-Type", "application/json");
        putRequest.setEntity((HttpEntity)new StringEntity(featureGroupJson));
        LOGGER.info("Sending metadata request: " + uri);
        LOGGER.info(featureGroupJson);
        return hopsworksClient.handleRequest((HttpRequest)putRequest, FeatureGroup.class);
    }
}

