/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.metadata;

import com.logicalclocks.hsfs.Feature;
import com.logicalclocks.hsfs.FeatureGroup;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.JoinType;
import com.logicalclocks.hsfs.Storage;
import com.logicalclocks.hsfs.StorageConnector;
import com.logicalclocks.hsfs.engine.SparkEngine;
import com.logicalclocks.hsfs.metadata.Join;
import com.logicalclocks.hsfs.metadata.QueryConstructorApi;
import com.logicalclocks.hsfs.metadata.StorageConnectorApi;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Query {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureGroup.class);
    private FeatureGroup leftFeatureGroup;
    private List<Feature> leftFeatures;
    private List<Join> joins = new ArrayList<Join>();
    private QueryConstructorApi queryConstructorApi;
    private StorageConnectorApi storageConnectorApi;

    public Query(FeatureGroup leftFeatureGroup, List<Feature> leftFeatures) {
        this.leftFeatureGroup = leftFeatureGroup;
        this.leftFeatures = leftFeatures;
        this.queryConstructorApi = new QueryConstructorApi();
        this.storageConnectorApi = new StorageConnectorApi();
    }

    public Query join(Query subquery) {
        return this.join(subquery, JoinType.INNER);
    }

    public Query join(Query subquery, List<String> on) {
        return this.joinFeatures(subquery, on.stream().map(Feature::new).collect(Collectors.toList()), JoinType.INNER);
    }

    public Query join(Query subquery, List<String> leftOn, List<String> rightOn) {
        return this.joinFeatures(subquery, leftOn.stream().map(Feature::new).collect(Collectors.toList()), rightOn.stream().map(Feature::new).collect(Collectors.toList()), JoinType.INNER);
    }

    public Query join(Query subquery, JoinType joinType) {
        this.joins.add(new Join(subquery, joinType));
        return this;
    }

    public Query join(Query subquery, List<String> on, JoinType joinType) {
        this.joins.add(new Join(subquery, on.stream().map(Feature::new).collect(Collectors.toList()), joinType));
        return this;
    }

    public Query join(Query subquery, List<String> leftOn, List<String> rightOn, JoinType joinType) {
        this.joins.add(new Join(subquery, leftOn.stream().map(Feature::new).collect(Collectors.toList()), rightOn.stream().map(Feature::new).collect(Collectors.toList()), joinType));
        return this;
    }

    public Query joinFeatures(Query subquery, List<Feature> on) {
        return this.joinFeatures(subquery, on, JoinType.INNER);
    }

    public Query joinFeatures(Query subquery, List<Feature> leftOn, List<Feature> rightOn) {
        return this.joinFeatures(subquery, leftOn, rightOn, JoinType.INNER);
    }

    public Query joinFeatures(Query subquery, List<Feature> on, JoinType joinType) {
        this.joins.add(new Join(subquery, on, joinType));
        return this;
    }

    public Query joinFeatures(Query subquery, List<Feature> leftOn, List<Feature> rightOn, JoinType joinType) {
        this.joins.add(new Join(subquery, leftOn, rightOn, joinType));
        return this;
    }

    public Dataset<Row> read() throws FeatureStoreException, IOException {
        return this.read(Storage.OFFLINE);
    }

    public Dataset<Row> read(Storage storage) throws FeatureStoreException, IOException {
        if (storage == null) {
            throw new FeatureStoreException("Storage not supported");
        }
        String sqlQuery = this.queryConstructorApi.constructQuery(this.leftFeatureGroup.getFeatureStore(), this).getStorageQuery(storage);
        LOGGER.info("Executing query: " + sqlQuery);
        switch (storage) {
            case OFFLINE: {
                return SparkEngine.getInstance().sql(sqlQuery);
            }
            case ONLINE: {
                StorageConnector onlineConnector = this.storageConnectorApi.getOnlineStorageConnector(this.leftFeatureGroup.getFeatureStore());
                return SparkEngine.getInstance().jdbc(onlineConnector, sqlQuery);
            }
        }
        throw new FeatureStoreException("Storage not supported");
    }

    public void show(int numRows) throws FeatureStoreException, IOException {
        this.show(Storage.OFFLINE, numRows);
    }

    public void show(Storage storage, int numRows) throws FeatureStoreException, IOException {
        this.read(storage).show(numRows);
    }

    public String toString() {
        return this.toString(Storage.OFFLINE);
    }

    public String toString(Storage storage) {
        try {
            return this.queryConstructorApi.constructQuery(this.leftFeatureGroup.getFeatureStore(), this).getStorageQuery(storage);
        }
        catch (FeatureStoreException | IOException e) {
            return e.getMessage();
        }
    }

    public FeatureGroup getLeftFeatureGroup() {
        return this.leftFeatureGroup;
    }

    public void setLeftFeatureGroup(FeatureGroup leftFeatureGroup) {
        this.leftFeatureGroup = leftFeatureGroup;
    }

    public List<Feature> getLeftFeatures() {
        return this.leftFeatures;
    }

    public void setLeftFeatures(List<Feature> leftFeatures) {
        this.leftFeatures = leftFeatures;
    }

    public List<Join> getJoins() {
        return this.joins;
    }

    public void setJoins(List<Join> joins) {
        this.joins = joins;
    }
}

