/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.logicalclocks.hsfs.FeatureGroup;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.StorageConnector;
import com.logicalclocks.hsfs.StorageConnectorType;
import com.logicalclocks.hsfs.TrainingDataset;
import com.logicalclocks.hsfs.engine.SparkEngine;
import com.logicalclocks.hsfs.metadata.FeatureGroupApi;
import com.logicalclocks.hsfs.metadata.StorageConnectorApi;
import com.logicalclocks.hsfs.metadata.TrainingDatasetApi;
import java.io.IOException;
import lombok.NonNull;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureStore {
    @JsonProperty(value="featurestoreId")
    private Integer id;
    @JsonProperty(value="featurestoreName")
    private String name;
    private Integer projectId;
    private FeatureGroupApi featureGroupApi = new FeatureGroupApi();
    private TrainingDatasetApi trainingDatasetApi = new TrainingDatasetApi();
    private StorageConnectorApi storageConnectorApi = new StorageConnectorApi();
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureStore.class);
    private static final Integer DEFAULT_VERSION = 1;

    public FeatureGroup getFeatureGroup(@NonNull String name, @NonNull Integer version) throws FeatureStoreException, IOException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        return this.featureGroupApi.get(this, name, version);
    }

    public FeatureGroup getFeatureGroup(String name) throws FeatureStoreException, IOException {
        LOGGER.info("VersionWarning: No version provided for getting feature group `" + name + "`, defaulting to `" + DEFAULT_VERSION + "`.");
        return this.getFeatureGroup(name, DEFAULT_VERSION);
    }

    public Dataset<Row> sql(String query) {
        return SparkEngine.getInstance().sql(query);
    }

    public StorageConnector getStorageConnector(String name, StorageConnectorType type) throws FeatureStoreException, IOException {
        return this.storageConnectorApi.getByNameAndType(this, name, type);
    }

    public StorageConnector getOnlineStorageConnector() throws FeatureStoreException, IOException {
        return this.storageConnectorApi.getOnlineStorageConnector(this);
    }

    public FeatureGroup.FeatureGroupBuilder createFeatureGroup() {
        return FeatureGroup.builder().featureStore(this);
    }

    public TrainingDataset.TrainingDatasetBuilder createTrainingDataset() {
        return TrainingDataset.builder().featureStore(this);
    }

    public TrainingDataset getTrainingDataset(@NonNull String name, @NonNull Integer version) throws FeatureStoreException, IOException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        return this.trainingDatasetApi.get(this, name, version);
    }

    public TrainingDataset getTrainingDataset(String name) throws FeatureStoreException, IOException {
        LOGGER.info("VersionWarning: No version provided for getting training dataset `" + name + "`, defaulting to `" + DEFAULT_VERSION + "`.");
        return this.getTrainingDataset(name, DEFAULT_VERSION);
    }

    public String toString() {
        return "FeatureStore{id=" + this.id + ", name='" + this.name + '\'' + ", projectId=" + this.projectId + ", featureGroupApi=" + this.featureGroupApi + '}';
    }

    public Integer getId() {
        return this.id;
    }

    @JsonProperty(value="featurestoreId")
    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    @JsonProperty(value="featurestoreName")
    public void setName(String name) {
        this.name = name;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }
}

