/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.engine;

import com.logicalclocks.hsfs.Feature;
import com.logicalclocks.hsfs.FeatureGroup;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.StorageConnector;
import com.logicalclocks.hsfs.StorageConnectorType;
import com.logicalclocks.hsfs.TrainingDatasetFeature;
import com.logicalclocks.hsfs.metadata.StorageConnectorApi;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.collection.Iterator;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class Utils {
    StorageConnectorApi storageConnectorApi = new StorageConnectorApi();

    public List<Feature> parseFeatureGroupSchema(Dataset<Row> dataset) throws FeatureStoreException {
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (StructField structField : dataset.schema().fields()) {
            Feature f = new Feature(structField.name(), structField.dataType().catalogString(), false, false);
            if (structField.metadata().contains("description")) {
                f.setDescription(structField.metadata().getString("description"));
            }
            features.add(f);
        }
        return features;
    }

    public List<TrainingDatasetFeature> parseTrainingDatasetSchema(Dataset<Row> dataset) throws FeatureStoreException {
        ArrayList<TrainingDatasetFeature> features = new ArrayList<TrainingDatasetFeature>();
        int index = 0;
        for (StructField structField : dataset.schema().fields()) {
            features.add(new TrainingDatasetFeature(structField.name(), structField.dataType().catalogString(), index++));
        }
        return features;
    }

    public void trainingDatasetSchemaMatch(Dataset<Row> dataset, List<TrainingDatasetFeature> features) throws FeatureStoreException {
        StructType tdStructType = new StructType((StructField[])features.stream().sorted(Comparator.comparingInt(TrainingDatasetFeature::getIndex)).map(f -> new StructField(f.getName(), new CatalystSqlParser(null).parseDataType(f.getType()), true, Metadata.empty())).toArray(StructField[]::new));
        if (!dataset.schema().equals((Object)tdStructType)) {
            throw new FeatureStoreException("The Dataframe schema: " + dataset.schema() + " does not match the training dataset schema: " + tdStructType);
        }
    }

    public String getTableName(FeatureGroup offlineFeatureGroup) {
        return offlineFeatureGroup.getFeatureStore().getName() + "." + offlineFeatureGroup.getName() + "_" + offlineFeatureGroup.getVersion();
    }

    public Seq<String> getPartitionColumns(FeatureGroup offlineFeatureGroup) {
        List partitionCols = offlineFeatureGroup.getFeatures().stream().filter(Feature::getPartition).map(Feature::getName).collect(Collectors.toList());
        return ((Iterator)JavaConverters.asScalaIteratorConverter(partitionCols.iterator()).asScala()).toSeq();
    }

    public Seq<String> getPrimaryColumns(FeatureGroup offlineFeatureGroup) {
        List primaryCols = offlineFeatureGroup.getFeatures().stream().filter(Feature::getPrimary).map(Feature::getName).collect(Collectors.toList());
        return ((Iterator)JavaConverters.asScalaIteratorConverter(primaryCols.iterator()).asScala()).toSeq();
    }

    public String getFgName(FeatureGroup featureGroup) {
        return featureGroup.getName() + "_" + featureGroup.getVersion();
    }

    public String getHiveMetastoreConnector(FeatureGroup featureGroup) throws IOException, FeatureStoreException {
        StorageConnector storageConnector = this.storageConnectorApi.getByNameAndType(featureGroup.getFeatureStore(), featureGroup.getFeatureStore().getName(), StorageConnectorType.JDBC);
        String connStr = storageConnector.getConnectionString();
        String pw = FileUtils.readFileToString((File)new File("material_passwd"));
        return connStr + "sslTrustStore=t_certificate;trustStorePassword=" + pw + ";sslKeyStore=k_certificate;keyStorePassword=" + pw;
    }
}

