/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.metadata;

import com.damnhandy.uri.template.UriTemplate;
import com.logicalclocks.hsfs.FeatureStore;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.FsQuery;
import com.logicalclocks.hsfs.metadata.HopsworksClient;
import com.logicalclocks.hsfs.metadata.Query;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryConstructorApi {
    public static final String QUERY_CONSTRUCTOR_PATH = "/query";
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryConstructorApi.class);

    public FsQuery constructQuery(FeatureStore featureStore, Query query) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores/query";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)featureStore.getProjectId()).expand();
        String queryJson = hopsworksClient.getObjectMapper().writeValueAsString((Object)query);
        HttpPut putRequest = new HttpPut(uri);
        putRequest.setHeader("Content-Type", "application/json");
        putRequest.setEntity((HttpEntity)new StringEntity(queryJson));
        LOGGER.info("Sending metadata request: " + uri);
        LOGGER.info("Sending query: " + queryJson);
        FsQuery fsQuery = hopsworksClient.handleRequest((HttpRequest)putRequest, FsQuery.class);
        fsQuery.removeNewLines();
        return fsQuery;
    }
}

