/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.metadata;

import com.damnhandy.uri.template.UriTemplate;
import com.logicalclocks.hsfs.EntityEndpointType;
import com.logicalclocks.hsfs.FeatureGroup;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.TrainingDataset;
import com.logicalclocks.hsfs.metadata.HopsworksClient;
import com.logicalclocks.hsfs.metadata.Statistics;
import java.io.IOException;
import lombok.NonNull;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsApi {
    public static final String ENTITY_ROOT_PATH = "{/entityType}";
    public static final String ENTITY_ID_PATH = "{/entityType}{/entityId}";
    public static final String STATISTICS_PATH = "{/entityType}{/entityId}/statistics{?filter_by,fields,sort_by,offset,limit}";
    private static final Logger LOGGER = LoggerFactory.getLogger(StatisticsApi.class);
    private EntityEndpointType entityType;

    public StatisticsApi(@NonNull EntityEndpointType entityType) {
        if (entityType == null) {
            throw new NullPointerException("entityType is marked non-null but is null");
        }
        this.entityType = entityType;
    }

    public Statistics post(FeatureGroup featureGroup, Statistics statistics) throws FeatureStoreException, IOException {
        return this.post(featureGroup.getFeatureStore().getProjectId(), featureGroup.getFeatureStore().getId(), featureGroup.getId(), statistics);
    }

    public Statistics post(TrainingDataset trainingDataset, Statistics statistics) throws FeatureStoreException, IOException {
        return this.post(trainingDataset.getFeatureStore().getProjectId(), trainingDataset.getFeatureStore().getId(), trainingDataset.getId(), statistics);
    }

    private Statistics post(Integer projectId, Integer featurestoreId, Integer entityId, Statistics statistics) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}{/entityType}{/entityId}/statistics{?filter_by,fields,sort_by,offset,limit}";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)projectId).set("fsId", (Object)featurestoreId).set("entityType", (Object)this.entityType.getValue()).set("entityId", (Object)entityId).expand();
        String statisticsJson = hopsworksClient.getObjectMapper().writeValueAsString((Object)statistics);
        HttpPost postRequest = new HttpPost(uri);
        postRequest.setHeader("Content-Type", "application/json");
        postRequest.setEntity((HttpEntity)new StringEntity(statisticsJson));
        LOGGER.info("Sending metadata request: " + uri);
        LOGGER.info(statisticsJson);
        return hopsworksClient.handleRequest((HttpRequest)postRequest, Statistics.class);
    }

    public Statistics get(FeatureGroup featureGroup, String commitTime) throws FeatureStoreException, IOException {
        return this.get(featureGroup.getFeatureStore().getProjectId(), featureGroup.getFeatureStore().getId(), featureGroup.getId(), commitTime);
    }

    public Statistics get(TrainingDataset trainingDataset, String commitTime) throws FeatureStoreException, IOException {
        return this.get(trainingDataset.getFeatureStore().getProjectId(), trainingDataset.getFeatureStore().getId(), trainingDataset.getId(), commitTime);
    }

    private Statistics get(Integer projectId, Integer featurestoreId, Integer entityId, String commitTime) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}{/entityType}{/entityId}/statistics{?filter_by,fields,sort_by,offset,limit}";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)projectId).set("fsId", (Object)featurestoreId).set("entityType", (Object)this.entityType.getValue()).set("entityId", (Object)entityId).set("filter_by", (Object)("commit_time_eq:" + commitTime)).set("fields", (Object)"content").expand();
        LOGGER.info("Sending metadata request: " + uri);
        HttpGet getRequest = new HttpGet(uri);
        Statistics statistics = hopsworksClient.handleRequest((HttpRequest)getRequest, Statistics.class);
        if (statistics.getItems().size() == 1) {
            return (Statistics)statistics.getItems().get(0);
        }
        return null;
    }

    public Statistics getLast(FeatureGroup featureGroup) throws FeatureStoreException, IOException {
        return this.getLast(featureGroup.getFeatureStore().getProjectId(), featureGroup.getFeatureStore().getId(), featureGroup.getId());
    }

    public Statistics getLast(TrainingDataset trainingDataset) throws FeatureStoreException, IOException {
        return this.getLast(trainingDataset.getFeatureStore().getProjectId(), trainingDataset.getFeatureStore().getId(), trainingDataset.getId());
    }

    private Statistics getLast(Integer projectId, Integer featurestoreId, Integer entityId) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}{/entityType}{/entityId}/statistics{?filter_by,fields,sort_by,offset,limit}";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)projectId).set("fsId", (Object)featurestoreId).set("entityType", (Object)this.entityType.getValue()).set("entityId", (Object)entityId).set("sort_by", (Object)"commit_time:desc").set("offset", (Object)0).set("limit", (Object)1).set("fields", (Object)"content").expand();
        LOGGER.info("Sending metadata request: " + uri);
        HttpGet getRequest = new HttpGet(uri);
        Statistics statistics = hopsworksClient.handleRequest((HttpRequest)getRequest, Statistics.class);
        if (statistics.getItems().size() == 1) {
            return (Statistics)statistics.getItems().get(0);
        }
        return null;
    }
}

