/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.metadata;

import com.damnhandy.uri.template.UriTemplate;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.Project;
import com.logicalclocks.hsfs.metadata.Credentials;
import com.logicalclocks.hsfs.metadata.HopsworksClient;
import java.io.IOException;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpGet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectApi.class);
    private static final String PROJECT_INFO_PATH = "/project/getProjectInfo{/projectName}";
    private static final String CREDENTIALS_PATH = "/project{/projectId}/credentials";

    public Project get(String name) throws IOException, FeatureStoreException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String uri = UriTemplate.fromTemplate((String)"/hopsworks-api/api/project/getProjectInfo{/projectName}").set("projectName", (Object)name).expand();
        LOGGER.info("Sending metadata request: " + uri);
        return hopsworksClient.handleRequest((HttpRequest)new HttpGet(uri), Project.class);
    }

    public Credentials downloadCredentials(Project project) throws IOException, FeatureStoreException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String uri = UriTemplate.fromTemplate((String)"/hopsworks-api/api/project{/projectId}/credentials").set("projectId", (Object)project.getProjectId()).expand();
        LOGGER.info("Sending metadata request: " + uri);
        return hopsworksClient.handleRequest((HttpRequest)new HttpGet(uri), Credentials.class);
    }
}

