/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.metadata;

import com.damnhandy.uri.template.UriTemplate;
import com.logicalclocks.hsfs.FeatureStore;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.FsQuery;
import com.logicalclocks.hsfs.TrainingDataset;
import com.logicalclocks.hsfs.metadata.HopsworksClient;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainingDatasetApi {
    private static final String TRAINING_DATASETS_PATH = "/trainingdatasets";
    private static final String TRAINING_DATASET_PATH = "/trainingdatasets{/tdName}{?version}";
    private static final String TRAINING_QUERY_PATH = "/trainingdatasets{/tdId}/query{?withLabel}";
    private static final Logger LOGGER = LoggerFactory.getLogger(TrainingDatasetApi.class);

    public TrainingDataset get(FeatureStore featureStore, String tdName, Integer tdVersion) throws IOException, FeatureStoreException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/trainingdatasets{/tdName}{?version}";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)featureStore.getProjectId()).set("fsId", (Object)featureStore.getId()).set("tdName", (Object)tdName).set("version", (Object)tdVersion).expand();
        LOGGER.info("Sending metadata request: " + uri);
        TrainingDataset[] trainingDatasets = hopsworksClient.handleRequest((HttpRequest)new HttpGet(uri), TrainingDataset[].class);
        TrainingDataset resultTd = trainingDatasets[0];
        resultTd.setFeatureStore(featureStore);
        return resultTd;
    }

    public TrainingDataset createTrainingDataset(TrainingDataset trainingDataset) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/trainingdatasets";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)trainingDataset.getFeatureStore().getProjectId()).set("fsId", (Object)trainingDataset.getFeatureStore().getId()).expand();
        String trainingDatasetJson = hopsworksClient.getObjectMapper().writeValueAsString((Object)trainingDataset);
        HttpPost postRequest = new HttpPost(uri);
        postRequest.setHeader("Content-Type", "application/json");
        postRequest.setEntity((HttpEntity)new StringEntity(trainingDatasetJson));
        LOGGER.info("Sending metadata request: " + uri);
        LOGGER.info(trainingDatasetJson);
        return hopsworksClient.handleRequest((HttpRequest)postRequest, TrainingDataset.class);
    }

    public FsQuery getQuery(TrainingDataset trainingDataset, boolean withLabel) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/trainingdatasets{/tdId}/query{?withLabel}";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)trainingDataset.getFeatureStore().getProjectId()).set("fsId", (Object)trainingDataset.getFeatureStore().getId()).set("tdId", (Object)trainingDataset.getId()).set("withLabel", (Object)withLabel).expand();
        HttpGet getRequest = new HttpGet(uri);
        LOGGER.info("Sending metadata request: " + uri);
        return hopsworksClient.handleRequest((HttpRequest)getRequest, FsQuery.class);
    }
}

