/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.logicalclocks.hsfs.Feature;
import com.logicalclocks.hsfs.FeatureStore;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.HudiOperationType;
import com.logicalclocks.hsfs.StatisticsConfig;
import com.logicalclocks.hsfs.Storage;
import com.logicalclocks.hsfs.TimeTravelFormat;
import com.logicalclocks.hsfs.engine.FeatureGroupEngine;
import com.logicalclocks.hsfs.metadata.FeatureGroupBase;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FeatureGroup
extends FeatureGroupBase {
    private Boolean onlineEnabled;
    private String type = "cachedFeaturegroupDTO";
    private TimeTravelFormat timeTravelFormat = TimeTravelFormat.HUDI;
    protected String location;
    @JsonIgnore
    private List<String> primaryKeys;
    @JsonIgnore
    private List<String> partitionKeys;
    @JsonIgnore
    private String hudiPrecombineKey;
    private FeatureGroupEngine featureGroupEngine = new FeatureGroupEngine();
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureGroup.class);

    public FeatureGroup(FeatureStore featureStore, @NonNull String name, Integer version, String description, List<String> primaryKeys, List<String> partitionKeys, String hudiPrecombineKey, boolean onlineEnabled, TimeTravelFormat timeTravelFormat, List<Feature> features, StatisticsConfig statisticsConfig) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.featureStore = featureStore;
        this.name = name;
        this.version = version;
        this.description = description;
        this.primaryKeys = primaryKeys;
        this.partitionKeys = partitionKeys;
        this.hudiPrecombineKey = timeTravelFormat == TimeTravelFormat.HUDI ? hudiPrecombineKey : null;
        this.onlineEnabled = onlineEnabled;
        this.timeTravelFormat = timeTravelFormat != null ? timeTravelFormat : TimeTravelFormat.HUDI;
        this.features = features;
        this.statisticsConfig = statisticsConfig != null ? statisticsConfig : new StatisticsConfig();
    }

    public FeatureGroup() {
    }

    @Override
    public Dataset<Row> read() throws FeatureStoreException, IOException {
        return this.read(false, null);
    }

    public Dataset<Row> read(boolean online) throws FeatureStoreException, IOException {
        return this.selectAll().read(online);
    }

    public Dataset<Row> read(Map<String, String> readOptions) throws FeatureStoreException, IOException {
        return this.read(false, null);
    }

    public Dataset<Row> read(boolean online, Map<String, String> readOptions) throws FeatureStoreException, IOException {
        return this.selectAll().read(online, readOptions);
    }

    public Dataset<Row> read(String wallclockTime) throws FeatureStoreException, IOException {
        return this.selectAll().asOf(wallclockTime).read(false, null);
    }

    public Dataset<Row> read(String wallclockTime, Map<String, String> readOptions) throws FeatureStoreException, IOException {
        return this.selectAll().asOf(wallclockTime).read(false, readOptions);
    }

    public Dataset<Row> readChanges(String wallclockStartTime, String wallclockEndTime) throws FeatureStoreException, IOException {
        return this.selectAll().pullChanges(wallclockStartTime, wallclockEndTime).read(false, null);
    }

    public Dataset<Row> readChanges(String wallclockStartTime, String wallclockEndTime, Map<String, String> readOptions) throws FeatureStoreException, IOException {
        return this.selectAll().pullChanges(wallclockStartTime, wallclockEndTime).read(false, readOptions);
    }

    public void show(int numRows) throws FeatureStoreException, IOException {
        this.show(numRows, false);
    }

    public void show(int numRows, boolean online) throws FeatureStoreException, IOException {
        this.read(online).show(numRows);
    }

    public void save(Dataset<Row> featureData) throws FeatureStoreException, IOException {
        this.save(featureData, null);
    }

    public void save(Dataset<Row> featureData, Map<String, String> writeOptions) throws FeatureStoreException, IOException {
        this.featureGroupEngine.saveFeatureGroup(this, featureData, this.primaryKeys, this.partitionKeys, this.hudiPrecombineKey, writeOptions);
        if (this.statisticsConfig.getEnabled().booleanValue()) {
            this.statisticsEngine.computeStatistics(this, featureData);
        }
    }

    public void insert(Dataset<Row> featureData) throws IOException, FeatureStoreException {
        this.insert(featureData, null, false);
    }

    public void insert(Dataset<Row> featureData, Map<String, String> writeOptions) throws FeatureStoreException, IOException {
        this.insert(featureData, null, false, null, writeOptions);
    }

    public void insert(Dataset<Row> featureData, Storage storage) throws IOException, FeatureStoreException {
        this.insert(featureData, storage, false, null, null);
    }

    public void insert(Dataset<Row> featureData, boolean overwrite) throws IOException, FeatureStoreException {
        this.insert(featureData, null, overwrite);
    }

    public void insert(Dataset<Row> featureData, Storage storage, boolean overwrite) throws IOException, FeatureStoreException {
        this.insert(featureData, storage, overwrite, null, null);
    }

    public void insert(Dataset<Row> featureData, boolean overwrite, Map<String, String> writeOptions) throws FeatureStoreException, IOException {
        this.insert(featureData, null, overwrite, null, writeOptions);
    }

    public void insert(Dataset<Row> featureData, HudiOperationType operation) throws FeatureStoreException, IOException {
        this.insert(featureData, null, false, operation, null);
    }

    public void insert(Dataset<Row> featureData, Storage storage, boolean overwrite, HudiOperationType operation, Map<String, String> writeOptions) throws FeatureStoreException, IOException {
        if (operation != null && this.timeTravelFormat == TimeTravelFormat.NONE) {
            throw new IllegalArgumentException("operation argument is valid only for time travel enable feature groups");
        }
        if (operation == null && this.timeTravelFormat == TimeTravelFormat.HUDI) {
            operation = overwrite ? HudiOperationType.BULK_INSERT : HudiOperationType.UPSERT;
        }
        this.featureGroupEngine.saveDataframe(this, featureData, storage, overwrite ? SaveMode.Overwrite : SaveMode.Append, operation, writeOptions);
        this.computeStatistics();
    }

    public void commitDeleteRecord(Dataset<Row> featureData) throws FeatureStoreException, IOException {
        if (this.timeTravelFormat == TimeTravelFormat.NONE) {
            throw new FeatureStoreException("delete function is only valid for time travel enabled feature group");
        }
        this.featureGroupEngine.commitDelete(this, featureData, null);
    }

    public void commitDeleteRecord(Dataset<Row> featureData, Map<String, String> writeOptions) throws FeatureStoreException, IOException {
        if (this.timeTravelFormat == TimeTravelFormat.NONE) {
            throw new FeatureStoreException("delete function is only valid for time travel enabled feature group");
        }
        this.featureGroupEngine.commitDelete(this, featureData, writeOptions);
    }

    public Map<String, Map<String, String>> commitDetails() throws IOException, FeatureStoreException {
        return this.featureGroupEngine.commitDetails(this, null);
    }

    public Map<String, Map<String, String>> commitDetails(Integer limit) throws IOException, FeatureStoreException {
        return this.featureGroupEngine.commitDetails(this, limit);
    }

    public static FeatureGroupBuilder builder() {
        return new FeatureGroupBuilder();
    }

    public FeatureGroup(Boolean onlineEnabled, String type, TimeTravelFormat timeTravelFormat, String location, List<String> primaryKeys, List<String> partitionKeys, String hudiPrecombineKey, FeatureGroupEngine featureGroupEngine) {
        this.onlineEnabled = onlineEnabled;
        this.type = type;
        this.timeTravelFormat = timeTravelFormat;
        this.location = location;
        this.primaryKeys = primaryKeys;
        this.partitionKeys = partitionKeys;
        this.hudiPrecombineKey = hudiPrecombineKey;
        this.featureGroupEngine = featureGroupEngine;
    }

    public Boolean getOnlineEnabled() {
        return this.onlineEnabled;
    }

    public void setOnlineEnabled(Boolean onlineEnabled) {
        this.onlineEnabled = onlineEnabled;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public TimeTravelFormat getTimeTravelFormat() {
        return this.timeTravelFormat;
    }

    public void setTimeTravelFormat(TimeTravelFormat timeTravelFormat) {
        this.timeTravelFormat = timeTravelFormat;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public static class FeatureGroupBuilder {
        private FeatureStore featureStore;
        private String name;
        private Integer version;
        private String description;
        private List<String> primaryKeys;
        private List<String> partitionKeys;
        private String hudiPrecombineKey;
        private boolean onlineEnabled;
        private TimeTravelFormat timeTravelFormat;
        private List<Feature> features;
        private StatisticsConfig statisticsConfig;

        FeatureGroupBuilder() {
        }

        public FeatureGroupBuilder featureStore(FeatureStore featureStore) {
            this.featureStore = featureStore;
            return this;
        }

        public FeatureGroupBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public FeatureGroupBuilder version(Integer version) {
            this.version = version;
            return this;
        }

        public FeatureGroupBuilder description(String description) {
            this.description = description;
            return this;
        }

        public FeatureGroupBuilder primaryKeys(List<String> primaryKeys) {
            this.primaryKeys = primaryKeys;
            return this;
        }

        public FeatureGroupBuilder partitionKeys(List<String> partitionKeys) {
            this.partitionKeys = partitionKeys;
            return this;
        }

        public FeatureGroupBuilder hudiPrecombineKey(String hudiPrecombineKey) {
            this.hudiPrecombineKey = hudiPrecombineKey;
            return this;
        }

        public FeatureGroupBuilder onlineEnabled(boolean onlineEnabled) {
            this.onlineEnabled = onlineEnabled;
            return this;
        }

        public FeatureGroupBuilder timeTravelFormat(TimeTravelFormat timeTravelFormat) {
            this.timeTravelFormat = timeTravelFormat;
            return this;
        }

        public FeatureGroupBuilder features(List<Feature> features) {
            this.features = features;
            return this;
        }

        public FeatureGroupBuilder statisticsConfig(StatisticsConfig statisticsConfig) {
            this.statisticsConfig = statisticsConfig;
            return this;
        }

        public FeatureGroup build() {
            return new FeatureGroup(this.featureStore, this.name, this.version, this.description, this.primaryKeys, this.partitionKeys, this.hudiPrecombineKey, this.onlineEnabled, this.timeTravelFormat, this.features, this.statisticsConfig);
        }

        public String toString() {
            return "FeatureGroup.FeatureGroupBuilder(featureStore=" + this.featureStore + ", name=" + this.name + ", version=" + this.version + ", description=" + this.description + ", primaryKeys=" + this.primaryKeys + ", partitionKeys=" + this.partitionKeys + ", hudiPrecombineKey=" + this.hudiPrecombineKey + ", onlineEnabled=" + this.onlineEnabled + ", timeTravelFormat=" + (Object)((Object)this.timeTravelFormat) + ", features=" + this.features + ", statisticsConfig=" + this.statisticsConfig + ")";
        }
    }
}

