/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.logicalclocks.hsfs.Feature;
import com.logicalclocks.hsfs.FeatureStore;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.OnDemandDataFormat;
import com.logicalclocks.hsfs.StatisticsConfig;
import com.logicalclocks.hsfs.StorageConnector;
import com.logicalclocks.hsfs.engine.OnDemandFeatureGroupEngine;
import com.logicalclocks.hsfs.metadata.FeatureGroupBase;
import com.logicalclocks.hsfs.metadata.OnDemandOptions;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

@JsonIgnoreProperties(ignoreUnknown=true)
public class OnDemandFeatureGroup
extends FeatureGroupBase {
    private StorageConnector storageConnector;
    private String query;
    private OnDemandDataFormat dataFormat;
    private String path;
    private List<OnDemandOptions> options;
    private String type = "onDemandFeaturegroupDTO";
    private OnDemandFeatureGroupEngine onDemandFeatureGroupEngine = new OnDemandFeatureGroupEngine();

    public OnDemandFeatureGroup(FeatureStore featureStore, @NonNull String name, Integer version, String query, OnDemandDataFormat dataFormat, String path, Map<String, String> options, @NonNull StorageConnector storageConnector, String description, List<Feature> features, StatisticsConfig statisticsConfig) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (storageConnector == null) {
            throw new NullPointerException("storageConnector is marked non-null but is null");
        }
        this.featureStore = featureStore;
        this.name = name;
        this.version = version;
        this.query = query;
        this.dataFormat = dataFormat;
        this.path = path;
        this.options = options != null ? options.entrySet().stream().map(e -> new OnDemandOptions((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList()) : null;
        this.description = description;
        this.storageConnector = storageConnector;
        this.features = features;
        this.statisticsConfig = statisticsConfig != null ? statisticsConfig : new StatisticsConfig();
    }

    public OnDemandFeatureGroup() {
    }

    public void save() throws FeatureStoreException, IOException {
        this.onDemandFeatureGroupEngine.saveFeatureGroup(this);
        if (this.statisticsConfig.getEnabled().booleanValue()) {
            this.statisticsEngine.computeStatistics(this, this.read());
        }
    }

    @Override
    public Dataset<Row> read() throws FeatureStoreException, IOException {
        return this.selectAll().read();
    }

    public void show(int numRows) throws FeatureStoreException, IOException {
        this.read().show(numRows);
    }

    public static OnDemandFeatureGroupBuilder builder() {
        return new OnDemandFeatureGroupBuilder();
    }

    public OnDemandFeatureGroup(StorageConnector storageConnector, String query, OnDemandDataFormat dataFormat, String path, List<OnDemandOptions> options, String type, OnDemandFeatureGroupEngine onDemandFeatureGroupEngine) {
        this.storageConnector = storageConnector;
        this.query = query;
        this.dataFormat = dataFormat;
        this.path = path;
        this.options = options;
        this.type = type;
        this.onDemandFeatureGroupEngine = onDemandFeatureGroupEngine;
    }

    public StorageConnector getStorageConnector() {
        return this.storageConnector;
    }

    public void setStorageConnector(StorageConnector storageConnector) {
        this.storageConnector = storageConnector;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public OnDemandDataFormat getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(OnDemandDataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public List<OnDemandOptions> getOptions() {
        return this.options;
    }

    public void setOptions(List<OnDemandOptions> options) {
        this.options = options;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public static class OnDemandFeatureGroupBuilder {
        private FeatureStore featureStore;
        private String name;
        private Integer version;
        private String query;
        private OnDemandDataFormat dataFormat;
        private String path;
        private Map<String, String> options;
        private StorageConnector storageConnector;
        private String description;
        private List<Feature> features;
        private StatisticsConfig statisticsConfig;

        OnDemandFeatureGroupBuilder() {
        }

        public OnDemandFeatureGroupBuilder featureStore(FeatureStore featureStore) {
            this.featureStore = featureStore;
            return this;
        }

        public OnDemandFeatureGroupBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public OnDemandFeatureGroupBuilder version(Integer version) {
            this.version = version;
            return this;
        }

        public OnDemandFeatureGroupBuilder query(String query) {
            this.query = query;
            return this;
        }

        public OnDemandFeatureGroupBuilder dataFormat(OnDemandDataFormat dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        public OnDemandFeatureGroupBuilder path(String path) {
            this.path = path;
            return this;
        }

        public OnDemandFeatureGroupBuilder options(Map<String, String> options) {
            this.options = options;
            return this;
        }

        public OnDemandFeatureGroupBuilder storageConnector(@NonNull StorageConnector storageConnector) {
            if (storageConnector == null) {
                throw new NullPointerException("storageConnector is marked non-null but is null");
            }
            this.storageConnector = storageConnector;
            return this;
        }

        public OnDemandFeatureGroupBuilder description(String description) {
            this.description = description;
            return this;
        }

        public OnDemandFeatureGroupBuilder features(List<Feature> features) {
            this.features = features;
            return this;
        }

        public OnDemandFeatureGroupBuilder statisticsConfig(StatisticsConfig statisticsConfig) {
            this.statisticsConfig = statisticsConfig;
            return this;
        }

        public OnDemandFeatureGroup build() {
            return new OnDemandFeatureGroup(this.featureStore, this.name, this.version, this.query, this.dataFormat, this.path, this.options, this.storageConnector, this.description, this.features, this.statisticsConfig);
        }

        public String toString() {
            return "OnDemandFeatureGroup.OnDemandFeatureGroupBuilder(featureStore=" + this.featureStore + ", name=" + this.name + ", version=" + this.version + ", query=" + this.query + ", dataFormat=" + (Object)((Object)this.dataFormat) + ", path=" + this.path + ", options=" + this.options + ", storageConnector=" + this.storageConnector + ", description=" + this.description + ", features=" + this.features + ", statisticsConfig=" + this.statisticsConfig + ")";
        }
    }
}

