/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.logicalclocks.hsfs.DataFormat;
import com.logicalclocks.hsfs.EntityEndpointType;
import com.logicalclocks.hsfs.FeatureStore;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.Split;
import com.logicalclocks.hsfs.StatisticsConfig;
import com.logicalclocks.hsfs.Storage;
import com.logicalclocks.hsfs.StorageConnector;
import com.logicalclocks.hsfs.TrainingDatasetFeature;
import com.logicalclocks.hsfs.TrainingDatasetType;
import com.logicalclocks.hsfs.constructor.Query;
import com.logicalclocks.hsfs.engine.StatisticsEngine;
import com.logicalclocks.hsfs.engine.TrainingDatasetEngine;
import com.logicalclocks.hsfs.engine.Utils;
import com.logicalclocks.hsfs.metadata.Statistics;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;

public class TrainingDataset {
    private Integer id;
    private String name;
    private Integer version;
    private String description;
    private DataFormat dataFormat;
    private TrainingDatasetType trainingDatasetType = TrainingDatasetType.HOPSFS_TRAINING_DATASET;
    private List<TrainingDatasetFeature> features;
    @JsonIgnore
    private FeatureStore featureStore;
    private StorageConnector storageConnector;
    private String location;
    private Long seed;
    private List<Split> splits;
    private StatisticsConfig statisticsConfig = new StatisticsConfig();
    @JsonProperty(value="queryDTO")
    private Query queryInt;
    @JsonIgnore
    private List<String> label;
    private TrainingDatasetEngine trainingDatasetEngine = new TrainingDatasetEngine();
    private StatisticsEngine statisticsEngine = new StatisticsEngine(EntityEndpointType.TRAINING_DATASET);
    private Utils utils = new Utils();

    public TrainingDataset(@NonNull String name, Integer version, String description, DataFormat dataFormat, StorageConnector storageConnector, String location, List<Split> splits, Long seed, FeatureStore featureStore, StatisticsConfig statisticsConfig, List<String> label) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
        this.version = version;
        this.description = description;
        this.dataFormat = dataFormat != null ? dataFormat : DataFormat.TFRECORDS;
        this.location = location;
        this.storageConnector = storageConnector;
        this.trainingDatasetType = this.utils.getTrainingDatasetType(storageConnector);
        this.splits = splits;
        this.seed = seed;
        this.featureStore = featureStore;
        this.statisticsConfig = statisticsConfig != null ? statisticsConfig : new StatisticsConfig();
        this.label = label;
    }

    public void save(Query query) throws FeatureStoreException, IOException {
        this.save(query, null);
    }

    public void save(Dataset<Row> dataset) throws FeatureStoreException, IOException {
        this.save(dataset, null);
    }

    public void save(Query query, Map<String, String> writeOptions) throws FeatureStoreException, IOException {
        this.queryInt = query;
        this.save(query.read(), writeOptions);
    }

    public void save(Dataset<Row> dataset, Map<String, String> writeOptions) throws FeatureStoreException, IOException {
        this.trainingDatasetEngine.save(this, dataset, writeOptions, this.label);
        if (this.statisticsConfig.getEnabled().booleanValue()) {
            this.statisticsEngine.computeStatistics(this, dataset);
        }
    }

    public void insert(Query query, boolean overwrite) throws FeatureStoreException, IOException {
        this.insert(query, overwrite, null);
    }

    public void insert(Dataset<Row> dataset, boolean overwrite) throws FeatureStoreException, IOException {
        this.insert(dataset, overwrite, null);
    }

    public void insert(Query query, boolean overwrite, Map<String, String> writeOptions) throws FeatureStoreException, IOException {
        this.trainingDatasetEngine.insert(this, query.read(), writeOptions, overwrite ? SaveMode.Overwrite : SaveMode.Append);
        this.computeStatistics();
    }

    public void insert(Dataset<Row> dataset, boolean overwrite, Map<String, String> writeOptions) throws FeatureStoreException, IOException {
        this.trainingDatasetEngine.insert(this, dataset, writeOptions, overwrite ? SaveMode.Overwrite : SaveMode.Append);
        this.computeStatistics();
    }

    public Dataset<Row> read() {
        return this.read("");
    }

    public Dataset<Row> read(Map<String, String> readOptions) {
        return this.trainingDatasetEngine.read(this, "", readOptions);
    }

    public Dataset<Row> read(String split) {
        return this.read(split, null);
    }

    public Dataset<Row> read(String split, Map<String, String> readOptions) {
        return this.trainingDatasetEngine.read(this, split, readOptions);
    }

    public void show(int numRows) {
        this.read("").show(numRows);
    }

    public Statistics computeStatistics() throws FeatureStoreException, IOException {
        if (this.statisticsConfig.getEnabled().booleanValue()) {
            return this.statisticsEngine.computeStatistics(this, this.read());
        }
        return null;
    }

    public void updateStatisticsConfig() throws FeatureStoreException, IOException {
        this.trainingDatasetEngine.updateStatisticsConfig(this);
    }

    @JsonIgnore
    public Statistics getStatistics() throws FeatureStoreException, IOException {
        return this.statisticsEngine.getLast(this);
    }

    @JsonIgnore
    public Statistics getStatistics(String commitTime) throws FeatureStoreException, IOException {
        return this.statisticsEngine.get(this, commitTime);
    }

    public void addTag(String name) throws FeatureStoreException, IOException {
        this.addTag(name, null);
    }

    public void addTag(String name, String value) throws FeatureStoreException, IOException {
        this.trainingDatasetEngine.addTag(this, name, value);
    }

    @JsonIgnore
    public Map<String, String> getTag() throws FeatureStoreException, IOException {
        return this.getTag(null);
    }

    @JsonIgnore
    public Map<String, String> getTag(String name) throws FeatureStoreException, IOException {
        return this.trainingDatasetEngine.getTag(this, name);
    }

    public void deleteTag(String name) throws FeatureStoreException, IOException {
        this.trainingDatasetEngine.deleteTag(this, name);
    }

    @JsonIgnore
    public String getQuery() throws FeatureStoreException, IOException {
        return this.getQuery(Storage.ONLINE, false);
    }

    @JsonIgnore
    public String getQuery(boolean withLabel) throws FeatureStoreException, IOException {
        return this.getQuery(Storage.ONLINE, withLabel);
    }

    @JsonIgnore
    public String getQuery(Storage storage) throws FeatureStoreException, IOException {
        return this.getQuery(storage, false);
    }

    @JsonIgnore
    public String getQuery(Storage storage, boolean withLabel) throws FeatureStoreException, IOException {
        return this.trainingDatasetEngine.getQuery(this, storage, withLabel);
    }

    @JsonIgnore
    public List<String> getLabel() {
        return this.features.stream().filter(TrainingDatasetFeature::getLabel).map(TrainingDatasetFeature::getName).collect(Collectors.toList());
    }

    public static TrainingDatasetBuilder builder() {
        return new TrainingDatasetBuilder();
    }

    public TrainingDataset() {
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(DataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    public TrainingDatasetType getTrainingDatasetType() {
        return this.trainingDatasetType;
    }

    public void setTrainingDatasetType(TrainingDatasetType trainingDatasetType) {
        this.trainingDatasetType = trainingDatasetType;
    }

    public List<TrainingDatasetFeature> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<TrainingDatasetFeature> features) {
        this.features = features;
    }

    public FeatureStore getFeatureStore() {
        return this.featureStore;
    }

    public void setFeatureStore(FeatureStore featureStore) {
        this.featureStore = featureStore;
    }

    public StorageConnector getStorageConnector() {
        return this.storageConnector;
    }

    public void setStorageConnector(StorageConnector storageConnector) {
        this.storageConnector = storageConnector;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Long getSeed() {
        return this.seed;
    }

    public void setSeed(Long seed) {
        this.seed = seed;
    }

    public List<Split> getSplits() {
        return this.splits;
    }

    public void setSplits(List<Split> splits) {
        this.splits = splits;
    }

    public StatisticsConfig getStatisticsConfig() {
        return this.statisticsConfig;
    }

    public void setStatisticsConfig(StatisticsConfig statisticsConfig) {
        this.statisticsConfig = statisticsConfig;
    }

    public Query getQueryInt() {
        return this.queryInt;
    }

    @JsonProperty(value="queryDTO")
    public void setQueryInt(Query queryInt) {
        this.queryInt = queryInt;
    }

    public void setLabel(List<String> label) {
        this.label = label;
    }

    public static class TrainingDatasetBuilder {
        private String name;
        private Integer version;
        private String description;
        private DataFormat dataFormat;
        private StorageConnector storageConnector;
        private String location;
        private List<Split> splits;
        private Long seed;
        private FeatureStore featureStore;
        private StatisticsConfig statisticsConfig;
        private List<String> label;

        TrainingDatasetBuilder() {
        }

        public TrainingDatasetBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public TrainingDatasetBuilder version(Integer version) {
            this.version = version;
            return this;
        }

        public TrainingDatasetBuilder description(String description) {
            this.description = description;
            return this;
        }

        public TrainingDatasetBuilder dataFormat(DataFormat dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        public TrainingDatasetBuilder storageConnector(StorageConnector storageConnector) {
            this.storageConnector = storageConnector;
            return this;
        }

        public TrainingDatasetBuilder location(String location) {
            this.location = location;
            return this;
        }

        public TrainingDatasetBuilder splits(List<Split> splits) {
            this.splits = splits;
            return this;
        }

        public TrainingDatasetBuilder seed(Long seed) {
            this.seed = seed;
            return this;
        }

        public TrainingDatasetBuilder featureStore(FeatureStore featureStore) {
            this.featureStore = featureStore;
            return this;
        }

        public TrainingDatasetBuilder statisticsConfig(StatisticsConfig statisticsConfig) {
            this.statisticsConfig = statisticsConfig;
            return this;
        }

        public TrainingDatasetBuilder label(List<String> label) {
            this.label = label;
            return this;
        }

        public TrainingDataset build() {
            return new TrainingDataset(this.name, this.version, this.description, this.dataFormat, this.storageConnector, this.location, this.splits, this.seed, this.featureStore, this.statisticsConfig, this.label);
        }

        public String toString() {
            return "TrainingDataset.TrainingDatasetBuilder(name=" + this.name + ", version=" + this.version + ", description=" + this.description + ", dataFormat=" + (Object)((Object)this.dataFormat) + ", storageConnector=" + this.storageConnector + ", location=" + this.location + ", splits=" + this.splits + ", seed=" + this.seed + ", featureStore=" + this.featureStore + ", statisticsConfig=" + this.statisticsConfig + ", label=" + this.label + ")";
        }
    }
}

