/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.engine;

import com.logicalclocks.hsfs.Feature;
import com.logicalclocks.hsfs.FeatureGroup;
import com.logicalclocks.hsfs.FeatureGroupCommit;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.HudiOperationType;
import com.logicalclocks.hsfs.Storage;
import com.logicalclocks.hsfs.StorageConnector;
import com.logicalclocks.hsfs.TimeTravelFormat;
import com.logicalclocks.hsfs.engine.HudiEngine;
import com.logicalclocks.hsfs.engine.SparkEngine;
import com.logicalclocks.hsfs.engine.Utils;
import com.logicalclocks.hsfs.metadata.FeatureGroupApi;
import com.logicalclocks.hsfs.metadata.StorageConnectorApi;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureGroupEngine {
    private FeatureGroupApi featureGroupApi = new FeatureGroupApi();
    private StorageConnectorApi storageConnectorApi = new StorageConnectorApi();
    private HudiEngine hudiEngine = new HudiEngine();
    private Utils utils = new Utils();
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureGroupEngine.class);

    public void saveFeatureGroup(FeatureGroup featureGroup, Dataset<Row> dataset, List<String> primaryKeys, List<String> partitionKeys, String hudiPrecombineKey, Map<String, String> writeOptions) throws FeatureStoreException, IOException {
        if (featureGroup.getFeatures() == null) {
            featureGroup.setFeatures(this.utils.parseFeatureGroupSchema(dataset));
        }
        LOGGER.info("Featuregroup features: " + featureGroup.getFeatures());
        if (primaryKeys != null) {
            primaryKeys.forEach(pk -> featureGroup.getFeatures().forEach(f -> {
                if (f.getName().equals(pk)) {
                    f.setPrimary(true);
                }
            }));
        }
        if (partitionKeys != null) {
            partitionKeys.forEach(pk -> featureGroup.getFeatures().forEach(f -> {
                if (f.getName().equals(pk)) {
                    f.setPartition(true);
                }
            }));
        }
        if (hudiPrecombineKey != null) {
            featureGroup.getFeatures().forEach(f -> {
                if (f.getName().equals(hudiPrecombineKey)) {
                    f.setHudiPrecombineKey(true);
                }
            });
        }
        FeatureGroup apiFG = this.featureGroupApi.save(featureGroup);
        if (featureGroup.getVersion() == null) {
            LOGGER.info("VersionWarning: No version provided for creating feature group `" + featureGroup.getName() + "`, incremented version to `" + apiFG.getVersion() + "`.");
        }
        featureGroup.setId(apiFG.getId());
        featureGroup.setVersion(apiFG.getVersion());
        featureGroup.setLocation(apiFG.getLocation());
        featureGroup.setId(apiFG.getId());
        featureGroup.setStatisticsConfig(apiFG.getStatisticsConfig());
        if (featureGroup.getTimeTravelFormat() == TimeTravelFormat.HUDI & hudiPrecombineKey == null) {
            List<Feature> features = apiFG.getFeatures();
            featureGroup.setFeatures(features);
        }
        this.saveDataframe(featureGroup, dataset, null, SaveMode.Append, featureGroup.getTimeTravelFormat() == TimeTravelFormat.HUDI ? HudiOperationType.BULK_INSERT : null, writeOptions);
    }

    public void saveDataframe(FeatureGroup featureGroup, Dataset<Row> dataset, Storage storage, SaveMode saveMode, HudiOperationType operation, Map<String, String> writeOptions) throws IOException, FeatureStoreException {
        if (!featureGroup.getOnlineEnabled().booleanValue() && storage == Storage.ONLINE) {
            throw new FeatureStoreException("Online storage is not enabled for this feature group. Set `online=false` to write to the offline storage.");
        }
        if (storage == Storage.OFFLINE || !featureGroup.getOnlineEnabled().booleanValue()) {
            this.saveOfflineDataframe(featureGroup, dataset, saveMode, operation, writeOptions);
        } else if (storage == Storage.ONLINE) {
            this.saveOnlineDataframe(featureGroup, dataset, saveMode, writeOptions);
        } else if (featureGroup.getOnlineEnabled().booleanValue() && storage == null) {
            this.saveOfflineDataframe(featureGroup, dataset, saveMode, operation, writeOptions);
            this.saveOnlineDataframe(featureGroup, dataset, saveMode, writeOptions);
        } else {
            throw new FeatureStoreException("Error writing to offline and online feature store.");
        }
    }

    private void saveOfflineDataframe(FeatureGroup featureGroup, Dataset<Row> dataset, SaveMode saveMode, HudiOperationType operation, Map<String, String> writeOptions) throws FeatureStoreException, IOException {
        if (saveMode == SaveMode.Overwrite) {
            this.featureGroupApi.deleteContent(featureGroup);
            saveMode = SaveMode.Append;
        }
        SparkEngine.getInstance().writeOfflineDataframe(featureGroup, dataset, saveMode, operation, writeOptions);
    }

    private void saveOnlineDataframe(FeatureGroup featureGroup, Dataset<Row> dataset, SaveMode saveMode, Map<String, String> providedWriteOptions) throws IOException, FeatureStoreException {
        StorageConnector storageConnector = this.storageConnectorApi.getOnlineStorageConnector(featureGroup.getFeatureStore());
        Map<String, String> writeOptions = SparkEngine.getInstance().getOnlineOptions(providedWriteOptions, featureGroup, storageConnector);
        SparkEngine.getInstance().writeOnlineDataframe(dataset, saveMode, writeOptions);
    }

    public Map<String, Map<String, String>> commitDetails(FeatureGroup featureGroup, Integer limit) throws IOException, FeatureStoreException {
        List<FeatureGroupCommit> featureGroupCommits = this.featureGroupApi.commitDetails(featureGroup, limit);
        if (featureGroupCommits == null) {
            throw new FeatureStoreException("There are no commit details available for this Feature group");
        }
        HashMap<String, Map<String, String>> commitDetails = new HashMap<String, Map<String, String>>();
        for (final FeatureGroupCommit featureGroupCommit : featureGroupCommits) {
            commitDetails.put(featureGroupCommit.getCommitID().toString(), (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("committedOn", FeatureGroupEngine.this.hudiEngine.timeStampToHudiFormat(featureGroupCommit.getCommitID()));
                    this.put("rowsUpdated", featureGroupCommit.getRowsUpdated().toString());
                    this.put("rowsInserted", featureGroupCommit.getRowsInserted().toString());
                    this.put("rowsDeleted", featureGroupCommit.getRowsDeleted().toString());
                }
            });
        }
        return commitDetails;
    }

    public FeatureGroupCommit commitDelete(FeatureGroup featureGroup, Dataset<Row> dataset, Map<String, String> writeOptions) throws IOException, FeatureStoreException {
        return this.hudiEngine.deleteRecord(SparkEngine.getInstance().getSparkSession(), featureGroup, dataset, writeOptions);
    }
}

