/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.metadata;

import com.damnhandy.uri.template.UriTemplate;
import com.logicalclocks.hsfs.FeatureGroup;
import com.logicalclocks.hsfs.FeatureGroupCommit;
import com.logicalclocks.hsfs.FeatureStore;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.OnDemandFeatureGroup;
import com.logicalclocks.hsfs.metadata.FeatureGroupBase;
import com.logicalclocks.hsfs.metadata.HopsworksClient;
import java.io.IOException;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureGroupApi {
    public static final String FEATURE_GROUP_ROOT_PATH = "/featuregroups";
    public static final String FEATURE_GROUP_PATH = "/featuregroups{/fgName}{?version}";
    public static final String FEATURE_GROUP_ID_PATH = "/featuregroups{/fgId}{?updateStatsConfig,updateMetadata}";
    public static final String FEATURE_GROUP_COMMIT_PATH = "/featuregroups{/fgId}{?updateStatsConfig,updateMetadata}/commits{?sort_by,offset,limit}";
    public static final String FEATURE_GROUP_CLEAR_PATH = "/featuregroups{/fgId}{?updateStatsConfig,updateMetadata}/clear";
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureGroupApi.class);

    public FeatureGroup getFeatureGroup(FeatureStore featureStore, String fgName, Integer fgVersion) throws IOException, FeatureStoreException {
        FeatureGroup[] offlineFeatureGroups = this.getInternal(featureStore, fgName, fgVersion, FeatureGroup[].class);
        FeatureGroup resultFg = offlineFeatureGroups[0];
        resultFg.setFeatureStore(featureStore);
        return resultFg;
    }

    public OnDemandFeatureGroup getOnDemandFeatureGroup(FeatureStore featureStore, String fgName, Integer fgVersion) throws IOException, FeatureStoreException {
        OnDemandFeatureGroup[] offlineFeatureGroups = this.getInternal(featureStore, fgName, fgVersion, OnDemandFeatureGroup[].class);
        OnDemandFeatureGroup resultFg = offlineFeatureGroups[0];
        resultFg.setFeatureStore(featureStore);
        return resultFg;
    }

    private <T> T getInternal(FeatureStore featureStore, String fgName, Integer fgVersion, Class<T> fgType) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/featuregroups{/fgName}{?version}";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)featureStore.getProjectId()).set("fsId", (Object)featureStore.getId()).set("fgName", (Object)fgName).set("version", (Object)fgVersion).expand();
        LOGGER.info("Sending metadata request: " + uri);
        return hopsworksClient.handleRequest((HttpRequest)new HttpGet(uri), fgType);
    }

    public OnDemandFeatureGroup save(OnDemandFeatureGroup onDemandFeatureGroup) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String featureGroupJson = hopsworksClient.getObjectMapper().writeValueAsString((Object)onDemandFeatureGroup);
        return this.saveInternal(onDemandFeatureGroup, new StringEntity(featureGroupJson), OnDemandFeatureGroup.class);
    }

    public FeatureGroup save(FeatureGroup featureGroup) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String featureGroupJson = hopsworksClient.getObjectMapper().writeValueAsString((Object)featureGroup);
        return this.saveInternal(featureGroup, new StringEntity(featureGroupJson), FeatureGroup.class);
    }

    private <T> T saveInternal(FeatureGroupBase featureGroupBase, StringEntity entity, Class<T> fgType) throws FeatureStoreException, IOException {
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/featuregroups";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)featureGroupBase.getFeatureStore().getProjectId()).set("fsId", (Object)featureGroupBase.getFeatureStore().getId()).expand();
        HttpPost postRequest = new HttpPost(uri);
        postRequest.setHeader("Content-Type", "application/json");
        postRequest.setEntity((HttpEntity)entity);
        LOGGER.info("Sending metadata request: " + uri);
        return HopsworksClient.getInstance().handleRequest((HttpRequest)postRequest, fgType);
    }

    public void delete(FeatureGroupBase featureGroupBase) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/featuregroups{/fgId}{?updateStatsConfig,updateMetadata}";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)featureGroupBase.getFeatureStore().getProjectId()).set("fsId", (Object)featureGroupBase.getFeatureStore().getId()).set("fgId", (Object)featureGroupBase.getId()).expand();
        HttpDelete deleteRequest = new HttpDelete(uri);
        LOGGER.info("Sending metadata request: " + uri);
        hopsworksClient.handleRequest((HttpRequest)deleteRequest);
    }

    public void deleteContent(FeatureGroup featureGroup) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/featuregroups{/fgId}{?updateStatsConfig,updateMetadata}/clear";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)featureGroup.getFeatureStore().getProjectId()).set("fsId", (Object)featureGroup.getFeatureStore().getId()).set("fgId", (Object)featureGroup.getId()).expand();
        LOGGER.info("Sending metadata request: " + uri);
        HttpPost postRequest = new HttpPost(uri);
        hopsworksClient.handleRequest((HttpRequest)postRequest);
    }

    public FeatureGroup updateMetadata(FeatureGroupBase featureGroup, String queryParameter) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/featuregroups{/fgId}{?updateStatsConfig,updateMetadata}";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)featureGroup.getFeatureStore().getProjectId()).set("fsId", (Object)featureGroup.getFeatureStore().getId()).set("fgId", (Object)featureGroup.getId()).set(queryParameter, (Object)true).expand();
        String featureGroupJson = hopsworksClient.getObjectMapper().writeValueAsString((Object)featureGroup);
        HttpPut putRequest = new HttpPut(uri);
        putRequest.setHeader("Content-Type", "application/json");
        putRequest.setEntity((HttpEntity)new StringEntity(featureGroupJson));
        LOGGER.info("Sending metadata request: " + uri);
        LOGGER.info(featureGroupJson);
        return hopsworksClient.handleRequest((HttpRequest)putRequest, FeatureGroup.class);
    }

    public FeatureGroupCommit featureGroupCommit(FeatureGroup featureGroup, FeatureGroupCommit featureGroupCommit) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/featuregroups{/fgId}{?updateStatsConfig,updateMetadata}/commits{?sort_by,offset,limit}";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)featureGroup.getFeatureStore().getProjectId()).set("fsId", (Object)featureGroup.getFeatureStore().getId()).set("fgId", (Object)featureGroup.getId()).expand();
        String featureGroupCommitJson = hopsworksClient.getObjectMapper().writeValueAsString((Object)featureGroupCommit);
        HttpPost postRequest = new HttpPost(uri);
        postRequest.setHeader("Content-Type", "application/json");
        postRequest.setEntity((HttpEntity)new StringEntity(featureGroupCommitJson));
        LOGGER.info("Sending metadata request: " + uri);
        return hopsworksClient.handleRequest((HttpRequest)postRequest, FeatureGroupCommit.class);
    }

    public List<FeatureGroupCommit> commitDetails(FeatureGroup featureGroupBase, Integer limit) throws IOException, FeatureStoreException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/featuregroups{/fgId}{?updateStatsConfig,updateMetadata}/commits{?sort_by,offset,limit}";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)featureGroupBase.getFeatureStore().getProjectId()).set("fsId", (Object)featureGroupBase.getFeatureStore().getId()).set("fgId", (Object)featureGroupBase.getId()).set("sort_by", (Object)"committed_on:desc").set("offset", (Object)0).set("limit", (Object)limit).expand();
        LOGGER.info("Sending metadata request: " + uri);
        FeatureGroupCommit featureGroupCommit = hopsworksClient.handleRequest((HttpRequest)new HttpGet(uri), FeatureGroupCommit.class);
        return featureGroupCommit.getItems();
    }
}

