/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.SecretStore;
import com.logicalclocks.hsfs.metadata.AuthorizationHandler;
import com.logicalclocks.hsfs.metadata.HopsworksHostnameVerifier;
import com.logicalclocks.hsfs.metadata.HopsworksHttpClient;
import com.logicalclocks.hsfs.metadata.InternalException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.ResponseHandler;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.parquet.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.SsmClientBuilder;
import software.amazon.awssdk.services.ssm.model.GetParameterRequest;
import software.amazon.awssdk.services.ssm.model.GetParameterResponse;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.model.GetCallerIdentityResponse;

public class HopsworksExternalClient
implements HopsworksHttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)HopsworksExternalClient.class.getName());
    private static final String PARAM_NAME_SECRET_STORE = "hopsworks/role/";
    private static final String PARAM_NAME_PARAMETER_STORE = "/hopsworks/role/";
    private PoolingHttpClientConnectionManager connectionPool = null;
    private HttpHost httpHost = null;
    private CloseableHttpClient httpClient = null;
    private String apiKey = "";

    public HopsworksExternalClient(String host, int port, String apiKeyFilepath, boolean hostnameVerification, String trustStorePath) throws IOException, FeatureStoreException, KeyStoreException, CertificateException, NoSuchAlgorithmException, KeyManagementException {
        this(host, port, null, null, hostnameVerification, trustStorePath, apiKeyFilepath, null);
    }

    public HopsworksExternalClient(String host, int port, boolean hostnameVerification, String trustStorePath, Region region, SecretStore secretStore) throws IOException, FeatureStoreException, KeyStoreException, CertificateException, NoSuchAlgorithmException, KeyManagementException {
        this(host, port, region, secretStore, hostnameVerification, trustStorePath, null, null);
    }

    public HopsworksExternalClient(String host, int port, boolean hostnameVerification, String trustStorePath, String apiKeyValue) throws IOException, FeatureStoreException, KeyStoreException, CertificateException, NoSuchAlgorithmException, KeyManagementException {
        this(host, port, null, null, hostnameVerification, trustStorePath, null, apiKeyValue);
    }

    public HopsworksExternalClient(CloseableHttpClient httpClient, HttpHost httpHost) {
        this.httpClient = httpClient;
        this.httpHost = httpHost;
    }

    HopsworksExternalClient(String host, int port, Region region, SecretStore secretStore, boolean hostnameVerification, String trustStorePath, String apiKeyFilepath, String apiKeyValue) throws IOException, FeatureStoreException, KeyStoreException, CertificateException, NoSuchAlgorithmException, KeyManagementException {
        this.httpHost = new HttpHost(host, port, "https");
        this.connectionPool = new PoolingHttpClientConnectionManager(this.createConnectionFactory(this.httpHost, hostnameVerification, trustStorePath));
        this.connectionPool.setMaxTotal(10);
        this.connectionPool.setDefaultMaxPerRoute(10);
        this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.connectionPool).setKeepAliveStrategy((httpResponse, httpContext) -> 30000L).build();
        this.apiKey = !Strings.isNullOrEmpty((String)apiKeyValue) ? apiKeyValue : this.readApiKey(secretStore, region, apiKeyFilepath);
    }

    private Registry<ConnectionSocketFactory> createConnectionFactory(HttpHost httpHost, boolean hostnameVerification, String trustStorePath) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslCtx = null;
        sslCtx = !Strings.isNullOrEmpty((String)trustStorePath) ? SSLContexts.custom().loadTrustMaterial(Paths.get(trustStorePath, new String[0]).toFile(), null, (TrustStrategy)new TrustSelfSignedStrategy()).build() : (!hostnameVerification ? SSLContexts.custom().loadTrustMaterial((TrustStrategy)new TrustAllStrategy()).build() : SSLContext.getDefault());
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslCtx, (HostnameVerifier)new HopsworksHostnameVerifier(hostnameVerification, httpHost.toHostString()));
        return RegistryBuilder.create().register("https", (Object)sslsf).register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).build();
    }

    public String readApiKey(SecretStore secretStore, Region region, String apiKeyFilepath) throws IOException, FeatureStoreException {
        if (!Strings.isNullOrEmpty((String)apiKeyFilepath)) {
            return FileUtils.readFileToString((File)Paths.get(apiKeyFilepath, new String[0]).toFile());
        }
        switch (secretStore) {
            case PARAMETER_STORE: {
                return this.readApiKeyParamStore(region, "api-key");
            }
            case SECRET_MANAGER: {
                return this.readApiKeySecretManager(region, "api-key");
            }
        }
        throw new FeatureStoreException("ApiKeyFilepath needs to be set for local mode");
    }

    private String readApiKeyParamStore(Region region, String secretKey) throws FeatureStoreException {
        SsmClient ssmClient = (SsmClient)((SsmClientBuilder)SsmClient.builder().region(region)).build();
        String paramName = PARAM_NAME_PARAMETER_STORE + this.getAssumedRole() + "/type/" + secretKey;
        GetParameterRequest paramRequest = (GetParameterRequest)GetParameterRequest.builder().name(paramName).withDecryption(Boolean.valueOf(true)).build();
        GetParameterResponse parameterResponse = ssmClient.getParameter(paramRequest);
        String apiKey = parameterResponse.parameter().value();
        if (!Strings.isNullOrEmpty((String)apiKey)) {
            return apiKey;
        }
        throw new FeatureStoreException("Could not find parameter " + paramName + " in parameter store");
    }

    private String readApiKeySecretManager(Region region, String secretKey) throws FeatureStoreException, IOException {
        SecretsManagerClient secretsManagerClient = (SecretsManagerClient)((SecretsManagerClientBuilder)SecretsManagerClient.builder().region(region)).build();
        String paramName = PARAM_NAME_SECRET_STORE + this.getAssumedRole();
        ObjectMapper objectMapper = new ObjectMapper();
        GetSecretValueRequest secretValueRequest = (GetSecretValueRequest)GetSecretValueRequest.builder().secretId(paramName).build();
        GetSecretValueResponse secretValueResponse = secretsManagerClient.getSecretValue(secretValueRequest);
        HashMap secretMap = (HashMap)objectMapper.readValue(secretValueResponse.secretString(), HashMap.class);
        String apiKey = (String)secretMap.get("api-key");
        if (!Strings.isNullOrEmpty((String)apiKey)) {
            return apiKey;
        }
        throw new FeatureStoreException("Could not find secret " + paramName + " in secret store");
    }

    private String getAssumedRole() throws FeatureStoreException {
        StsClient stsClient = StsClient.create();
        GetCallerIdentityResponse callerIdentityResponse = stsClient.getCallerIdentity();
        String arn = callerIdentityResponse.arn();
        String[] arnSplits = arn.split("/");
        if (arnSplits.length != 3 || !arnSplits[0].endsWith("assumed-role")) {
            throw new FeatureStoreException("Failed to extract assumed role from arn: " + arn);
        }
        return arnSplits[1];
    }

    @Override
    public <T> T handleRequest(HttpRequest request, ResponseHandler<T> responseHandler) throws IOException {
        LOGGER.info("Handling metadata request: " + request);
        AuthorizationHandler<T> authHandler = new AuthorizationHandler<T>(responseHandler);
        request.setHeader("Authorization", "ApiKey " + this.apiKey);
        try {
            return (T)this.httpClient.execute(this.httpHost, request, authHandler);
        }
        catch (InternalException e) {
            return (T)this.httpClient.execute(this.httpHost, request, authHandler);
        }
    }
}

