/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.metadata;

import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.metadata.AuthorizationHandler;
import com.logicalclocks.hsfs.metadata.HopsworksHostnameVerifier;
import com.logicalclocks.hsfs.metadata.HopsworksHttpClient;
import com.logicalclocks.hsfs.metadata.UnauthorizedException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import jdk.nashorn.internal.runtime.regexp.joni.exception.InternalException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.ResponseHandler;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HopsworksInternalClient
implements HopsworksHttpClient {
    public static final String REST_ENDPOINT_SYS = "hopsworks.restendpoint";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)HopsworksInternalClient.class.getName());
    private static final String DOMAIN_CA_TRUSTSTORE = "hopsworks.domain.truststore";
    private static final String TOKEN_PATH = "token.jwt";
    private PoolingHttpClientConnectionManager connectionPool = null;
    private HttpHost httpHost = null;
    private CloseableHttpClient httpClient = null;
    private String hopsworksEndpoint = System.getProperties().getProperty("hopsworks.restendpoint");
    private String jwt = "";

    public HopsworksInternalClient() throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException, KeyManagementException, FeatureStoreException {
        this.httpHost = HttpHost.create((String)this.hopsworksEndpoint);
        this.connectionPool = new PoolingHttpClientConnectionManager(this.createConnectionFactory());
        this.connectionPool.setMaxTotal(10);
        this.connectionPool.setDefaultMaxPerRoute(10);
        this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.connectionPool).setKeepAliveStrategy((httpResponse, httpContext) -> 30000L).build();
        this.refreshJwt();
    }

    private Registry<ConnectionSocketFactory> createConnectionFactory() throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException, KeyManagementException {
        Properties systemProperties = System.getProperties();
        Path trustStorePath = Paths.get(systemProperties.getProperty(DOMAIN_CA_TRUSTSTORE), new String[0]);
        LOGGER.info("Trust store path: " + trustStorePath);
        SSLContext sslCtx = SSLContexts.custom().loadTrustMaterial(trustStorePath.toFile(), null, (TrustStrategy)new TrustSelfSignedStrategy()).build();
        boolean insecure = Boolean.parseBoolean(systemProperties.getProperty("hopsutil.insecure"));
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslCtx, (HostnameVerifier)new HopsworksHostnameVerifier(insecure, this.hopsworksEndpoint));
        return RegistryBuilder.create().register("https", (Object)sslsf).register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshJwt() throws FeatureStoreException {
        try (FileChannel fc = FileChannel.open(Paths.get(TOKEN_PATH, new String[0]), StandardOpenOption.READ);){
            FileLock fileLock = fc.tryLock(0L, Long.MAX_VALUE, true);
            try {
                int numRetries = 5;
                for (int retries = 0; fileLock == null && retries < numRetries; retries = (int)((short)(retries + 1))) {
                    LOGGER.debug("Waiting for lock on jwt file at:token.jwt");
                    Thread.sleep(1000L);
                    fileLock = fc.tryLock(0L, Long.MAX_VALUE, true);
                }
                if (fileLock == null) {
                    throw new FeatureStoreException("Could not read jwt token from local container, possibly another process has acquired the lock");
                }
                ByteBuffer buf = ByteBuffer.allocateDirect(512);
                fc.read(buf);
                buf.flip();
                this.jwt = StandardCharsets.UTF_8.decode(buf).toString();
            }
            catch (InterruptedException e) {
                LOGGER.warn("JWT waiting thread was interrupted.", (Throwable)e);
            }
            finally {
                if (fileLock != null) {
                    fileLock.release();
                }
            }
        }
        catch (IOException e) {
            throw new FeatureStoreException("Could not read jwt token from local container." + e.getMessage(), e);
        }
    }

    @Override
    public <T> T handleRequest(HttpRequest request, ResponseHandler<T> responseHandler) throws IOException, FeatureStoreException {
        LOGGER.debug("Handling metadata request: " + request);
        AuthorizationHandler<T> authHandler = new AuthorizationHandler<T>(responseHandler);
        request.setHeader("Authorization", "Bearer " + this.jwt);
        try {
            return (T)this.httpClient.execute(this.httpHost, request, authHandler);
        }
        catch (UnauthorizedException e) {
            this.refreshJwt();
            request.setHeader("Authorization", "Bearer " + this.jwt);
            return (T)this.httpClient.execute(this.httpHost, request, authHandler);
        }
        catch (InternalException e) {
            return (T)this.httpClient.execute(this.httpHost, request, authHandler);
        }
    }
}

