/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.metadata;

import com.damnhandy.uri.template.UriTemplate;
import com.google.common.base.Strings;
import com.logicalclocks.hsfs.EntityEndpointType;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.TrainingDataset;
import com.logicalclocks.hsfs.metadata.FeatureGroupBase;
import com.logicalclocks.hsfs.metadata.HopsworksClient;
import com.logicalclocks.hsfs.metadata.Tags;
import java.io.IOException;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagsApi {
    public static final String ENTITY_ROOT_PATH = "{/entityType}";
    public static final String ENTITY_ID_PATH = "{/entityType}{/entityId}";
    public static final String TAGS_PATH = "{/entityType}{/entityId}/tags{/name}{?value}";
    private static final Logger LOGGER = LoggerFactory.getLogger(TagsApi.class);
    private EntityEndpointType entityType;

    public TagsApi(@NonNull EntityEndpointType entityType) {
        if (entityType == null) {
            throw new NullPointerException("entityType is marked non-null but is null");
        }
        this.entityType = entityType;
    }

    private void add(Integer projectId, Integer featurestoreId, Integer entityId, String name, String value) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}{/entityType}{/entityId}/tags{/name}{?value}";
        UriTemplate uriTemplate = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)projectId).set("fsId", (Object)featurestoreId).set("entityType", (Object)this.entityType.getValue()).set("entityId", (Object)entityId).set("name", (Object)name);
        if (value != null) {
            uriTemplate.set("value", (Object)value);
        }
        LOGGER.info("Sending metadata request: " + uriTemplate.expand());
        HttpPut putRequest = new HttpPut(uriTemplate.expand());
        hopsworksClient.handleRequest((HttpRequest)putRequest);
    }

    public void add(FeatureGroupBase featureGroupBase, String name, String value) throws FeatureStoreException, IOException {
        this.add(featureGroupBase.getFeatureStore().getProjectId(), featureGroupBase.getFeatureStore().getId(), featureGroupBase.getId(), name, value);
    }

    public void add(TrainingDataset trainingDataset, String name, String value) throws FeatureStoreException, IOException {
        this.add(trainingDataset.getFeatureStore().getProjectId(), trainingDataset.getFeatureStore().getId(), trainingDataset.getId(), name, value);
    }

    private Map<String, String> get(Integer projectId, Integer featurestoreId, Integer entityId, String name) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}{/entityType}{/entityId}/tags{/name}{?value}";
        UriTemplate uriTemplate = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)projectId).set("fsId", (Object)featurestoreId).set("entityType", (Object)this.entityType.getValue()).set("entityId", (Object)entityId);
        if (!Strings.isNullOrEmpty((String)name)) {
            uriTemplate.set("name", (Object)name);
        }
        String uri = uriTemplate.expand();
        LOGGER.info("Sending metadata request: " + uri);
        HttpGet getRequest = new HttpGet(uri);
        Tags tags = hopsworksClient.handleRequest((HttpRequest)getRequest, Tags.class);
        return tags.getItems().stream().collect(Collectors.toMap(Tags::getName, Tags::getValue));
    }

    public Map<String, String> get(FeatureGroupBase featureGroupBase, String name) throws FeatureStoreException, IOException {
        return this.get(featureGroupBase.getFeatureStore().getProjectId(), featureGroupBase.getFeatureStore().getId(), featureGroupBase.getId(), name);
    }

    public Map<String, String> get(TrainingDataset trainingDataset, String name) throws FeatureStoreException, IOException {
        return this.get(trainingDataset.getFeatureStore().getProjectId(), trainingDataset.getFeatureStore().getId(), trainingDataset.getId(), name);
    }

    private void deleteTag(Integer projectId, Integer featurestoreId, Integer entityId, String name) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}{/entityType}{/entityId}/tags{/name}{?value}";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)projectId).set("fsId", (Object)featurestoreId).set("entityType", (Object)this.entityType.getValue()).set("entityId", (Object)entityId).set("name", (Object)name).expand();
        LOGGER.info("Sending metadata request: " + uri);
        HttpDelete httpDelete = new HttpDelete(uri);
        hopsworksClient.handleRequest((HttpRequest)httpDelete);
    }

    public void deleteTag(FeatureGroupBase featureGroup, String name) throws FeatureStoreException, IOException {
        this.deleteTag(featureGroup.getFeatureStore().getProjectId(), featureGroup.getFeatureStore().getId(), featureGroup.getId(), name);
    }

    public void deleteTag(TrainingDataset trainingDataset, String name) throws FeatureStoreException, IOException {
        this.deleteTag(trainingDataset.getFeatureStore().getProjectId(), trainingDataset.getFeatureStore().getId(), trainingDataset.getId(), name);
    }
}

