/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.StorageConnectorType;
import com.logicalclocks.hsfs.metadata.Option;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.parquet.Strings;

public class StorageConnector {
    private Integer id;
    private String name;
    private String accessKey;
    private String secretKey;
    private String serverEncryptionAlgorithm;
    private String serverEncryptionKey;
    private String bucket;
    private String clusterIdentifier;
    private String databaseDriver;
    private String databaseEndpoint;
    private String databaseName;
    private Integer databasePort;
    private String tableName;
    private String databaseUserName;
    private Boolean autoCreate;
    private String databaseGroup;
    private Date expiration;
    private String databasePassword;
    private String sessionToken;
    private String connectionString;
    private String arguments;
    private Integer generation;
    private String directoryId;
    private String applicationId;
    private String serviceCredentials;
    private String accountName;
    private String containerName;
    private String url;
    private String user;
    private String password;
    private String token;
    private String database;
    private String schema;
    private String warehouse;
    private String role;
    private String table;
    private List<Option> sparkOptions;
    private List<Option> sfOptions;
    private StorageConnectorType storageConnectorType;

    public String account() {
        return this.url.replace("https://", "").replace(".snowflakecomputing.com", "");
    }

    @JsonIgnore
    public Map<String, String> getSparkOptionsInt() throws FeatureStoreException {
        switch (this.storageConnectorType) {
            case JDBC: {
                return this.getJdbcOptions();
            }
            case REDSHIFT: {
                return this.getRedshiftOptions();
            }
            case SNOWFLAKE: {
                return this.getSnowflakeOptions();
            }
        }
        throw new FeatureStoreException("Spark options are not supported for connector " + (Object)((Object)this.storageConnectorType));
    }

    @JsonIgnore
    private Map<String, String> getJdbcOptions() {
        Map<String, String> options = Arrays.stream(this.arguments.split(",")).map(arg -> arg.split("=")).collect(Collectors.toMap(a -> a[0], a -> a[1]));
        options.put("url", this.connectionString);
        return options;
    }

    @JsonIgnore
    private Map<String, String> getRedshiftOptions() {
        String constr = "jdbc:redshift://" + this.clusterIdentifier + "." + this.databaseEndpoint + ":" + this.databasePort + "/" + this.databaseName;
        if (!Strings.isNullOrEmpty((String)this.arguments)) {
            constr = constr + "?" + this.arguments;
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("driver", this.databaseDriver);
        options.put("url", constr);
        options.put("user", this.databaseUserName);
        options.put("password", this.databasePassword);
        if (!Strings.isNullOrEmpty((String)this.tableName)) {
            options.put("dbtable", this.tableName);
        }
        return options;
    }

    @JsonIgnore
    public String getPath(String subPath) throws FeatureStoreException {
        switch (this.storageConnectorType) {
            case S3: {
                return "s3://" + this.bucket + "/" + (Strings.isNullOrEmpty((String)subPath) ? "" : subPath);
            }
        }
        throw new FeatureStoreException("Path method not supported for storage connector type: " + (Object)((Object)this.storageConnectorType));
    }

    @JsonIgnore
    private Map<String, String> getSnowflakeOptions() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("sfURL", this.url);
        options.put("sfSchema", this.schema);
        options.put("sfDatabase", this.database);
        options.put("sfUser", this.user);
        if (!Strings.isNullOrEmpty((String)this.password)) {
            options.put("sfPassword", this.password);
        } else {
            options.put("sfAuthenticator", "oauth");
            options.put("sfToken", this.token);
        }
        if (!Strings.isNullOrEmpty((String)this.warehouse)) {
            options.put("sfWarehouse", this.warehouse);
        }
        if (!Strings.isNullOrEmpty((String)this.role)) {
            options.put("sfRole", this.role);
        }
        if (!Strings.isNullOrEmpty((String)this.table)) {
            options.put("dbtable", this.table);
        }
        if (this.sfOptions != null && !this.sfOptions.isEmpty()) {
            Map<String, String> argOptions = this.sfOptions.stream().collect(Collectors.toMap(Option::getName, Option::getValue));
            options.putAll(argOptions);
        }
        return options;
    }

    public StorageConnector(Integer id, String name, String accessKey, String secretKey, String serverEncryptionAlgorithm, String serverEncryptionKey, String bucket, String clusterIdentifier, String databaseDriver, String databaseEndpoint, String databaseName, Integer databasePort, String tableName, String databaseUserName, Boolean autoCreate, String databaseGroup, Date expiration, String databasePassword, String sessionToken, String connectionString, String arguments, Integer generation, String directoryId, String applicationId, String serviceCredentials, String accountName, String containerName, String url, String user, String password, String token, String database, String schema, String warehouse, String role, String table, List<Option> sparkOptions, List<Option> sfOptions, StorageConnectorType storageConnectorType) {
        this.id = id;
        this.name = name;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.serverEncryptionAlgorithm = serverEncryptionAlgorithm;
        this.serverEncryptionKey = serverEncryptionKey;
        this.bucket = bucket;
        this.clusterIdentifier = clusterIdentifier;
        this.databaseDriver = databaseDriver;
        this.databaseEndpoint = databaseEndpoint;
        this.databaseName = databaseName;
        this.databasePort = databasePort;
        this.tableName = tableName;
        this.databaseUserName = databaseUserName;
        this.autoCreate = autoCreate;
        this.databaseGroup = databaseGroup;
        this.expiration = expiration;
        this.databasePassword = databasePassword;
        this.sessionToken = sessionToken;
        this.connectionString = connectionString;
        this.arguments = arguments;
        this.generation = generation;
        this.directoryId = directoryId;
        this.applicationId = applicationId;
        this.serviceCredentials = serviceCredentials;
        this.accountName = accountName;
        this.containerName = containerName;
        this.url = url;
        this.user = user;
        this.password = password;
        this.token = token;
        this.database = database;
        this.schema = schema;
        this.warehouse = warehouse;
        this.role = role;
        this.table = table;
        this.sparkOptions = sparkOptions;
        this.sfOptions = sfOptions;
        this.storageConnectorType = storageConnectorType;
    }

    public StorageConnector() {
    }

    public String toString() {
        return "StorageConnector(id=" + this.getId() + ", name=" + this.getName() + ", accessKey=" + this.getAccessKey() + ", secretKey=" + this.getSecretKey() + ", serverEncryptionAlgorithm=" + this.getServerEncryptionAlgorithm() + ", serverEncryptionKey=" + this.getServerEncryptionKey() + ", bucket=" + this.getBucket() + ", clusterIdentifier=" + this.getClusterIdentifier() + ", databaseDriver=" + this.getDatabaseDriver() + ", databaseEndpoint=" + this.getDatabaseEndpoint() + ", databaseName=" + this.getDatabaseName() + ", databasePort=" + this.getDatabasePort() + ", tableName=" + this.getTableName() + ", databaseUserName=" + this.getDatabaseUserName() + ", autoCreate=" + this.getAutoCreate() + ", databaseGroup=" + this.getDatabaseGroup() + ", expiration=" + this.getExpiration() + ", databasePassword=" + this.getDatabasePassword() + ", sessionToken=" + this.getSessionToken() + ", connectionString=" + this.getConnectionString() + ", arguments=" + this.getArguments() + ", generation=" + this.getGeneration() + ", directoryId=" + this.getDirectoryId() + ", applicationId=" + this.getApplicationId() + ", serviceCredentials=" + this.getServiceCredentials() + ", accountName=" + this.getAccountName() + ", containerName=" + this.getContainerName() + ", url=" + this.getUrl() + ", user=" + this.getUser() + ", password=" + this.getPassword() + ", token=" + this.getToken() + ", database=" + this.getDatabase() + ", schema=" + this.getSchema() + ", warehouse=" + this.getWarehouse() + ", role=" + this.getRole() + ", table=" + this.getTable() + ", sparkOptions=" + this.getSparkOptions() + ", sfOptions=" + this.getSfOptions() + ", storageConnectorType=" + (Object)((Object)this.getStorageConnectorType()) + ")";
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getServerEncryptionAlgorithm() {
        return this.serverEncryptionAlgorithm;
    }

    public void setServerEncryptionAlgorithm(String serverEncryptionAlgorithm) {
        this.serverEncryptionAlgorithm = serverEncryptionAlgorithm;
    }

    public String getServerEncryptionKey() {
        return this.serverEncryptionKey;
    }

    public void setServerEncryptionKey(String serverEncryptionKey) {
        this.serverEncryptionKey = serverEncryptionKey;
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getClusterIdentifier() {
        return this.clusterIdentifier;
    }

    public void setClusterIdentifier(String clusterIdentifier) {
        this.clusterIdentifier = clusterIdentifier;
    }

    public String getDatabaseDriver() {
        return this.databaseDriver;
    }

    public void setDatabaseDriver(String databaseDriver) {
        this.databaseDriver = databaseDriver;
    }

    public String getDatabaseEndpoint() {
        return this.databaseEndpoint;
    }

    public void setDatabaseEndpoint(String databaseEndpoint) {
        this.databaseEndpoint = databaseEndpoint;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public Integer getDatabasePort() {
        return this.databasePort;
    }

    public void setDatabasePort(Integer databasePort) {
        this.databasePort = databasePort;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getDatabaseUserName() {
        return this.databaseUserName;
    }

    public void setDatabaseUserName(String databaseUserName) {
        this.databaseUserName = databaseUserName;
    }

    public Boolean getAutoCreate() {
        return this.autoCreate;
    }

    public void setAutoCreate(Boolean autoCreate) {
        this.autoCreate = autoCreate;
    }

    public String getDatabaseGroup() {
        return this.databaseGroup;
    }

    public void setDatabaseGroup(String databaseGroup) {
        this.databaseGroup = databaseGroup;
    }

    public Date getExpiration() {
        return this.expiration;
    }

    public void setExpiration(Date expiration) {
        this.expiration = expiration;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public void setDatabasePassword(String databasePassword) {
        this.databasePassword = databasePassword;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public void setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public String getArguments() {
        return this.arguments;
    }

    public void setArguments(String arguments) {
        this.arguments = arguments;
    }

    public Integer getGeneration() {
        return this.generation;
    }

    public void setGeneration(Integer generation) {
        this.generation = generation;
    }

    public String getDirectoryId() {
        return this.directoryId;
    }

    public void setDirectoryId(String directoryId) {
        this.directoryId = directoryId;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getServiceCredentials() {
        return this.serviceCredentials;
    }

    public void setServiceCredentials(String serviceCredentials) {
        this.serviceCredentials = serviceCredentials;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getWarehouse() {
        return this.warehouse;
    }

    public void setWarehouse(String warehouse) {
        this.warehouse = warehouse;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public List<Option> getSparkOptions() {
        return this.sparkOptions;
    }

    public void setSparkOptions(List<Option> sparkOptions) {
        this.sparkOptions = sparkOptions;
    }

    public List<Option> getSfOptions() {
        return this.sfOptions;
    }

    public void setSfOptions(List<Option> sfOptions) {
        this.sfOptions = sfOptions;
    }

    public StorageConnectorType getStorageConnectorType() {
        return this.storageConnectorType;
    }

    public void setStorageConnectorType(StorageConnectorType storageConnectorType) {
        this.storageConnectorType = storageConnectorType;
    }
}

