/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.engine;

import com.amazon.deequ.checks.Check;
import com.amazon.deequ.checks.CheckResult;
import com.amazon.deequ.constraints.ConstraintResult;
import com.amazon.deequ.metrics.Metric;
import com.logicalclocks.hsfs.EntityEndpointType;
import com.logicalclocks.hsfs.FeatureGroup;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.engine.Constraint;
import com.logicalclocks.hsfs.engine.ConstraintGroup;
import com.logicalclocks.hsfs.engine.DeequEngine;
import com.logicalclocks.hsfs.metadata.Expectation;
import com.logicalclocks.hsfs.metadata.ExpectationResult;
import com.logicalclocks.hsfs.metadata.FeatureGroupValidation;
import com.logicalclocks.hsfs.metadata.FeatureGroupValidationsApi;
import com.logicalclocks.hsfs.metadata.ValidationResult;
import com.logicalclocks.hsfs.metadata.validation.Level;
import com.logicalclocks.hsfs.metadata.validation.Rule;
import com.logicalclocks.hsfs.metadata.validation.RuleName;
import com.logicalclocks.hsfs.metadata.validation.ValueType;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Option;
import scala.collection.Iterator;
import scala.collection.JavaConverters;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;

public class DataValidationEngine {
    private static DataValidationEngine INSTANCE = null;
    private final FeatureGroupValidationsApi featureGroupValidationsApi = new FeatureGroupValidationsApi(EntityEndpointType.FEATURE_GROUP);

    public static synchronized DataValidationEngine getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DataValidationEngine();
        }
        return INSTANCE;
    }

    public FeatureGroupValidation validate(Dataset<Row> data, FeatureGroup featureGroup, List<Expectation> expectations) throws FeatureStoreException, IOException {
        List<ExpectationResult> expectationResults = this.validate(data, expectations);
        return this.featureGroupValidationsApi.put(featureGroup, FeatureGroupValidation.builder().validationTime(Instant.now().toEpochMilli()).expectationResults(expectationResults).build());
    }

    public List<ExpectationResult> validate(Dataset<Row> data, List<Expectation> expectations) {
        ArrayList<ExpectationResult> expectationResults = new ArrayList<ExpectationResult>();
        for (Expectation expectation : expectations) {
            ArrayList<ConstraintGroup> constraintGroups = new ArrayList<ConstraintGroup>();
            HashMap constraintGroupLevels = new HashMap();
            ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
            for (String feature : expectation.getFeatures()) {
                for (Rule rule : expectation.getRules()) {
                    Constraint constraint = new Constraint(rule.getName().name(), (Option<String>)Option.apply((Object)rule.getName().name()), (Option<Seq<String>>)Option.apply((Object)((Buffer)JavaConverters.asScalaBufferConverter(Collections.singletonList(feature)).asScala()).toSeq()), (Option<Object>)Option.apply((Object)rule.getMin()), (Option<Object>)Option.apply((Object)rule.getMax()), (Option<Object>)Option.apply(null), (Option<String>)Option.apply((Object)rule.getPattern()), (Option<ValueType>)Option.apply((Object)((Object)rule.getAcceptedType())), (Option<String[]>)Option.apply((Object)rule.getLegalValues()));
                    if (!constraintGroupLevels.containsKey((Object)rule.getLevel())) {
                        constraintGroupLevels.put(rule.getLevel(), new ArrayList());
                    }
                    ((List)constraintGroupLevels.get((Object)rule.getLevel())).add(constraint);
                }
            }
            if (!constraintGroupLevels.isEmpty()) {
                for (Level level : constraintGroupLevels.keySet()) {
                    ConstraintGroup constraintGroup = new ConstraintGroup(level.name(), level.name(), (Seq<Constraint>)((Iterator)JavaConverters.asScalaIteratorConverter(((List)constraintGroupLevels.get((Object)level)).iterator()).asScala()).toSeq());
                    constraintGroups.add(constraintGroup);
                }
            }
            Map<Check, CheckResult> deequResults = DeequEngine.runVerification(data, (Seq<ConstraintGroup>)((Iterator)JavaConverters.asScalaIteratorConverter(constraintGroups.iterator()).asScala()).toSeq());
            for (Check check : deequResults.keySet()) {
                List<ConstraintResult> constraintResultsList = DeequEngine.getConstraintResults((Seq<ConstraintResult>)deequResults.get(check).constraintResults());
                for (ConstraintResult constraintResult : constraintResultsList) {
                    String[] constraintInfo = constraintResult.constraint().toString().split("\\W+");
                    RuleName ruleName = this.getRuleNameFromDeequ(constraintInfo[1]);
                    block6: for (String feature : expectation.getFeatures()) {
                        for (Rule rule : expectation.getRules()) {
                            if (rule.getName() != ruleName || !feature.equals(constraintInfo[2])) continue;
                            validationResults.add(ValidationResult.builder().status(ExpectationResult.Status.fromDeequStatus(constraintResult.status())).feature(feature).rule(rule).message(!constraintResult.message().isEmpty() ? (String)constraintResult.message().get() : "Success").value(String.valueOf(((Metric)constraintResult.metric().get()).value().get())).build());
                            continue block6;
                        }
                    }
                }
            }
            expectationResults.add(ExpectationResult.builder().expectation(expectation).results(validationResults).build());
        }
        return expectationResults;
    }

    public List<FeatureGroupValidation> getValidations(FeatureGroup featureGroup) throws FeatureStoreException, IOException {
        return this.featureGroupValidationsApi.get(featureGroup);
    }

    public FeatureGroupValidation getValidation(FeatureGroup featureGroup, ImmutablePair<ValidationTimeType, Long> pair) throws FeatureStoreException, IOException {
        return this.featureGroupValidationsApi.get(featureGroup, pair);
    }

    public RuleName getRuleNameFromDeequ(String deequName) {
        switch (deequName) {
            case "Maximum": {
                return RuleName.HAS_MAX;
            }
            case "Minimum": {
                return RuleName.HAS_MIN;
            }
            case "Mean": {
                return RuleName.HAS_MEAN;
            }
            case "Size": {
                return RuleName.HAS_SIZE;
            }
            case "Completeness": {
                return RuleName.HAS_COMPLETENESS;
            }
            case "Uniqueness": {
                return RuleName.HAS_UNIQUENESS;
            }
            case "hasDistinctness": {
                return RuleName.HAS_DISTINCTNESS;
            }
            case "hasUniqueValueRatio": {
                return RuleName.HAS_UNIQUE_VALUE_RATIO;
            }
        }
        throw new UnsupportedOperationException("Deequ rule not supported");
    }

    public static enum ValidationTimeType {
        VALIDATION_TIME,
        COMMIT_TIME;

    }
}

