/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.engine;

import com.google.common.base.Strings;
import com.logicalclocks.hsfs.EntityEndpointType;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.Storage;
import com.logicalclocks.hsfs.StorageConnector;
import com.logicalclocks.hsfs.TrainingDataset;
import com.logicalclocks.hsfs.TrainingDatasetFeature;
import com.logicalclocks.hsfs.constructor.ServingPreparedStatement;
import com.logicalclocks.hsfs.engine.SparkEngine;
import com.logicalclocks.hsfs.engine.Utils;
import com.logicalclocks.hsfs.metadata.StorageConnectorApi;
import com.logicalclocks.hsfs.metadata.TagsApi;
import com.logicalclocks.hsfs.metadata.TrainingDatasetApi;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainingDatasetEngine {
    private TrainingDatasetApi trainingDatasetApi = new TrainingDatasetApi();
    private TagsApi tagsApi = new TagsApi(EntityEndpointType.TRAINING_DATASET);
    private StorageConnectorApi storageConnectorApi = new StorageConnectorApi();
    private Utils utils = new Utils();
    private static final Logger LOGGER = LoggerFactory.getLogger(TrainingDatasetEngine.class);

    public void save(TrainingDataset trainingDataset, Dataset<Row> dataset, Map<String, String> userWriteOptions, List<String> label) throws FeatureStoreException, IOException {
        trainingDataset.setFeatures(this.utils.parseTrainingDatasetSchema(dataset));
        if (label != null && !label.isEmpty()) {
            for (String l : label) {
                Optional<TrainingDatasetFeature> feature = trainingDataset.getFeatures().stream().filter(f -> f.getName().equals(l)).findFirst();
                if (feature.isPresent()) {
                    feature.get().setLabel(true);
                    continue;
                }
                throw new FeatureStoreException("The specified label `" + l + "` could not be found among the features: " + trainingDataset.getFeatures().stream().map(TrainingDatasetFeature::getName) + ".");
            }
        }
        TrainingDataset apiTD = this.trainingDatasetApi.createTrainingDataset(trainingDataset);
        if (trainingDataset.getVersion() == null) {
            LOGGER.info("VersionWarning: No version provided for creating training dataset `" + trainingDataset.getName() + "`, incremented version to `" + apiTD.getVersion() + "`.");
        }
        trainingDataset.setLocation(apiTD.getLocation());
        trainingDataset.setVersion(apiTD.getVersion());
        trainingDataset.setId(apiTD.getId());
        Map<String, String> writeOptions = SparkEngine.getInstance().getWriteOptions(userWriteOptions, trainingDataset.getDataFormat());
        SparkEngine.getInstance().write(trainingDataset, dataset, writeOptions, SaveMode.Overwrite);
    }

    public void insert(TrainingDataset trainingDataset, Dataset<Row> dataset, Map<String, String> providedOptions, SaveMode saveMode) throws FeatureStoreException {
        this.utils.trainingDatasetSchemaMatch(dataset, trainingDataset.getFeatures());
        Map<String, String> writeOptions = SparkEngine.getInstance().getWriteOptions(providedOptions, trainingDataset.getDataFormat());
        SparkEngine.getInstance().write(trainingDataset, dataset, writeOptions, saveMode);
    }

    public Dataset<Row> read(TrainingDataset trainingDataset, String split, Map<String, String> providedOptions) {
        String path = "";
        path = Strings.isNullOrEmpty((String)split) ? new Path(trainingDataset.getLocation(), "**").toString() : new Path(trainingDataset.getLocation(), split).toString();
        Map<String, String> readOptions = SparkEngine.getInstance().getReadOptions(providedOptions, trainingDataset.getDataFormat());
        return SparkEngine.getInstance().read(trainingDataset.getStorageConnector(), trainingDataset.getDataFormat().toString(), readOptions, path);
    }

    public void addTag(TrainingDataset trainingDataset, String name, Object value) throws FeatureStoreException, IOException {
        this.tagsApi.add(trainingDataset, name, value);
    }

    public Map<String, Object> getTags(TrainingDataset trainingDataset) throws FeatureStoreException, IOException {
        return this.tagsApi.get(trainingDataset);
    }

    public Object getTag(TrainingDataset trainingDataset, String name) throws FeatureStoreException, IOException {
        return this.tagsApi.get(trainingDataset, name);
    }

    public void deleteTag(TrainingDataset trainingDataset, String name) throws FeatureStoreException, IOException {
        this.tagsApi.deleteTag(trainingDataset, name);
    }

    public String getQuery(TrainingDataset trainingDataset, Storage storage, boolean withLabel) throws FeatureStoreException, IOException {
        return this.trainingDatasetApi.getQuery(trainingDataset, withLabel).getStorageQuery(storage);
    }

    public void updateStatisticsConfig(TrainingDataset trainingDataset) throws FeatureStoreException, IOException {
        TrainingDataset apiTD = this.trainingDatasetApi.updateMetadata(trainingDataset, "updateStatsConfig");
        trainingDataset.getStatisticsConfig().setCorrelations(apiTD.getStatisticsConfig().getCorrelations());
        trainingDataset.getStatisticsConfig().setHistograms(apiTD.getStatisticsConfig().getHistograms());
    }

    public void initPreparedStatement(TrainingDataset trainingDataset) throws FeatureStoreException, IOException, SQLException {
        List<ServingPreparedStatement> servingPreparedStatements = this.trainingDatasetApi.getServingPreparedStatement(trainingDataset);
        StorageConnector storageConnector = this.storageConnectorApi.getOnlineStorageConnector(trainingDataset.getFeatureStore());
        Map<String, String> jdbcOptions = storageConnector.getSparkOptionsInt();
        Connection jdbcConnection = DriverManager.getConnection(jdbcOptions.get("url"), jdbcOptions.get("user"), jdbcOptions.get("password"));
        jdbcConnection.setAutoCommit(false);
        trainingDataset.setPreparedStatementConnection(jdbcConnection);
        HashMap<Integer, Map<String, Integer>> preparedStatementParameters = new HashMap<Integer, Map<String, Integer>>();
        TreeMap<Integer, PreparedStatement> preparedStatements = new TreeMap<Integer, PreparedStatement>();
        HashSet<String> servingVectorKeys = trainingDataset.getServingKeys();
        for (ServingPreparedStatement servingPreparedStatement : servingPreparedStatements) {
            preparedStatements.put(servingPreparedStatement.getPreparedStatementIndex(), jdbcConnection.prepareStatement(servingPreparedStatement.getQueryOnline()));
            HashMap parameterIndices = new HashMap();
            servingPreparedStatement.getPreparedStatementParameters().forEach(preparedStatementParameter -> {
                servingVectorKeys.add(preparedStatementParameter.getName());
                parameterIndices.put(preparedStatementParameter.getName(), preparedStatementParameter.getIndex());
            });
            preparedStatementParameters.put(servingPreparedStatement.getPreparedStatementIndex(), parameterIndices);
        }
        trainingDataset.setPreparedStatementParameters(preparedStatementParameters);
        trainingDataset.setPreparedStatements(preparedStatements);
        trainingDataset.setServingKeys(servingVectorKeys);
    }

    public List<Object> getServingVector(TrainingDataset trainingDataset, Map<String, Object> entry) throws SQLException, FeatureStoreException, IOException {
        if (trainingDataset.getPreparedStatements() == null) {
            this.initPreparedStatement(trainingDataset);
        }
        Map<Integer, Map<String, Integer>> preparedStatementParameters = trainingDataset.getPreparedStatementParameters();
        TreeMap<Integer, PreparedStatement> preparedStatements = trainingDataset.getPreparedStatements();
        for (Integer fgId : preparedStatements.keySet()) {
            Map<String, Integer> parameterIndexInStatement = preparedStatementParameters.get(fgId);
            for (String name : entry.keySet()) {
                if (!parameterIndexInStatement.containsKey(name)) continue;
                preparedStatements.get(fgId).setObject(parameterIndexInStatement.get(name), entry.get(name));
            }
        }
        ArrayList<Object> servingVector = new ArrayList<Object>();
        for (Integer preparedStatementIndex : preparedStatements.keySet()) {
            ResultSet results = preparedStatements.get(preparedStatementIndex).executeQuery();
            if (!results.isBeforeFirst()) {
                throw new FeatureStoreException("No data was retrieved from online feature store using input " + entry);
            }
            int columnCount = results.getMetaData().getColumnCount();
            while (results.next()) {
                int index = 1;
                while (index <= columnCount) {
                    servingVector.add(results.getObject(index++));
                }
            }
            results.close();
        }
        trainingDataset.getPreparedStatementConnection().commit();
        return servingVector;
    }
}

