/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.engine;

import com.logicalclocks.hsfs.Feature;
import com.logicalclocks.hsfs.FeatureGroup;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.StorageConnector;
import com.logicalclocks.hsfs.StorageConnectorType;
import com.logicalclocks.hsfs.TrainingDatasetFeature;
import com.logicalclocks.hsfs.TrainingDatasetType;
import com.logicalclocks.hsfs.metadata.HopsworksClient;
import com.logicalclocks.hsfs.metadata.StorageConnectorApi;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.collection.Iterator;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class Utils {
    StorageConnectorApi storageConnectorApi = new StorageConnectorApi();

    public List<Feature> parseFeatureGroupSchema(Dataset<Row> dataset) throws FeatureStoreException {
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (StructField structField : dataset.schema().fields()) {
            Feature f = new Feature(structField.name().toLowerCase(), structField.dataType().catalogString(), false, false);
            if (structField.metadata().contains("description")) {
                f.setDescription(structField.metadata().getString("description"));
            }
            features.add(f);
        }
        return features;
    }

    public List<TrainingDatasetFeature> parseTrainingDatasetSchema(Dataset<Row> dataset) throws FeatureStoreException {
        ArrayList<TrainingDatasetFeature> features = new ArrayList<TrainingDatasetFeature>();
        int index = 0;
        for (StructField structField : dataset.schema().fields()) {
            features.add(new TrainingDatasetFeature(structField.name().toLowerCase(), structField.dataType().catalogString(), index++));
        }
        return features;
    }

    public Dataset<Row> sanitizeFeatureNames(Dataset<Row> dataset) {
        return dataset.select((Column[])Arrays.asList(dataset.columns()).stream().map(f -> functions.col((String)f).alias(f.toLowerCase())).toArray(Column[]::new));
    }

    public void trainingDatasetSchemaMatch(Dataset<Row> dataset, List<TrainingDatasetFeature> features) throws FeatureStoreException {
        StructType tdStructType = new StructType((StructField[])features.stream().sorted(Comparator.comparingInt(TrainingDatasetFeature::getIndex)).map(f -> new StructField(f.getName(), new CatalystSqlParser(null).parseDataType(f.getType()), true, Metadata.empty())).toArray(StructField[]::new));
        if (!dataset.schema().equals((Object)tdStructType)) {
            throw new FeatureStoreException("The Dataframe schema: " + dataset.schema() + " does not match the training dataset schema: " + tdStructType);
        }
    }

    public TrainingDatasetType getTrainingDatasetType(StorageConnector storageConnector) {
        if (storageConnector == null) {
            return TrainingDatasetType.HOPSFS_TRAINING_DATASET;
        }
        if (storageConnector.getStorageConnectorType() == StorageConnectorType.HOPSFS) {
            return TrainingDatasetType.HOPSFS_TRAINING_DATASET;
        }
        return TrainingDatasetType.EXTERNAL_TRAINING_DATASET;
    }

    public String getTableName(FeatureGroup offlineFeatureGroup) {
        return offlineFeatureGroup.getFeatureStore().getName() + "." + offlineFeatureGroup.getName() + "_" + offlineFeatureGroup.getVersion();
    }

    public Seq<String> getPartitionColumns(FeatureGroup offlineFeatureGroup) {
        List partitionCols = offlineFeatureGroup.getFeatures().stream().filter(Feature::getPartition).map(Feature::getName).collect(Collectors.toList());
        return ((Iterator)JavaConverters.asScalaIteratorConverter(partitionCols.iterator()).asScala()).toSeq();
    }

    public Seq<String> getPrimaryColumns(FeatureGroup offlineFeatureGroup) {
        List primaryCols = offlineFeatureGroup.getFeatures().stream().filter(Feature::getPrimary).map(Feature::getName).collect(Collectors.toList());
        return ((Iterator)JavaConverters.asScalaIteratorConverter(primaryCols.iterator()).asScala()).toSeq();
    }

    public String getFgName(FeatureGroup featureGroup) {
        return featureGroup.getName() + "_" + featureGroup.getVersion();
    }

    public String getHiveMetastoreConnector(FeatureGroup featureGroup) throws IOException, FeatureStoreException {
        StorageConnector storageConnector = this.storageConnectorApi.getByName(featureGroup.getFeatureStore(), featureGroup.getFeatureStore().getName());
        String connStr = storageConnector.getConnectionString();
        String pw = HopsworksClient.getInstance().getHopsworksHttpClient().getCertKey();
        return connStr + "sslTrustStore=t_certificate;trustStorePassword=" + pw + ";sslKeyStore=k_certificate;keyStorePassword=" + pw;
    }

    public Long getTimeStampFromDateString(String inputDate) throws FeatureStoreException, ParseException {
        HashMap<Pattern, String> dateFormatPatterns = new HashMap<Pattern, String>(){
            {
                this.put(Pattern.compile("^([0-9]{4})([0-9]{2})([0-9]{2})$"), "yyyyMMdd");
                this.put(Pattern.compile("^([0-9]{4})([0-9]{2})([0-9]{2})([0-9]{2})$"), "yyyyMMddHH");
                this.put(Pattern.compile("^([0-9]{4})([0-9]{2})([0-9]{2})([0-9]{2})([0-9]{2})$"), "yyyyMMddHHmm");
                this.put(Pattern.compile("^([0-9]{4})([0-9]{2})([0-9]{2})([0-9]{2})([0-9]{2})([0-9]{2})$"), "yyyyMMddHHmmss");
            }
        };
        String tempDate = inputDate.replace("/", "").replace("-", "").replace(" ", "").replace(":", "");
        String dateFormatPattern = null;
        for (Pattern pattern : dateFormatPatterns.keySet()) {
            if (!pattern.matcher(tempDate).matches()) continue;
            dateFormatPattern = (String)dateFormatPatterns.get(pattern);
            break;
        }
        if (dateFormatPattern == null) {
            throw new FeatureStoreException("Unable to identify format of the provided date value : " + inputDate);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(dateFormatPattern);
        Long commitTimeStamp = dateFormat.parse(tempDate).getTime();
        return commitTimeStamp;
    }
}

