/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.metadata;

import com.amazon.deequ.constraints.ConstraintStatus;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.logicalclocks.hsfs.metadata.Expectation;
import com.logicalclocks.hsfs.metadata.ValidationResult;
import java.util.List;
import scala.Enumeration;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ExpectationResult {
    private Status status;
    private Expectation expectation;
    private List<ValidationResult> results;

    public static ExpectationResultBuilder builder() {
        return new ExpectationResultBuilder();
    }

    public ExpectationResult() {
    }

    public ExpectationResult(Status status, Expectation expectation, List<ValidationResult> results) {
        this.status = status;
        this.expectation = expectation;
        this.results = results;
    }

    public String toString() {
        return "ExpectationResult(status=" + (Object)((Object)this.getStatus()) + ", expectation=" + this.getExpectation() + ", results=" + this.getResults() + ")";
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Expectation getExpectation() {
        return this.expectation;
    }

    public void setExpectation(Expectation expectation) {
        this.expectation = expectation;
    }

    public List<ValidationResult> getResults() {
        return this.results;
    }

    public void setResults(List<ValidationResult> results) {
        this.results = results;
    }

    public static class ExpectationResultBuilder {
        private Status status;
        private Expectation expectation;
        private List<ValidationResult> results;

        ExpectationResultBuilder() {
        }

        public ExpectationResultBuilder status(Status status) {
            this.status = status;
            return this;
        }

        public ExpectationResultBuilder expectation(Expectation expectation) {
            this.expectation = expectation;
            return this;
        }

        public ExpectationResultBuilder results(List<ValidationResult> results) {
            this.results = results;
            return this;
        }

        public ExpectationResult build() {
            return new ExpectationResult(this.status, this.expectation, this.results);
        }

        public String toString() {
            return "ExpectationResult.ExpectationResultBuilder(status=" + (Object)((Object)this.status) + ", expectation=" + this.expectation + ", results=" + this.results + ")";
        }
    }

    public static enum Status {
        NONE("None", 0),
        SUCCESS("Success", 1),
        WARNING("Warning", 2),
        FAILURE("Failure", 3);

        private final String name;
        private final int severity;

        private Status(String name, int severity) {
            this.name = name;
            this.severity = severity;
        }

        public int getSeverity() {
            return this.severity;
        }

        public static Status fromString(String name) {
            return Status.valueOf(name.toUpperCase());
        }

        public static Status fromDeequStatus(Enumeration.Value status) {
            if (status == ConstraintStatus.Failure()) {
                return FAILURE;
            }
            if (status == ConstraintStatus.Success()) {
                return SUCCESS;
            }
            return NONE;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

