/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.metadata;

import com.damnhandy.uri.template.UriTemplate;
import com.logicalclocks.hsfs.FeatureStore;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.StorageConnector;
import com.logicalclocks.hsfs.metadata.HopsworksClient;
import java.io.IOException;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpGet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageConnectorApi {
    private static final String CONNECTOR_PATH = "/storageconnectors";
    private static final String CONNECTOR_TYPE_PATH = "/storageconnectors{/connType}{/name}{?temporaryCredentials}";
    private static final String ONLINE_CONNECTOR_PATH = "/storageconnectors/onlinefeaturestore";
    private static final Logger LOGGER = LoggerFactory.getLogger(StorageConnectorApi.class);

    public StorageConnector getByName(FeatureStore featureStore, String name) throws IOException, FeatureStoreException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/storageconnectors{/connType}{/name}{?temporaryCredentials}";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)featureStore.getProjectId()).set("fsId", (Object)featureStore.getId()).set("name", (Object)name).set("temporaryCredentials", (Object)true).expand();
        LOGGER.info("Sending metadata request: " + uri);
        return hopsworksClient.handleRequest((HttpRequest)new HttpGet(uri), StorageConnector.class);
    }

    public StorageConnector getOnlineStorageConnector(FeatureStore featureStore) throws IOException, FeatureStoreException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/storageconnectors/onlinefeaturestore";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)featureStore.getProjectId()).set("fsId", (Object)featureStore.getId()).expand();
        LOGGER.info("Sending metadata request: " + uri);
        return hopsworksClient.handleRequest((HttpRequest)new HttpGet(uri), StorageConnector.class);
    }
}

