/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.metadata.validation;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.logicalclocks.hsfs.metadata.RuleDefinition;
import com.logicalclocks.hsfs.metadata.RulesApi;
import com.logicalclocks.hsfs.metadata.validation.Level;
import com.logicalclocks.hsfs.metadata.validation.RuleName;
import com.logicalclocks.hsfs.metadata.validation.ValueType;
import java.util.Arrays;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Rule {
    private final RulesApi featureStoreRulesApi = new RulesApi();
    private RuleName name;
    private Level level;
    private Double min;
    private Double max;
    private String pattern;
    private ValueType acceptedType;
    private String[] legalValues;

    public static RuleBuilder createRule(RuleDefinition rule) {
        return Rule.builder().rule(rule);
    }

    public static RuleBuilder createRule(RuleName name) {
        return Rule.builder().name(name);
    }

    public Rule(RuleName name, RuleDefinition rule, Level level, Double min, Double max, String pattern, ValueType acceptedType, String[] legalValues) {
        this.name = rule != null ? rule.getName() : name;
        this.level = level;
        this.min = min;
        this.max = max;
        this.pattern = pattern;
        this.acceptedType = acceptedType;
        this.legalValues = legalValues;
    }

    public static RuleBuilder builder() {
        return new RuleBuilder();
    }

    public Rule() {
    }

    public Rule(RuleName name, Level level, Double min, Double max, String pattern, ValueType acceptedType, String[] legalValues) {
        this.name = name;
        this.level = level;
        this.min = min;
        this.max = max;
        this.pattern = pattern;
        this.acceptedType = acceptedType;
        this.legalValues = legalValues;
    }

    public String toString() {
        return "Rule(featureStoreRulesApi=" + this.featureStoreRulesApi + ", name=" + (Object)((Object)this.getName()) + ", level=" + (Object)((Object)this.getLevel()) + ", min=" + this.getMin() + ", max=" + this.getMax() + ", pattern=" + this.getPattern() + ", acceptedType=" + (Object)((Object)this.getAcceptedType()) + ", legalValues=" + Arrays.deepToString(this.getLegalValues()) + ")";
    }

    public RuleName getName() {
        return this.name;
    }

    public void setName(RuleName name) {
        this.name = name;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public Double getMin() {
        return this.min;
    }

    public void setMin(Double min) {
        this.min = min;
    }

    public Double getMax() {
        return this.max;
    }

    public void setMax(Double max) {
        this.max = max;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public ValueType getAcceptedType() {
        return this.acceptedType;
    }

    public void setAcceptedType(ValueType acceptedType) {
        this.acceptedType = acceptedType;
    }

    public String[] getLegalValues() {
        return this.legalValues;
    }

    public void setLegalValues(String[] legalValues) {
        this.legalValues = legalValues;
    }

    public static class RuleBuilder {
        private RuleName name;
        private RuleDefinition rule;
        private Level level;
        private Double min;
        private Double max;
        private String pattern;
        private ValueType acceptedType;
        private String[] legalValues;

        RuleBuilder() {
        }

        public RuleBuilder name(RuleName name) {
            this.name = name;
            return this;
        }

        public RuleBuilder rule(RuleDefinition rule) {
            this.rule = rule;
            return this;
        }

        public RuleBuilder level(Level level) {
            this.level = level;
            return this;
        }

        public RuleBuilder min(Double min) {
            this.min = min;
            return this;
        }

        public RuleBuilder max(Double max) {
            this.max = max;
            return this;
        }

        public RuleBuilder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public RuleBuilder acceptedType(ValueType acceptedType) {
            this.acceptedType = acceptedType;
            return this;
        }

        public RuleBuilder legalValues(String[] legalValues) {
            this.legalValues = legalValues;
            return this;
        }

        public Rule build() {
            return new Rule(this.name, this.rule, this.level, this.min, this.max, this.pattern, this.acceptedType, this.legalValues);
        }

        public String toString() {
            return "Rule.RuleBuilder(name=" + (Object)((Object)this.name) + ", rule=" + this.rule + ", level=" + (Object)((Object)this.level) + ", min=" + this.min + ", max=" + this.max + ", pattern=" + this.pattern + ", acceptedType=" + (Object)((Object)this.acceptedType) + ", legalValues=" + Arrays.deepToString(this.legalValues) + ")";
        }
    }
}

