/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.logicalclocks.hsfs.FeatureGroup;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.OnDemandFeatureGroup;
import com.logicalclocks.hsfs.StorageConnector;
import com.logicalclocks.hsfs.TrainingDataset;
import com.logicalclocks.hsfs.engine.SparkEngine;
import com.logicalclocks.hsfs.metadata.Expectation;
import com.logicalclocks.hsfs.metadata.ExpectationsApi;
import com.logicalclocks.hsfs.metadata.FeatureGroupApi;
import com.logicalclocks.hsfs.metadata.StorageConnectorApi;
import com.logicalclocks.hsfs.metadata.TrainingDatasetApi;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConverters;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;

public class FeatureStore {
    @JsonProperty(value="featurestoreId")
    private Integer id;
    @JsonProperty(value="featurestoreName")
    private String name;
    private Integer projectId;
    private FeatureGroupApi featureGroupApi = new FeatureGroupApi();
    private TrainingDatasetApi trainingDatasetApi = new TrainingDatasetApi();
    private StorageConnectorApi storageConnectorApi = new StorageConnectorApi();
    private ExpectationsApi expectationsApi = new ExpectationsApi();
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureStore.class);
    private static final Integer DEFAULT_VERSION = 1;

    public FeatureGroup getFeatureGroup(@NonNull String name, @NonNull Integer version) throws FeatureStoreException, IOException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        return this.featureGroupApi.getFeatureGroup(this, name, version);
    }

    public FeatureGroup getFeatureGroup(String name) throws FeatureStoreException, IOException {
        LOGGER.info("VersionWarning: No version provided for getting feature group `" + name + "`, defaulting to `" + DEFAULT_VERSION + "`.");
        return this.getFeatureGroup(name, DEFAULT_VERSION);
    }

    public OnDemandFeatureGroup getOnDemandFeatureGroup(@NonNull String name, @NonNull Integer version) throws FeatureStoreException, IOException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        return this.featureGroupApi.getOnDemandFeatureGroup(this, name, version);
    }

    public OnDemandFeatureGroup getOnDemandFeatureGroup(String name) throws FeatureStoreException, IOException {
        LOGGER.info("VersionWarning: No version provided for getting feature group `" + name + "`, defaulting to `" + DEFAULT_VERSION + "`.");
        return this.getOnDemandFeatureGroup(name, DEFAULT_VERSION);
    }

    public Dataset<Row> sql(String query) {
        return SparkEngine.getInstance().sql(query);
    }

    public StorageConnector getStorageConnector(String name) throws FeatureStoreException, IOException {
        return this.storageConnectorApi.getByName(this, name);
    }

    public StorageConnector.JdbcConnector getJdbcConnector(String name) throws FeatureStoreException, IOException {
        return (StorageConnector.JdbcConnector)this.storageConnectorApi.getByName(this, name);
    }

    public StorageConnector.S3Connector getS3Connector(String name) throws FeatureStoreException, IOException {
        return (StorageConnector.S3Connector)this.storageConnectorApi.getByName(this, name);
    }

    public StorageConnector.HopsFsConnector getHopsFsConnector(String name) throws FeatureStoreException, IOException {
        return (StorageConnector.HopsFsConnector)this.storageConnectorApi.getByName(this, name);
    }

    public StorageConnector.RedshiftConnector getRedshiftConnector(String name) throws FeatureStoreException, IOException {
        return (StorageConnector.RedshiftConnector)this.storageConnectorApi.getByName(this, name);
    }

    public StorageConnector.SnowflakeConnector getSnowflakeConnector(String name) throws FeatureStoreException, IOException {
        return (StorageConnector.SnowflakeConnector)this.storageConnectorApi.getByName(this, name);
    }

    public StorageConnector.AdlsConnector getAdlsConnector(String name) throws FeatureStoreException, IOException {
        return (StorageConnector.AdlsConnector)this.storageConnectorApi.getByName(this, name);
    }

    public StorageConnector.JdbcConnector getOnlineStorageConnector() throws FeatureStoreException, IOException {
        return this.storageConnectorApi.getOnlineStorageConnector(this);
    }

    public FeatureGroup.FeatureGroupBuilder createFeatureGroup() {
        return FeatureGroup.builder().featureStore(this);
    }

    public OnDemandFeatureGroup.OnDemandFeatureGroupBuilder createOnDemandFeatureGroup() {
        return OnDemandFeatureGroup.builder().featureStore(this);
    }

    public TrainingDataset.TrainingDatasetBuilder createTrainingDataset() {
        return TrainingDataset.builder().featureStore(this);
    }

    public Expectation.ExpectationBuilder createExpectation() {
        return Expectation.builder().featureStore(this);
    }

    public TrainingDataset getTrainingDataset(@NonNull String name, @NonNull Integer version) throws FeatureStoreException, IOException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        return this.trainingDatasetApi.get(this, name, version);
    }

    public TrainingDataset getTrainingDataset(String name) throws FeatureStoreException, IOException {
        LOGGER.info("VersionWarning: No version provided for getting training dataset `" + name + "`, defaulting to `" + DEFAULT_VERSION + "`.");
        return this.getTrainingDataset(name, DEFAULT_VERSION);
    }

    public Seq<Expectation> createExpectations(Seq<Expectation> expectations) throws FeatureStoreException, IOException {
        ArrayList<Expectation> newExpectations = new ArrayList<Expectation>();
        List expectationsList = (List)JavaConverters.seqAsJavaListConverter(expectations).asJava();
        for (Expectation expectation : expectationsList) {
            expectation = this.expectationsApi.put(this, expectation);
            newExpectations.add(expectation);
        }
        return ((Buffer)JavaConverters.asScalaBufferConverter(newExpectations).asScala()).toSeq();
    }

    public Expectation getExpectation(String name) throws FeatureStoreException, IOException {
        return this.expectationsApi.get(this, name);
    }

    public Seq<Expectation> getExpectations() throws FeatureStoreException, IOException {
        return ((Buffer)JavaConverters.asScalaBufferConverter(this.expectationsApi.get(this)).asScala()).toSeq();
    }

    public void deleteExpectation(Expectation expectation) throws FeatureStoreException, IOException {
        this.deleteExpectation(expectation.getName());
    }

    public void deleteExpectation(String name) throws FeatureStoreException, IOException {
        this.expectationsApi.delete(this, name);
    }

    public void deleteExpectations(Seq<Expectation> expectations) throws FeatureStoreException, IOException {
        for (Expectation expectation : (List)JavaConverters.seqAsJavaListConverter(expectations).asJava()) {
            this.deleteExpectation(expectation);
        }
    }

    public String toString() {
        return "FeatureStore{id=" + this.id + ", name='" + this.name + '\'' + ", projectId=" + this.projectId + ", featureGroupApi=" + this.featureGroupApi + '}';
    }

    public Integer getId() {
        return this.id;
    }

    @JsonProperty(value="featurestoreId")
    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    @JsonProperty(value="featurestoreName")
    public void setName(String name) {
        this.name = name;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }
}

